/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ts.query.QueryResult;

public class QueryResultList
implements Serializable {
    static final long serialVersionUID = 7570497809387060417L;
    private final List<QueryResult> resultLst = new LinkedList<QueryResult>();
    private long spentTimeMillis = -1L;

    public void addResult(QueryResult queryResult) {
        assert (queryResult != null) : "@param:result is null.";
        this.resultLst.add(queryResult);
    }

    public List<QueryResult> getResults(String string) {
        LinkedList<QueryResult> linkedList = new LinkedList<QueryResult>();
        for (QueryResult queryResult : this.resultLst) {
            if (!queryResult.getQueryId().equals(string)) continue;
            linkedList.add(queryResult);
        }
        return linkedList;
    }

    public QueryResult getFirstResult(String string) {
        for (QueryResult queryResult : this.resultLst) {
            if (!queryResult.getQueryId().equals(string)) continue;
            return queryResult;
        }
        return null;
    }

    public QueryResult getLastResult(String string) {
        for (int i = this.resultLst.size() - 1; i >= 0; --i) {
            QueryResult queryResult = this.resultLst.get(i);
            if (!queryResult.getQueryId().equals(string)) continue;
            return queryResult;
        }
        return null;
    }

    public QueryResult getResultAt(int n) {
        return this.resultLst.get(n);
    }

    public int countResults() {
        return this.resultLst.size();
    }

    public List<QueryResult> getAllResults() {
        return Collections.unmodifiableList(this.resultLst);
    }

    public QueryResult getFirstResult() {
        if (this.resultLst.size() > 0) {
            return this.resultLst.get(0);
        }
        return null;
    }

    public QueryResult getLastResult() {
        if (this.resultLst.size() > 0) {
            return this.resultLst.get(this.resultLst.size() - 1);
        }
        return null;
    }

    public boolean isSuccess() {
        for (QueryResult queryResult : this.resultLst) {
            if (queryResult.isSuccess()) continue;
            return false;
        }
        return true;
    }

    public long getSpentTimeMillis() {
        if (this.spentTimeMillis >= 0L) {
            return this.spentTimeMillis;
        }
        long l = 0L;
        for (QueryResult queryResult : this.resultLst) {
            l += queryResult.getSpentTimeMillis();
        }
        return l;
    }

    public void setSpentTimeMillis(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("@param:millis is negative.");
        }
        this.spentTimeMillis = l;
    }

    public void resetSpentTimeMillis() {
        this.spentTimeMillis = -1L;
    }
}

