/*
 * IllegalKeyException class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource;

/**
 * w肳ꂽL[sȏꍇɃX[ONXB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:49 $
 */
public class IllegalKeyException extends RuntimeException
{
  /** VAo[WIDB */
  static final long serialVersionUID = -4634194841743832702L;

  /** ȎΏۂƂȂL[B */
  private String key_ ;

  /**
   * ȎΏۂƂȂL[ɂƂRXgN^B
   * <br>
   * w肳ꂽL[k̏ꍇ́Aɋ󕶎ݒ肷B
   *
   * @param  key L[B
   */
  public IllegalKeyException(String key)
  {
    key_ = (key != null) ? key : "";
  }

  /**
   * ȎΏۂƂȂL[ƗObZ[WɂƂRXgN^B
   * <br>
   * w肳ꂽL[k̏ꍇ́Aɋ󕶎ݒ肷B
   * w肳ꂽObZ[Wk̏ꍇ́Â܂܃kݒ肳B
   *
   * @param  key L[B
   * @param  msg ObZ[WB
   */
  public IllegalKeyException(String key, String msg)
  {
    super(msg);
    key_ = (key != null) ? key : "";
  }

  /**
   * ȎΏۂƂȂL[ƗObZ[WAƂȂ{@link java.lang.Throwable
   * Throwable} IuWFNgɂƂRXgN^B
   * <br>
   * w肳ꂽL[k̏ꍇ́Aɋ󕶎ݒ肷B
   * w肳ꂽObZ[Wk̏ꍇ́Â܂܃kݒ肳B
   * w肳ꂽ{@link java.lang.Throwable}IuWFNgk̏ꍇ́Â܂
   * kݒ肳B
   *
   * @param  key L[B
   * @param  msg ObZ[WB
   * @param  cause ƂȂ{@link java.lang.Throwable}IuWFNgB
   */
  public IllegalKeyException(String key, String msg, Throwable cause)
  {
    super(msg, cause);
    key_ = (key != null) ? key : "";
  }

  /**
   * ȎΏۂƂȂL[ƌƂȂ{@link java.lang.Throwable}IuWFNg
   * ɂƂRXgN^B
   * <br>
   * w肳ꂽL[k̏ꍇ́Aɋ󕶎ݒ肷B
   * w肳ꂽ{@link java.lang.Throwable}IuWFNgk̏ꍇ́Â܂
   * kݒ肳B
   *
   * @param  key L[B
   * @param  cause ƂȂ{@link java.lang.Throwable}IuWFNgB
   */
  public IllegalKeyException(String key, Throwable cause)
  {
    super(cause);
    key_ = (key != null) ? key : "";
  }

  /**
   * ȎΏۂƂȂL[擾B
   *
   * @return L[B
   */
  public String getKey()
  {
    return key_ ;
  }

  /**
   * O̓e\擾B
   *
   * @return O̓e\B
   */
  public String toString()
  {
    String s = getMessage();
    if (s == null) {
      s = "The key is illegal";
    }

    return getClass().getName() + ": " + s + ": " + getKey();
  }
}
