/*
 * FileOperation00EtcTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.*;
import ts.tester.function.print.*;
import java.io.*;

/**
 * {@link ts.util.file.FileOperation FileOperation}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:46 $
 */
public class FileOperation00EtcTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      run(FileOperation00EtcTest.class, (args.length > 0) ? args[0] : null);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  final File WORKDIR = new File("test/data/ts/util/file/FileOperation");

  @Override
  protected void preInvocation(String method)
  {
    WORKDIR.mkdirs();
  }

  @Override
  protected void postInvocation(String method)
  {
    try {
      FileOperation.deleteRecursive(WORKDIR);
    } catch (Exception e) {}
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgERXgN^̊mFB");

    NOTNULL(new FileOperation());
  }

  public void createDir()
  {
    MSG("쐬fBNg̍ŏʃfBNg擾");

    File dir = new File(WORKDIR, "aaa/bbb/ccc");
    FALSE(dir.exists());

    try {
      FileOperation fop = new FileOperation();
      ObjectInspector oi = new ObjectInspector(this);
      File f = (File) oi.invokeMethod(fop, "createDir", File.class, dir);

      TRUE(dir.exists());
      EQUAL(f, new File(WORKDIR, "aaa"));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createDir_0()
  {
    MSG("k̏ꍇB");

    try {
      FileOperation fop = new FileOperation();
      ObjectInspector oi = new ObjectInspector(this);
      File f = (File) oi.invokeMethod(fop, "createDir", File.class, null);
      NULL(f);
    } catch (AssertionError e) {
      NG(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createDir_1()
  {
    MSG("̃t@C݂ꍇB");

    File dir = new File(WORKDIR, "aaa/bbb/ccc");
    dir.mkdirs();
    TRUE(dir.exists());
    try {
      FileOperation fop = new FileOperation();
      ObjectInspector oi = new ObjectInspector(this);
      File f = (File) oi.invokeMethod(fop, "createDir", File.class, dir);
      TRUE(dir.exists());
      NULL(f);
    } catch (Exception e) {
      NG(e);
    }

    File file = new File(WORKDIR, "abc.txt");
    try {
      file.createNewFile();
    } catch (Exception e) {
      NG(e);
    }
    TRUE(file.exists());
    try {
      FileOperation fop = new FileOperation();
      ObjectInspector oi = new ObjectInspector(this);
      File f = (File) oi.invokeMethod(fop, "createDir", File.class, file);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createNewFile_path()
  {
    MSG("t@C쐬B");

    File f0 = new File(WORKDIR.getPath() + "/aaa/bbb/ccc/ddd.eee");
    FALSE(f0.exists());

    try {
      File f1 = FileOperation.createNewFile(
        WORKDIR.getPath() + "/aaa/bbb/ccc/ddd.eee");
      TRUE(f1.exists());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createNewFile_path_1()
  {
    MSG("k̏ꍇB");

    try {
      FileOperation.createNewFile((String)null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createNewFile_path_2()
  {
    MSG("t@Cɑ݂ĂꍇB");

    File f0 = new File(WORKDIR.getPath() + "/aaa/bbb/ccc/ddd.eee");
    FALSE(f0.exists());

    try {
      File f1 = FileOperation.createNewFile(
        WORKDIR.getPath() + "/aaa/bbb/ccc/ddd.eee");
      TRUE(f1.exists());
    } catch (Exception e) {
      NG(e);
    }

    try {
      File f2 = FileOperation.createNewFile(
        WORKDIR.getPath() + "/aaa/bbb/ccc/ddd.eee");
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createNewFile_file()
  {
    MSG("t@C쐬B");

    File f0 = new File(WORKDIR.getPath() + "/aaa/bbb/ccc/ddd.eee");
    FALSE(f0.exists());

    try {
      File f1 = FileOperation.createNewFile(f0);
      TRUE(f1.exists());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createNewFile_file_1()
  {
    try {
      FileOperation.createNewFile((File) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createNewFile_file_2()
  {
    MSG("t@Cɑ݂ĂꍇB");

    File f0 = new File(WORKDIR, "aaa/bbb/ccc/ddd.eee");
    FALSE(f0.exists());

    try {
      File f1 = FileOperation.createNewFile(f0);
      TRUE(f1.exists());
    } catch (Exception e) {
      NG(e);
    }

    try {
      File f2 = FileOperation.createNewFile(f0);
      NG();
    } catch (FileAlreadyExistsException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createNewFile_file_3()
  {
    MSG("쐬悤Ƃt@C̏ʃt@Cʏ̃t@C̏ꍇB");

    File f0 = new File(WORKDIR, "aaa/bbb/ccc");
    File f1 = new File(WORKDIR, "aaa");

    try {
      FileOperation.createNewFile(f1);
    } catch (Exception e) {
      NG(e);
    }
    TRUE(f1.exists());
    FALSE(f1.isDirectory());

    try {
      FileOperation.createNewFile(f0);
    } catch (IOException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void createNewFile_file_4()
  {
    MSG("t@C̍쐬ɎsB");

    File f0 = new File(WORKDIR, "aaa/bbb/ccc") {
      final static long serialVersionUID = 1L;
      public boolean createNewFile() {
        return false;
      }
    };

    try {
      FileOperation.createNewFile(f0);
    } catch (IOException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getDestinationFile()
  {
    MSG("ړĨt@CFileIuWFNg擾B");

    File srcFile = new File(WORKDIR, "a/b/c/d/e/f/g.txt");
    File srcDir = new File(WORKDIR, "a/b/c");
    File dstDir = new File(WORKDIR, "x/y");

    try {
      File dstFile = FileOperation.getDestinationFile(srcFile, srcDir, dstDir);
      EQUAL(dstFile, new File(WORKDIR, "x/y/d/e/f/g.txt"));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getDestinationFile_01()
  {
    MSG("k̏ꍇB");

    File srcFile = new File(WORKDIR, "a/b/c/d/e/f/g.txt");
    File srcDir = new File(WORKDIR, "a/b/c");
    File dstDir = new File(WORKDIR, "x/y");

    try {
      File dstFile = FileOperation.getDestinationFile(null, srcDir, dstDir);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      File dstFile = FileOperation.getDestinationFile(srcFile, null, dstDir);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
    try {
      File dstFile = FileOperation.getDestinationFile(srcFile, srcDir, null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getDestinationFile_02()
  {
    MSG("t@CfBNgȉ̃t@CłȂꍇB");

    File srcFile = new File(WORKDIR, "a/b/c/d/e/f/g.txt");
    File srcDir = new File(WORKDIR, "l/m/n");
    File dstDir = new File(WORKDIR, "x/y");

    try {
      FileOperation.getDestinationFile(srcFile, srcDir, dstDir);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getDestinationFile_03()
  {
    MSG("t@CƊt@CꍇB");

    File srcFile = new File(WORKDIR, "a/b/c/d/e/f");
    File srcDir = new File(WORKDIR, "a/b/c/d/e/f");
    File dstDir = new File(WORKDIR, "x/y");

    try {
      File dstFile = FileOperation.getDestinationFile(srcFile, srcDir, dstDir);
      EQUAL(dstFile, dstDir);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getDestinationFile_04()
  {
    MSG("t@C̃pXt@CZꍇB");

    File srcFile = new File(WORKDIR, "a/b/c/d");
    File srcDir = new File(WORKDIR, "a/b/c/d/e/f");
    File dstDir = new File(WORKDIR, "x/y");

    try {
      FileOperation.getDestinationFile(srcFile, srcDir, dstDir);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}

