/*
 * FileFilterNotTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.io.*;

/**
 * {@link ts.util.file.FileFilterNot FileFilterNot}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:45 $
 */
public class FileFilterNotTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(FileFilterNotTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("FileFilterNot NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor_filefilter()
  {
    MSG("t@CEtB^ɂƂRXgN^B");

    FileFilter filterNot = new FileFilterNot(new DirectoryEmptyFilter());
    NOTNULL(filterNot);
  }

  public void constructor_filefilter_1()
  {
    MSG("k̏ꍇB");

    try {
      new FileFilterNot(null);
      NG();
    } catch (NullPointerException e) {
      OK(e);
    }
  }

  public void accept()
  {
    MSG("ێtB^̔茋ʂtɂȂ邩mFB");

    File basedir = new File("test/data/ts/util/file/FileFilterNot");
    File emptydir = new File(basedir, "emptydir");
    File adir = new File(basedir, "adir");
    File afile = new File(adir, "afile.txt");

    try {
      basedir.mkdirs();
      emptydir.mkdir();
      adir.mkdir();
      afile.createNewFile();
    } catch (IOException e) {
      NG(e);
    }

    FileFilter filter = new FileFilterNot(new DirectoryEmptyFilter());
    TRUE (filter.accept(basedir));
    FALSE(filter.accept(emptydir));
    TRUE (filter.accept(adir));
    TRUE (filter.accept(afile));

    filter = new FileFilterNot(new FileTypeFilter(FileType.File));
    TRUE (filter.accept(basedir));
    TRUE (filter.accept(emptydir));
    TRUE (filter.accept(adir));
    FALSE(filter.accept(afile));

    filter = new FileFilterNot(new FileTypeFilter(FileType.Directory));
    FALSE(filter.accept(basedir));
    FALSE(filter.accept(emptydir));
    FALSE(filter.accept(adir));
    TRUE (filter.accept(afile));

    try {
      FileOperation.deleteRecursive(basedir);
    } catch (IOException e) {
      NG(e);
    }
  }
}

