/*
 * Range class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.io.Serializable;

/**
 * ͈̓NXB
 * <br>
 * JnlƏIl̓̒lA͈͓ɂ邩ǂ𒲂ׂ郁\bh
 * A͈͂̍߂郁\bhȂǂpӂB
 * <br>
 * JnlyяIlɃkݒ肵Ă͂ȂB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2011-08-01 15:29:30 $
 */
public class Range<T extends Comparable<T>> implements Serializable
{
  /** VAEo[WԍB */
  static final long serialVersionUID = 6469174627650758718L;

  /** JnlB */
  private T start_ ;

  /** IlB */
  private T end_ ;

  /**
   * JnlƏIlɂƂRXgN^B
   * <br>
   * JnlƏIl̑召tɎw肳ꂽꍇ́AւĐݒ肷B
   *
   * @param  start JnlB
   * @param  end IlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public Range(T start, T end)
  {
    setRange(start, end);
  }

  /**
   * JnlƏIlݒ肷B
   * <br>
   * JnlƏIl̑召tɎw肳ꂽꍇ́AւĐݒ肷B
   *
   * @param  start JnlB
   * @param  end IlB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void setRange(T start, T end)
  {
    assert (start != null) : "@param:start is null.";
    assert (end != null) : "@param:end is null.";

    if (start.compareTo(end) <= 0) {
      start_ = start;
      end_ = end;
    }
    else {
      start_ = end;
      end_ = start;
    }
  }

  /**
   * ͈͂̊Jnl擾B
   *
   * @return JnlB
   */
  public T getStart()
  {
    return start_ ;
  }

  /**
   * ͈͂̏Il擾B
   *
   * @return IlB
   */
  public T getEnd()
  {
    return end_ ;
  }

  /**
   * ̃IuWFNg̓ew肳ꂽIuWFNgƓǂ𔻒肷B
   * <br>
   * ꍇ<tt>true</tt>AقȂꍇ<tt>false</tt>ԂB
   *
   * @param  obj 肷IuWFNgB
   * @return ꍇ<tt>true</tt>AقȂꍇ<tt>false</tt>B
   */
  public boolean equals(Object obj)
  {
    if (obj == null || !(obj instanceof Range)) {
      return false;
    }

    Range range = Range.class.cast(obj);

    if (! getStart().equals(range.getStart())) {
      return false;
    }

    if (! getEnd().equals(range.getEnd())) {
      return false;
    }

    return true;
  }

  /**
   * IuWFNg̓e擾B
   *
   * @return IuWFNg̓eB
   */
  public String toString()
  {
    StringBuilder buf = new StringBuilder();
    buf.append("{");
    buf.append(getStart().toString());
    buf.append("~");
    buf.append(getEnd().toString());
    buf.append("}");
    return buf.toString();
  }

  /**
   * w肳ꂽl͈͓ɂ邩ǂ𔻒肷B
   *
   * @param  value 肳lB
   * @return ͈͓ɂꍇtrueAłȂfalseԂB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public boolean encompass(T value)
  {
    assert (value != null) : "@param:value is null.";

    if (getStart().compareTo(value) > 0) {
      return false;
    }
    else if (getEnd().compareTo(value) < 0) {
      return false;
    }
    else {
      return true;
    }
  }

  /**
   * w肳ꂽ͈͂ÃIuWFNg͈̎͂Ɋ܂܂Ă邩ǂ𔻒
   * B
   *
   * @param range 肳͈́B
   * @return ͈͓ɂꍇtrueAłȂfalseԂB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public boolean encompass(Range<T> range)
  {
    assert (range != null) : "@param:range is null.";

    if (getStart().compareTo(range.getStart()) > 0) {
      return false;
    }
    else if (getEnd().compareTo(range.getEnd()) < 0) {
      return false;
    }
    else {
      return true;
    }
  }

  /**
   * w肳ꂽ͈͂Ƃ̃IuWFNg͈̎͂dȂ͈͂擾B
   * <br>
   * dȂ͈͂Ȃꍇ́AkԂB
   *
   * @param  range ͈́B
   * @return ͈̔͂Ƃ̃IuWFNgdȂ͈́B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public Range<T> intersectsWith(Range<T> range)
  {
    assert (range != null) : "@param:range is null.";

    T start = (getStart().compareTo(range.getStart()) > 0) ?
      getStart() : range.getStart();
    T end = (getEnd().compareTo(range.getEnd()) < 0) ?
      getEnd() : range.getEnd();

    if (start.compareTo(end) > 0) {
      return null;
    }

    return new Range<T>(start, end);
  }

  /**
   * w肳ꂽl܂ނ悤ɁÃIuWFNg͈̎͂g͈͂擾
   * B
   * <br>
   * w肳ꂽl܂łꍇ́ÃIuWFNgƓ͈͂ԂB
   *
   * @param  value lB
   * @return w肳ꂽl܂ނ悤Ɋgꂽ͈́B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public Range<T> expandsWith(T value)
  {
    assert (value != null) : "@param:value is null.";

    if (getStart().compareTo(value) > 0) {
      return new Range<T>(value, getEnd());
    }
    else if (getEnd().compareTo(value) < 0) {
      return new Range<T>(getStart(), value);
    }
    else {
      return new Range<T>(getStart(), getEnd());
    }
  }

  /**
   * w肳ꂽ͈͂܂ނ悤ɁÃIuWFNg͈̎͂g͈͂擾
   * B
   * <br>
   * w肳ꂽ͈͂܂łꍇ́ÃIuWFNgƓ͈͂ԂB
   *
   * @param  range ͈́B
   * @return w肳ꂽ͈͂܂ނ悤Ɋgꂽ͈́B
   * @throws AssertionError k̏ꍇ(fobO[ĥ݁jB
   */
  public Range<T> expandsWith(Range<T> range)
  {
    assert (range != null) : "@param:range is null.";

    T start = (getStart().compareTo(range.getStart()) < 0) ?
      getStart() : range.getStart();
    T end = (getEnd().compareTo(range.getEnd()) > 0) ?
      getEnd() : range.getEnd(); 

    return new Range<T>(start, end);
  }
}
