/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import ts.tester.function.FunctionTester;
import ts.tester.function.Result;
import ts.tester.function.ResultType;

public class CheckResult
extends Result
implements Serializable {
    static final long serialVersionUID = -9139232646213087026L;
    public static final transient Object UNSET = new Unset();
    public static final transient Object NODATA = new Nodata();
    private ResultType type_ = ResultType.OK;
    private String method_ = "";
    private String message_ = "";
    private transient Object expectValue_ = UNSET;
    private transient Object resultValue_ = UNSET;
    private String fileName_ = "";
    private int lineNumber_ = 1;

    protected CheckResult() {
    }

    public CheckResult(String string) {
        this.setName(string);
    }

    @Override
    public int count(ResultType resultType) {
        assert (resultType != null) : "@param:type is null.";
        return this.is(resultType) ? 1 : 0;
    }

    public boolean is(ResultType resultType) {
        assert (resultType != null) : "@param:type is null.";
        return this.type_.equals((Object)resultType);
    }

    public void setMethod(String string) {
        assert (string != null) : "@param:method is null.";
        this.method_ = string;
    }

    public String getMethod() {
        return this.method_;
    }

    public void setMessage(String string) {
        assert (string != null) : "@param:message is null.";
        this.message_ = string;
    }

    public String getMessage() {
        return this.message_;
    }

    public void setResultValue(Object object) {
        assert (object != UNSET) : "@param:value is not allowed to set UNSET.";
        this.resultValue_ = object;
    }

    public Object getResultValue() {
        return this.resultValue_;
    }

    public void setExpectValue(Object object) {
        assert (object != UNSET) : "@param:value is not allowed to set UNSET.";
        this.expectValue_ = object;
    }

    public Object getExpectValue() {
        return this.expectValue_;
    }

    public String getFileName() {
        return this.fileName_;
    }

    public int getLineNumber() {
        return this.lineNumber_;
    }

    final void obtainFilePosition(Class<? extends FunctionTester> clazz, String string) {
        assert (clazz != null) : "@param:testerClass is null.";
        assert (string != null) : "@param:methodName is null.";
        this.fileName_ = "";
        this.lineNumber_ = 1;
        try {
            throw new Throwable();
        }
        catch (Throwable throwable) {
            try {
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    if (!stackTraceElementArray[i].getClassName().equals(clazz.getName()) || !stackTraceElementArray[i].getMethodName().equals(string)) continue;
                    this.fileName_ = stackTraceElementArray[i].getFileName();
                    this.lineNumber_ = stackTraceElementArray[i].getLineNumber();
                    break;
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return;
        }
    }

    public static CheckResult OK() {
        return new CheckResult();
    }

    public static CheckResult OK(String string) {
        return new CheckResult(string);
    }

    public static CheckResult NG() {
        CheckResult checkResult = new CheckResult();
        checkResult.type_ = ResultType.NG;
        return checkResult;
    }

    public static CheckResult NG(String string) {
        CheckResult checkResult = new CheckResult(string);
        checkResult.type_ = ResultType.NG;
        return checkResult;
    }

    public static CheckResult KnownBug() {
        CheckResult checkResult = new CheckResult();
        checkResult.type_ = ResultType.KnownBug;
        return checkResult;
    }

    public static CheckResult KnownBug(String string) {
        CheckResult checkResult = new CheckResult(string);
        checkResult.type_ = ResultType.KnownBug;
        return checkResult;
    }

    public static CheckResult Empty() {
        CheckResult checkResult = new CheckResult();
        checkResult.type_ = ResultType.Empty;
        return checkResult;
    }

    public static CheckResult Incomplete() {
        CheckResult checkResult = new CheckResult();
        checkResult.type_ = ResultType.Incomplete;
        return checkResult;
    }

    protected void writeValue(ObjectOutputStream objectOutputStream, Object object) throws IOException {
        if (object instanceof Unset) {
            objectOutputStream.writeObject(new Unset());
            return;
        }
        if (object instanceof Nodata) {
            objectOutputStream.writeObject(new Nodata());
            return;
        }
        if (object == null) {
            objectOutputStream.writeObject(null);
            return;
        }
        objectOutputStream.writeObject(String.valueOf(object));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this.getName());
        this.writeValue(objectOutputStream, this.expectValue_);
        this.writeValue(objectOutputStream, this.resultValue_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setName(objectInputStream.readUTF());
        Object object = objectInputStream.readObject();
        this.expectValue_ = object instanceof Unset ? UNSET : (object instanceof Nodata ? NODATA : object);
        Object object2 = objectInputStream.readObject();
        this.resultValue_ = object2 instanceof Unset ? UNSET : (object2 instanceof Nodata ? NODATA : object2);
    }

    static final class Nodata
    implements Serializable {
        static final long serialVersionUID = -8631151308995972485L;

        Nodata() {
        }

        public String toString() {
            return "(none)";
        }
    }

    static final class Unset
    implements Serializable {
        static final long serialVersionUID = 2099622104584147518L;

        Unset() {
        }

        public String toString() {
            return "(unset)";
        }
    }
}

