/*
 * Constraint class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import java.util.Map;

/**
 * e[u̐̃`FbNsB
 * <br>
 * `FbŃÃNXpNX{@link
 * #check(Trigger.Action, Table, java.util.Map) check}\bhI[o[Ch
 * ĎB
 * <br>
 * {@link #check(Trigger.Action, Table, java.util.Map) check}\bh́A{@link 
 * ts.util.table.ConstraintTrigger ConstraintTrigger}IuWFNgɓo^A
 * {@link ts.util.table.ConstraintTrigger#preAppend(Table, java.util.Map)
 * preAppend}A{@link ts.util.table.ConstraintTrigger#preUpdate(Table,
 * java.util.Map, java.util.Map) preUpdate}A{@link
 * ts.util.table.ConstraintTrigger#preDelete(Table, java.util.Map) preDelete}
 * \bĥꂩĂ΂B
 *
 * @param  <C>  e[ũJEL[̃^CvB
 * @param  <V>  e[ũJl̃^CvB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2010-10-16 10:51:35 $
 */
public abstract class Constraint<C,V>
{
  /**
   * ftHgRXgN^B
   */
  public Constraint()
  {}

  /**
   * ̃`FbNsB
   * <br>
   * `FbŇʂᔽ̏ꍇ́AOX[B
   *
   * @param  action ύX̎ށB
   * @param  table  e[uEIuWFNgB
   * @param  record ύX郌R[hEIuWFNgB
   * @throws ConstraintViolationException `FbŇʂ
   *         ᔽꍇB
   */
  protected abstract void check(Trigger.Action action, Table<C,V> table,
    Map<C,V> record) throws ConstraintViolationException;
}

