/*
 * DateTimeRange class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.util.List;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

/**
 * ͈̔͂\NXB
 * <br>
 * tB[hϐɓ̓A̍NPʂPʂŎZoA
 * w肳ꂽ͈͓ɂ邩ǂ𔻒肷邽߂̃\bhpӂĂB
 *
 * @author  V. 
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:44 $
 */
public class DateTimeRange extends Range<DateTime>
{
  /** Jñ~bB */
  private long startMillis_ ;

  /** IB */
  private long endMillis_ ;

  /** J_B */
  private Calendar calendar_ ; 

  /**
   * ̓IuWFNgɂƂRXgN^B
   * <br>
   * ̓IuWFNgɂ́A召֌WȂw肷邱ƂłB
   *
   * @param  dttm1 1B
   * @param  dttm2 2B
   * @throws IllegalArgumentException ̓IuWFNg̃J_[
   *           قȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public DateTimeRange(DateTime dttm1, DateTime dttm2)
  {
    super(dttm1, dttm2);
  }

  /**
   * ̓IuWFNgݒ肷B
   * <br>
   * ̓IuWFNgɂ́A召֌WȂw肷邱ƂłB
   *
   * @param  dttm1 1B
   * @param  dttm2 2B
   * @throws IllegalArgumentException ̓IuWFNg̃J_[
   *           قȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ)B
   */
  @Override
  public final void setRange(DateTime dttm1, DateTime dttm2)
  {
    assert (dttm1 != null) : "@param:dttm1 is null.";
    assert (dttm2 != null) : "@param:dttm2 is null.";

    Calendar cal1 = dttm1.getCalendar();
    cal1.setTimeInMillis(0L);

    Calendar cal2 = dttm2.getCalendar();
    cal2.setTimeInMillis(0L);

    if (! cal1.equals(cal2)) {
      throw new IllegalArgumentException(
        "calendar of two date-time are different.");
    }

    set(dttm1.getDateTimeMillis(), dttm2.getDateTimeMillis(), cal2);
  }

  /**
   * ͈͂̊Jn~bƏI~bAJ_ݒ肷B
   * <br>
   * Jn~bƏI~b̑召֌Wt̏ꍇ͓ւĐݒ肷B
   *
   * @param  millis1 Jn~bB
   * @param  millis2 I~bB
   * @param  calendar J_IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void set(long millis1, long millis2, Calendar calendar)
  {
    assert (calendar != null) : "@param:calendar is null.";

    if (millis1 < millis2) {
      startMillis_ = millis1;
      endMillis_ = millis2;
    }
    else {
      startMillis_ = millis2;
      endMillis_ = millis1;
    }
    
    calendar_ = calendar;
  }
  
  /**
   * Jn擾B
   * <br>
   * ̓̂̏ԂB
   *
   * @return JnB
   */
  @Override
  public DateTime getStart()
  {
    DateTime dttm = new DateTime(calendar_);
    dttm.setDateTime(startMillis_);
    return dttm;
  }

  /**
   * I擾B
   * <br>
   * ̓̂̑傫ԂB
   *
   * @return IB
   */
  @Override
  public DateTime getEnd()
  {
    DateTime dttm = new DateTime(calendar_);
    dttm.setDateTime(endMillis_);
    return dttm;
  }

  /**
   * ̓̍NPʂŋ߂B
   * <br>
   * ̓̑傫A̗N̓Ȍꍇ0ƐB
   * Ⴆ΁A2005-04-10`2006-04-09̏ꍇ0A2005-04-10`2006-04-11̏ꍇ1
   * ԂB
   *
   * @return ̃IuWFNgێ̓̔NPʂ̍B
   */
  public int intervalInYear()
  {
    long  millisS = startMillis_ ;
    long  millisE = endMillis_ ;

    calendar_.setTimeInMillis(millisE);
    int y = calendar_.get(Calendar.YEAR);
    calendar_.setTimeInMillis(millisS);
    y -= calendar_.get(Calendar.YEAR);

    calendar_.add(Calendar.YEAR, y);
    long millis = calendar_.getTimeInMillis();
    return (millis > millisE) ? (y-1) : y;
  }

  /**
   * ̓̍Pʂŋ߂B
   * <br>
   * ̓̑傫A̗̓Ȍꍇ0ƐB
   * Ⴆ΁A2006-04-10`2006-05-09̏ꍇ0A2006-04-10`2006-05-11̏ꍇ1
   * ԂB
   *
   * @return ̃IuWFNgێ̓̌Pʂ̍B
   */
  public int intervalInMonth()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    int m;
    if (calendar_ instanceof GregorianCalendar) {
      calendar_.setTimeInMillis(millisE);
      int y = calendar_.get(Calendar.YEAR);
      m = calendar_.get(Calendar.MONTH);
      calendar_.setTimeInMillis(millisS);
      y -= calendar_.get(Calendar.YEAR);
      m -= calendar_.get(Calendar.MONTH);
      m += y * 12;
    }
    else {
      calendar_.setTimeInMillis(millisE);
      int ye = calendar_.get(Calendar.YEAR);
      m = calendar_.get(Calendar.MONTH);
      calendar_.setTimeInMillis(millisS);
      int ys = calendar_.get(Calendar.YEAR);
      m -= calendar_.get(Calendar.MONTH);
      for (int y=ys; y<ye; y++) {
        calendar_.clear();
        calendar_.set(y+1, 0, 1, 0, 0, 0);
        calendar_.add(Calendar.SECOND, -1);
        m += calendar_.get(Calendar.MONTH) + 1;
      }
      calendar_.setTimeInMillis(millisS);
    }

    calendar_.add(Calendar.MONTH, m);
    long millis = calendar_.getTimeInMillis();
    return (millis > millisE) ? (m-1) : m;
  } 

  /**
   * ̓̍Pʂŋ߂B
   * <br>
   * ̓̑傫A̗̓Ȍꍇ0ƐB
   * Ⴆ΁A2006-04-10 11:22:33`2006-04-11 11:22:32̏ꍇ0A
   * 2006-04-10 11:22:33`2006-04-11 11:22:34̏ꍇ1ԂB
   *
   * @return ̃IuWFNgێ̓̓Pʂ̍B
   */
  public int intervalInDay()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    return (int)((millisE - millisS) / (long)(24 * 60 * 60 * 1000));
  }

  /**
   * ̓̍Pʂŋ߂B
   * <br>
   * ̓̑傫A̎̎̓Ȍꍇ0ƐB
   * Ⴆ΁A2006-04-10 11:22:33`2006-04-10 12:22:32̏ꍇ0A
   * 2006-04-10 11:22:33`2006-04-10 12:22:34̏ꍇ1ԂB
   *
   * @return ̃IuWFNgێ̓̎Pʂ̍B
   */
  public long intervalInHour()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    return (millisE - millisS) / (long)(60 * 60 * 1000);
  }

  /**
   * ̓̍𕪒Pʂŋ߂B
   * <br>
   * ̓̑傫A̎̓̕Ȍꍇ0ƐB
   * Ⴆ΁A2006-04-10 11:22:33`2006-04-10 11:23:32̏ꍇ0A
   * 2006-04-10 11:22:33`2006-04-10 11:22:34̏ꍇ1ԂB
   *
   * @return ̃IuWFNgێ̓̕Pʂ̍B
   */
  public long intervalInMinute()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    return (millisE - millisS) / (long)(60 * 1000);
  }

  /**
   * ̓̍bPʂŋ߂B
   * <br>
   * ̓̑傫A̎̕b̓Ȍꍇ0ƐB
   * Ⴆ΁A2006-04-10 11:22:33.111`2006-04-10 11:22:34.110̏ꍇ0A
   * 2006-04-10 11:22:33.111`2006-04-10 11:22:34.112̏ꍇ1ԂB
   *
   * @return ̃IuWFNgێ̓̕Pʂ̍B
   */
  public long intervalInSecond()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    return (millisE - millisS) / (long)(1000);
  }

  /**
   * ͈̔͂Ɋ܂܂N̐߂B
   * <br>
   * Ⴆ΁A2005-04-10`2007-04-09̏ꍇ2005,2006,2007N܂܂̂3
   * ԂB
   *
   * @return ̃IuWFNg͈̔͂Ɋ܂܂N̐B
   */
  public int countYears()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    calendar_.setTimeInMillis(millisE);
    int y = calendar_.get(Calendar.YEAR);
    calendar_.setTimeInMillis(millisS);
    y -= calendar_.get(Calendar.YEAR);

    return (y+1);
  }

  /**
   * ͈̔͂Ɋ܂܂錎̐߂B
   * <br>
   * Ⴆ΁A2006-04-10`2006-06-09̏ꍇ4,5,6܂܂̂3ԂB
   *
   * @return ̃IuWFNg͈̔͂Ɋ܂܂錎̐B
   */
  public int countMonths()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    int m;
    if (calendar_ instanceof GregorianCalendar) {
      calendar_.setTimeInMillis(millisE);
      int y = calendar_.get(Calendar.YEAR);
      m = calendar_.get(Calendar.MONTH);
      calendar_.setTimeInMillis(millisS);
      y -= calendar_.get(Calendar.YEAR);
      m -= calendar_.get(Calendar.MONTH);
      m += y * 12;
    }
    else {
      calendar_.setTimeInMillis(millisE);
      int ye = calendar_.get(Calendar.YEAR);
      m = calendar_.get(Calendar.MONTH);
      calendar_.setTimeInMillis(millisS);
      int ys = calendar_.get(Calendar.YEAR);
      m -= calendar_.get(Calendar.MONTH);
      for (int y=ys; y<ye; y++) {
        calendar_.clear();
        calendar_.set(y+1, 0, 1, 0, 0, 0);
        calendar_.add(Calendar.SECOND, -1);
        m += calendar_.get(Calendar.MONTH) + 1;
      }
    }

    return (m+1);
  } 

  /**
   * ͈̔͂Ɋ܂܂̐߂B
   * <br>
   * Ⴆ΁A2006-04-10 11:22:33`2006-04-12 11:22:32̏ꍇ10,11,12
   * ܂܂̂3ԂB
   *
   * @return ̃IuWFNg͈̔͂Ɋ܂܂̐B
   */
  public int countDays()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    DateTime dttmS = new DateTime(millisS);
    DateTime dttmE = new DateTime(millisE);
    dttmS.setStartTimeOfDay();
    dttmE.setStartTimeOfDay();
    dttmE.addDay(1);
    long diff = dttmE.getDateTimeMillis() - dttmS.getDateTimeMillis();
    return (int)(diff / (24L * 60L * 60L * 1000L));
  }

  /**
   * ͈̔͂Ɋ܂܂鎞̐߂B
   * <br>
   * Ⴆ΁A2006-04-10 11:22:33`2006-04-10 13:22:32̏ꍇ11,12,13
   * ܂܂̂3ԂB
   *
   * @return ̃IuWFNg͈̔͂Ɋ܂܂鎞̐B
   */
  public long countHours()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    calendar_.setTimeInMillis(millisS);
    int yS = calendar_.get(Calendar.YEAR);
    int mS = calendar_.get(Calendar.MONTH);
    int dS = calendar_.get(Calendar.DAY_OF_MONTH);
    int hS = calendar_.get(Calendar.HOUR_OF_DAY);
    calendar_.clear();
    calendar_.set(yS, mS, dS, hS, 0, 0);
    millisS = calendar_.getTimeInMillis();

    calendar_.setTimeInMillis(millisE);
    int yE = calendar_.get(Calendar.YEAR);
    int mE = calendar_.get(Calendar.MONTH);
    int dE = calendar_.get(Calendar.DAY_OF_MONTH);
    int hE = calendar_.get(Calendar.HOUR_OF_DAY);
    calendar_.clear();
    calendar_.set(yE, mE, dE, hE, 0, 0);
    calendar_.add(Calendar.HOUR_OF_DAY, 1);
    millisE = calendar_.getTimeInMillis();

    return (millisE - millisS) / (60L * 60L * 1000L);
  }

  /**
   * ͈̔͂Ɋ܂܂镪̐߂B
   * <br>
   * Ⴆ΁A2006-04-10 11:22:33`2006-04-10 11:24:32̏ꍇ22,23,24
   * ܂܂̂3ԂB
   *       
   * @return ̃IuWFNg͈̔͂Ɋ܂܂镪̐B
   */
  public long countMinutes()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    calendar_.setTimeInMillis(millisS);
    int yS = calendar_.get(Calendar.YEAR);
    int mS = calendar_.get(Calendar.MONTH);
    int dS = calendar_.get(Calendar.DAY_OF_MONTH);
    int hS = calendar_.get(Calendar.HOUR_OF_DAY);
    int miS = calendar_.get(Calendar.MINUTE);
    calendar_.clear();
    calendar_.set(yS, mS, dS, hS, miS, 0);
    millisS = calendar_.getTimeInMillis();

    calendar_.setTimeInMillis(millisE);
    int yE = calendar_.get(Calendar.YEAR);
    int mE = calendar_.get(Calendar.MONTH);
    int dE = calendar_.get(Calendar.DAY_OF_MONTH);
    int hE = calendar_.get(Calendar.HOUR_OF_DAY);
    int miE = calendar_.get(Calendar.MINUTE);
    calendar_.clear();
    calendar_.set(yE, mE, dE, hE, miE, 0);
    calendar_.add(Calendar.MINUTE, 1);
    millisE = calendar_.getTimeInMillis();

    return (millisE - millisS) / (60L * 1000L);
  }

  /**
   * ͈̔͂Ɋ܂܂b̐߂B
   * <br>
   * Ⴆ΁A2006-04-10 11:22:33.444`2006-04-10 11:22:35.443̏ꍇ
   * 33,34,35b܂܂̂3ԂB
   *
   * @return ̃IuWFNg͈̔͂Ɋ܂܂b̐B
   */
  public long countSeconds()
  {
    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    calendar_.setTimeInMillis(millisS);
    int yS = calendar_.get(Calendar.YEAR);
    int mS = calendar_.get(Calendar.MONTH);
    int dS = calendar_.get(Calendar.DAY_OF_MONTH);
    int hS = calendar_.get(Calendar.HOUR_OF_DAY);
    int miS = calendar_.get(Calendar.MINUTE);
    int sS = calendar_.get(Calendar.SECOND);
    calendar_.clear();
    calendar_.set(yS, mS, dS, hS, miS, sS);
    millisS = calendar_.getTimeInMillis();

    calendar_.setTimeInMillis(millisE);
    int yE = calendar_.get(Calendar.YEAR);
    int mE = calendar_.get(Calendar.MONTH);
    int dE = calendar_.get(Calendar.DAY_OF_MONTH);
    int hE = calendar_.get(Calendar.HOUR_OF_DAY);
    int miE = calendar_.get(Calendar.MINUTE);
    int sE = calendar_.get(Calendar.SECOND);
    calendar_.clear();
    calendar_.set(yE, mE, dE, hE, miE, sE);
    calendar_.add(Calendar.SECOND, 1);
    millisE = calendar_.getTimeInMillis();

    return (millisE - millisS) / 1000L;
  }

  /**
   * w肳ꂽ̃IuWFNg͈̎̔͂Ɋ܂܂Ă邩ǂ
   * 肷B
   *
   * @param  dttm ΏۂƂȂB
   * @return ̓܂܂Ăꍇ<tt>true</tt>AłȂ
   *           <tt>false</tt>B
   * @throws IllegalArgumentException ̂J_ÃIuWFNg
   *           ̕ێJ_ƈقȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ)B
   */
  @Override
  public boolean encompass(DateTime dttm)
  {
    assert (dttm != null) : "@param:dttm is null.";

    calendar_.setTimeInMillis(0L);

    Calendar cal = dttm.getCalendar();
    cal.setTimeInMillis(0L);

    if (! calendar_.equals(cal)) {
      throw new IllegalArgumentException(
        "Specified calendar are different from calendar of this object.");
    }

    long ltime = dttm.getDateTimeMillis();
    return (startMillis_ <= ltime && ltime <= endMillis_);
  }

  /**
   * w肳ꂽ͈̔͂̃IuWFNg͈̎̔͂Ɋ܂܂Ă邩
   * ǂ𔻒肷B
   *
   * @param  range ΏۂƂȂ͈̔́B
   * @return ͈̓̔͂܂܂Ăꍇ<tt>true</tt>AłȂ
   *           <tt>false</tt>B
   * @throws IllegalArgumentException ̂J_ÃIuWFNg
   *           ̕ێJ_ƈقȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ)B
   */
  public boolean encompass(DateTimeRange range)
  {
    assert (range != null) : "@param:range is null.";

    calendar_.setTimeInMillis(0L);

    Calendar cal = range.calendar_ ;
    cal.setTimeInMillis(0L);

    if (! calendar_.equals(cal)) {
      throw new IllegalArgumentException(
        "Specified calendar are different from calendar of this object.");
    }

    long millisS = startMillis_ ;
    long millisE = endMillis_ ;

    long millisS1 = range.startMillis_;
    long millisE1 = range.endMillis_;

    return ((millisS1 >= millisS) && (millisE1 <= millisE)) ? true : false;
  }

  /**
   * w肳ꂽ͈̔͂Ƃ̃IuWFNg͈̎̔͂̏dȂ͈͂
   * 擾B
   *
   * @param  range ͈̔́B
   * @return ͈̓̔͂Ƃ̃IuWFNgƂdȂ͈́B
   * @throws IllegalArgumentException ̂J_ÃIuWFNg
   *           ̕ێJ_ƈقȂꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ)B
   */
  public DateTimeRange intersectsWith(DateTimeRange range)
  {
    assert (range != null) : "@param:range is null.";

    calendar_.setTimeInMillis(0L);

    Calendar cal = range.calendar_;
    cal.setTimeInMillis(0L);

    if (! calendar_.equals(cal)) {
      throw new IllegalArgumentException(
        "Specified calendar are different from calendar of this object.");
    }

    long millisS = Math.max(startMillis_, range.startMillis_);
    long millisE = Math.min(endMillis_, range.endMillis_);

    if (millisS > millisE) {
      return null;
    }
    return new DateTimeRange(new DateTime(millisS), new DateTime(millisE));
  }

  /**
   * w肳ꂽ܂ނ悤ɁÃIuWFNg͈̎͂g͈͂擾
   * B
   * <Br>
   * w肳ꂽ܂łꍇ́ÃIuWFNgƓ͈͂ԂB
   *
   * @param  dttm IuWFNgB
   * @return w肳ꂽ܂ނ悤Ɋgꂽ͈́B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  @Override
  public DateTimeRange expandsWith(DateTime dttm)
  {
    assert (dttm != null) : "@param:dttm is null.";

    long millisS = Math.min(startMillis_, dttm.getDateTimeMillis());
    long millisE = Math.max(endMillis_, dttm.getDateTimeMillis());

    return new DateTimeRange(new DateTime(millisS), new DateTime(millisE));
  }

  /**
   * w肳ꂽ͈͂܂ނ悤ɁÃIuWFNg͈̎͂g͈͂
   * 擾B
   * <br>
   * w肳ꂽ͈͂܂łꍇ́ÃIuWFNgƓ͈͂ԂB
   *
   * @param  range ͈́B
   * @return w肳ꂽ͈͂܂ނ悤Ɋgꂽ͈́B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public DateTimeRange expandsWith(DateTimeRange range)
  {
    assert (range != null) : "@param:range is null.";

    long millisS = Math.min(startMillis_, range.startMillis_);
    long millisE = Math.max(endMillis_, range.endMillis_);

    return new DateTimeRange(new DateTime(millisS), new DateTime(millisE));
  }
}
