<?php 
/**
 * CSRF対策用Token出力ヘルパー
 * 要Formヘルパー
 */

class TokenHelper extends AppHelper {
/**
 * Other helpers used by TokenHelper
 *
 * @var array
 * @access public
 */
	var $helpers = array('Form', 'Session');

	/* Tokenをセットしたhiddenタグ出力 */
	function create($tag_name = '__Token', $hash_type = 'md5')
	{
		$hashed_id = $this-> get_hashed_session_id($hash_type);

		return $this->Form->input($tag_name, array(
			'type' => 'hidden',
			'value' => $hashed_id,
			)
		);
	}

	/* 現在のセッションIDを暗号化して取得 */
	function get_hashed_session_id($hash_type = 'md5')
	{
		$session_id = $this->Session->id();

		return Security::hash($session_id. Configure::read('Security.salt'), $hash_type);
	}

}


