<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class ProfileSelect extends AppModel {

	var $name = 'ProfileSelect';

	var $fields = array(
		'add' => array('profile_id', 'value', 'sort_order'),
		'edit_all' => array('value', 'sort_order'),
		'escape' => array(
			'value' => array(
				'html' => true,
				'tags' => true,
 				'all' => true, 
 			),
		),
	);

	var $validate = array(
		'value' => array(
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'sort_order' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'allowEmpty' => true,
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
		'Profile' => array(
			'className' => 'Profile',
			'foreignKey' => 'profile_id',
			'conditions' => '',
			'fields' => '',
		)
	);

	var $hasMany = array(
		'CharactersHasProfile' => array(
			'className' => 'CharactersHasProfile',
			'foreignKey' => 'profile_select_id',
			'associationForeignKey' => 'id',
			'dependent' => true,
			'conditions' => '',
			'fields' => '',
			'order' => array('CharactersHasProfile.id' => 'asc'),
			'limit' => 10,
			'offset' => '',
			'finderQuery' => '',
			'deleteQuery' => '',
			'insertQuery' => ''
		)
	);

	/* コールバックメソッド */
	function beforeSave($options = array())
	{
		if (empty($this->data['ProfileSelect']['sort_order'])) {
			$this->data['ProfileSelect']['sort_order'] = 0;
		}

		return parent::beforeSave($options);
	}

	function afterSave($created) {
		$this->deleteCache4ProfileChilds();

		return parent::afterSave($created);
	}
	function afterDelete() {
		$this->deleteCache4ProfileChilds();

		return parent::afterDelete();
	}
}
