<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Controller
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class ProfileTablesController extends AppController {

	var $name = 'ProfileTables';
	var $helpers = array(
		'Profiledisp',
	);

	// POSTのTokenチェックをしないアクション
	var $disableTokenActions = array();

	function admin_listview($profile_id = null) {
		if (!$profile_id) {
			$this->Session->setFlash(__('Invalid Profile', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		$profile = $this->get_profile4profile_id($profile_id);
		if (empty($profile)) {
			$this->Session->setFlash(__('Invalid Profile', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		// 「その他」システム設定
		$this->checkEditOtherSystem($profile['Profile']['system_id']);

		$newdata = array(
			'title' => null,
			'tablekey_name' => null,
			'width' => null,
			'sort_order' => null,
		);

		if (isset($this->data['ProfileTable']) || !empty($this->data['ProfileTable'])) {

			$error = false;
			$i = 0;
			if (isset($this->data['ProfileTable'][0])) {
				$newdata = array_merge($newdata, $this->data['ProfileTable'][0]);
				unset($this->data['ProfileTable'][0]);
			}
			foreach ($this->data['ProfileTable'] as $id => $v) {
				if (!$id || $id == '__Token') {
					continue;
				}

				$profileTable = $this->ProfileTable->find('first', array(
					'conditions' => array(
						'ProfileTable.id' => $id,
						'ProfileTable.profile_id' => $profile_id,
					),
					'contain' => array(
						'Profile'
					),
					'recursive' => 1,
				));
				$this->check_profile_type($profileTable);

				// 削除
				if (isset($v['tablekey_name']) && isset($v['title'])
				&& empty($v['tablekey_name']) && empty($v['title'])) {
					if ($this->ProfileTable->delete($id)) {
					} else {
						$this->Session->setFlash(__('Some data could not be saved. Please, try again.', true));
						$error = true;
					}

				// 編集
				} else {
					$data['ProfileTable'] = array(
						'tablekey_name' => $v['tablekey_name'],
						'title' => $v['title'],
						'width' => $v['width'],
						'sort_order' => $v['sort_order'],
					);

					$this->ProfileTable->id = $id;
					$this->ProfileTable->validate['tablekey_name']['isUniqueKeyname4profile'] = array(
						'rule' => array('isUniqueKeyname4profile', $profile_id, $id),
					);
					$this->ProfileTable->set($data);
					if ($this->ProfileTable->validates()) {
						if ($this->ProfileTable->save($data, array('fieldList' => $this->ProfileTable->fields['edit_all']))) {
						} else {
							$this->Session->setFlash(__('Some data could not be saved. Please, try again.', true));
							$error = true;
						}
					} else {
						$validate_errors = $this->ProfileTable->invalidFields();
						$this->Session->setFlash(array_pop($validate_errors));

						$error = true;
					}

					$profile['ProfileTable'][$i] = $v;
					$profile['ProfileTable'][$i]['id'] = $id;
					$profile['ProfileTable'][$i]['profile_id'] = $profile_id;
					$i++;
				}
			}

			if (!$error) {
				// 追加
				if (isset($newdata['tablekey_name']) && !empty($newdata['tablekey_name'])
					&& isset($newdata['title']) && !empty($newdata['title'])) {
					$data['ProfileTable'] = array(
						'profile_id' => $profile_id,
						'tablekey_name' => $newdata['tablekey_name'],
						'title' => $newdata['title'],
						'width' => $newdata['width'],
						'sort_order' => $newdata['sort_order'],
					);

					 $this->ProfileTable->validate['tablekey_name']['isUniqueKeyname4profile'] = array(
						'rule' => array('isUniqueKeyname4profile', $profile_id, null),
					);
					$this->ProfileTable->set($data);
					if ($this->ProfileTable->validates()) {
						$this->ProfileTable->create();
						if ($this->ProfileTable->save($data, array('fieldList' => $this->ProfileTable->fields['add']))) {
						} else {
							$this->Session->setFlash(__('Some data could not be saved. Please, try again.', true));
							$error = true;
						}
					} else {
						$validate_errors = $this->ProfileTable->invalidFields();
						$this->Session->setFlash(array_pop($validate_errors));

						$error = true;
					}
				}

				if (!$error) { 
					$this->Session->setFlash(__('The ProfileSelect has been saved', true));
					$this->redirect(array('controller' => 'profile_tables', 'action'=>'admin_listview', $profile_id));
				}
			}

			unset($this->data['ProfileTable']['__Token']);
		} else {
			foreach ($profile['ProfileTable'] as $k => $v) {
				$profile['ProfileTable'][$k] = $this->_restore_html_profile_table($v);
			}
		}

		$this->set('newdata', $newdata);
		$this->set('profile', $profile);

		$this->set('title_for_layout', " - ". __('ProfileTable', true));
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for ProfileSelect', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		$profileTable = $this->ProfileTable->read(null, $id);
		$this->check_profile_type($profileTable);

		if ($this->ProfileTable->delete($id)) {
			$this->Session->setFlash(__('ProfileTable deleted', true));
		} else {
			$this->Session->setFlash(__('The data has not been deleted', true));
		}

		$this->redirect(array('action'=>'admin_listview', $profileTable['Profile']['id']));
	}


	/* 共通関数 */
	function _restore_html_profile_table($data, $nl2br = false) {
		$data['title'] = $this->{$this->modelClass}->restore_html($data['title'], false, false, false);

		return $data;
	}

	function get_profile4profile_id($profile_id)
	{
		if (!$profile_id) {
			$this->Session->setFlash(__('Invalid ProfileTable.', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		$profile = $this->ProfileTable->Profile->find('first', array(
			'conditions' => array(
				'Profile.id' => $profile_id,
			),
			'contain' => array(
				'System',
				'ProfileTable' => array(
					'ProfileTableStatic',
				),
			),
		));

		if ($this->check_profile_type($profile)) {
			foreach ($profile['ProfileTable'] as $k => $v) {

				if (isset($v['sort_order'])  && !empty($v['sort_order'])) {
					$sort_order[$k] = $v['sort_order'];
				} else {
					$sort_order[$k] = 0;
				}
			}
			if (!empty($sort_order)) {
				$profile['ProfileTable'] = $this->sort4sort_order($profile['ProfileTable'], $sort_order);
			}

		}

		if (isset($profile['ProfileTable'][0]['ProfileTableStatic'])) {
			$profile['ProfileTable'][0]['ProfileTableStatic'] = $this->_restore_html_profile_table_static($profile['ProfileTable'][0]['ProfileTableStatic']);
		}

		return $profile;
	}
	function check_profile_type($profile)
	{
		if (!isset($profile['Profile']) || empty($profile['Profile'])) {
			$this->Session->setFlash(__('Invalid ProfileTable.', true));
			$this->redirect(array('controller' => 'systems', 'action'=>'admin_index'));
		}

		if ($profile['Profile']['profile_type'] != 'table' && $profile['Profile']['profile_type'] != 's-table') {
			$this->Session->setFlash(__('Profile type is not valid.', true));
			$this->redirect(array('controller' => 'profiles', 'action'=>'admin_edit', $profile['Profile']['id']));
		}

		return true;
	}

}
?>