<?php
/*
 Ajax Chat for TRPG ver.2.6.2.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：かんたんセットアップ用
 *****************/

// 設定ファイル名一覧
$GLOBALS['AJAX_CHAT_TRPG']['ORIG_CONFIGFILES_NAME'] = array(
    'config-data-important.php',
    'config-data-tag.php',
    'config-data-trpg.php',
    'config-data-card.php',
    'config-data-base-color.php',
    'config-data-main-color.php',
    'config-data-main.php',
    'config-data-icon.php',
    'config-data-mobile.php',
);
define('SETUP_DIR', './setup/');
define('SETUP_ORIGFILE_DIR', SETUP_DIR.'orig/');


// ヘッター
function html_header_setup($title='Ajax Chat for TRPG かんたんセットアップ') {
    $header = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'."\n";
    $header .= '<html>'."\n";
    $header .= '<head>'."\n";
    $header .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">'."\n";
    $header .= '<meta http-equiv="Content-Script-Type" content="text/javascript" />'."\n";
    $header .= '<meta http-equiv="Content-Style-Type" content="text/css" />'."\n";
    $header .= '<meta http-equiv="Pragma" content="no-cache">'."\n";
    $header .= '<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">'."\n";
    $header .= '<meta http-equiv="Expires" content="Thu, 01 Feb 1960 00:00:00 GMT">'."\n";
    $header .= '<link rel="stylesheet" type="text/css" href="./css/trpgchat.css">'."\n";
    $header .= '<link rel="stylesheet" type="text/css" href="./css/setup.css">'."\n";
    $header .= '<script type="text/javascript" src="./lib/js/jquery.js"></script>'."\n";
    $header .= '<title>'.$title.'</title>'."\n";

    return $header;
}

// 設定テーブル
function output_table($title) {
    return "</td></tr>\n<tr><td>$title</td><td>\n";
}

// ファイルを読み込んで文字列として出力
function output_file_string($file) {
    if (!is_readable($file)) {
        error('セットアップ失敗しました。ディレクトリの読み込み権限を確認してください', false, true, true);
    }
    $fp = file($file);
    return implode($fp, "");
}

// 文字列内容を書き込んだファイルを生成
function write_string_to_file($file, $string) {
//    if (!is_writable($file)) error('セットアップ失敗しました。ディレクトリの書き込み権限を確認してください', false, true, true);
    $fp = fopen($file, "x");
    if (!fwrite($fp, $string)) return false;
    fclose($fp);
    return $contents;
}

// trpgchat-ini.phpの出力
function set_ini($data) {
    if (!is_readable(SETUP_DIR.'trpgchat-ini.php')) {
        error(SETUP_DIR."ディレクトリ内にtrpgchat-ini.phpがありません", true);
    }

    $contents = output_file_string(SETUP_DIR.'trpgchat-ini.php');

    if (!$contents) {
        error(SETUP_DIR."trpgchat-ini.phpの読み込みに失敗しました", true);
    }
    $output = sprintf($contents,
                $data['masterpass'],
                $data['admin_hash'],
                $data['cookie'],
                $data['obf'],
                $data['imp'],
                $data['tag'],
                $data['trpg'],
                $data['card'],
                $data['bc'],
                $data['mc'],
                $data['main'],
                $data['icon'],
                $data['mobile'],
                $data['rlog'],
                $data['plog'],
                $data['pdir'],
                $data['mpdir'],
                $data['mem'],
                $data['syslog'],
                $data['l1'],
                $data['l2'],
                $data['l3'],
                $data['cdir'],
                $data['nd'],
                $data['nds']
            );
    if (!$output) error('trpgchat-ini.phpの内容設定に失敗しました。', false, true, true);

    write_string_to_file('./trpgchat-ini.php', $output);
    if (!file_exists("./trpgchat-ini.php")) error('セットアップに失敗しました。ディレクトリの書き込み権限を確認してください', false, true, true);
    return true;
}

// 設定ファイルの出力
function setup_config($prev_dir, $key, $file) {
    // 前バージョンの設定読み込み
    $pcl = read_config_one($prev_dir.$file);
    $prev_config_set = array();
    foreach ($pcl as $v1) {
        $v1 = rtrim($v1);
        if ($v1) {
            $prev_config = explode("<>", $v1);
            if ($prev_config[2]) {
                if ($prev_config[2] == 'TAGS') {
                    $prev_config_set["$prev_config[2]"] = $prev_config[6]."<>".$prev_config[7]."<>".$prev_config[8]."<>".$prev_config[9]."<>".$prev_config[10]."<>".$prev_config[11];
                } else {
                    $prev_config_set["$prev_config[2]"] = $prev_config[6];
                }
            }
        }
    }

    // 新バージョンの設定ファイルを配列に
    $lines = file(SETUP_ORIGFILE_DIR.$GLOBALS['AJAX_CHAT_TRPG']['ORIG_CONFIGFILES_NAME'][$key]);
    if (!$lines) error("新バージョンの設定ファイルが読み込めません", true);

    if (file_exists($file)) unlink($file);
    $fp = @fopen($file, "x") or error("設定ファイルを作成できません。", true);
    foreach ($lines as $v) {
        $temp = explode("<>", $v);
        // 前バージョンの設定があればセット
        if ($temp[2]) {
            if (isset($prev_config_set[$temp[2]])) {
                if ($temp[2] == 'TAGS') {
                    array_pop($temp);
                    array_pop($temp);
                    array_pop($temp);
                    array_pop($temp);
                    array_pop($temp);
                }
                $temp[6] = $prev_config_set[$temp[2]]."\n";
            }
        }
        $line = implode($temp, "<>");
        fwrite($fp, $line);
    }
    @fclose($fp);

    return file_exists($file);
}

// ログファイルの出力
function set_logs($data) {

    // ロックファイル
    touch($data['l1']);
    set_permission_666($data['l1'], $data['666']);
    touch($data['l2']);
    set_permission_666($data['l2'], $data['666']);
    touch($data['l3']);
    set_permission_666($data['l3'], $data['666']);

    // 在室メンバー
    touch($data['mem']);
    set_permission_666($data['mem'], $data['666']);

    // 過去ログ
    if (!$data['mlog']) {
        act_log($data['rlog'], $data['666'], $data['mode'], $data['previous_chat_dir'], $data['clog'], $data['obf']);
        act_log($data['plog'], $data['666'], $data['mode'], $data['previous_chat_dir'], $data['clog'], $data['obf']);
        act_log($data['nd'], $data['666'], $data['mode'], $data['previous_chat_dir'], $data['clog'], $data['obf']);
        act_log($data['nds'], $data['666'], $data['mode'], $data['previous_chat_dir'], $data['clog'], $data['obf']);
        act_mkdir($data);
    }

    // システムログ
    if (!$data['mlog']) {
        touch($data['syslog']);
        set_permission_666($data['syslog'], $data['666']);
    }

    if (is_writable($data['rlog']) && is_writable($data['plog']) && is_writable($data['pdir']) && is_writable($data['mpdir']) && is_writable($data['mem']) && is_writable($data['syslog']) && is_writable($data['l1']) && is_writable($data['l2']) && is_writable($data['l3'])) {
        return true;
    } else {
        return false;
    }
}

/* 指定ディレクトリ内の内容を全てコピー */
function copy_all_contents4dir($dir, $copy_to, $permission =false) {
    $d = copy_all_files4dir($dir, $copy_to);
    // ディレクトリ内コピーは1階層のみ
    if ($d) {
        foreach ($d as $v) {
            if ($msg = mk_pastlog_dir('', $copy_to.$v, $data['777'])) {
                unlink('./trpgchat-ini.php');
                error($copy_to.$v."の設定に失敗しました", true);
            }
            copy_all_files4dir($dir.$v."/", $copy_to.$v."/");
        }
    }
}
/* 指定ディレクトリ内のファイルを全てコピー */
function copy_all_files4dir($dir, $copy_to) {
    $contents = get_dir_contents_list($dir);
    if ($contents['files']) {
        foreach ($contents['files'] as $v) {
            copy($dir.$v, $copy_to.$v);
        }
    }
    return $contents['dirs'];
}

// 直近の過去ログファイルの作成
function act_log($file, $permission, $mode, $prev_dir = '', $copy = '', $obf = '') {
    if ($mode == 'install_do' || !$copy) {
        touch($file);
    } elseif ($mode == 'verup_do' && $prev_dir) {
        if (!$obf) {
            if (!copy($prev_dir.$file, $file)) {
                touch($file);
            }
        } else {
            touch($file);
        }
    } else {
        unlink('./trpgchat-ini.php');
        error("設定が不正です");
    }

    set_permission_666($file, $permission);

    if (!is_writable($file)) {
        unlink('./trpgchat-ini.php');
        error($file."の設定に失敗しました", true);
    }
}

// 過去ログディレクトリの作成
function act_mkdir($data) {
    act_mkdir_indi($data, $data['pdir']);
    act_mkdir_indi($data, $data['mpdir']);
}
function act_mkdir_indi($data, $dir) {
    if (!file_exists($dir)) {
        if ($msg = mk_pastlog_dir('', $dir, $data['777'])) {
            unlink('./trpgchat-ini.php');
            error($dir."の設定に失敗しました", true);
        }
    }

    // アップデートの場合、前の過去ログディレクトリ全コピー
    if ($data['mode']== 'verup_do') {
        copy_all_contents4dir($data['previous_chat_dir'].$dir, $dir, $data['777']);
    }

    return file_exists($dir);
}


// セットアップ完了画面表示
function setup_end($data){
    if (!DEMO_SETUP) {
        unlink('./setup.php');
    // デモ用
    } else {
        $msg = '＊現在デモモードのため、セットアップ開始画面に戻ります';
    }
    print <<< DOC
<style type="text/css">
<!--
* {
	margin: 5px;
}
-->
</style>
</head>
<body>
<p class="msg">セットアップが完了しました<br>
<br>
その他の細かい設定は、管理画面から変更してください。<br>
<br>
以下のボタンで、チャット画面を表示します<br>
$msg
<br>
</p>

<center>
<form action="./index.php">
<input type="submit" value="チャット画面を表示">
</FORM>
</center>

DOC;
exit;
}

// セットアップとバージョンアップで共通の設定表示
function easy_setup_config_basic() {
}
function easy_setup_config_ext1($mode) {
    print "<h2>ファイル・ディレクトリのパーミッション設定</h2>\n";
    print "<h3>お使いのサーバでパーミッションの制限がある場合、変更してください</h3>\n";
    print '<table border="1">'."\n";
    print output_table("読み書き可");
    print input_area('radio', '666', '0', '', '', 'checked')." : 666<br>\n";
    print input_area('radio', '666', '1', '', '')." : 606";
    print output_table("読み書き実行可");
    print input_area('radio', '777', '0', '', '', 'checked')." : 777<br>\n";
    print input_area('radio', '777', '1', '', '')." : 707";
    print "</td></tr>\n";
    print '<tr><td style="text-align:center;" colspan="2">';
    print input_area('submit', 'submit', '次へ');
    print '<p align="center"> </p>';
    print "</td></tr>\n";
    print '</table>';

    print ' <br> ';

    print "<h2>ログ隠し設定</h2>\n";
    print "<h3>ログファイルを外部から見えずらくする設定です。<br>見えずらくすると、一般的に『重く』なります。</h3>\n";
    print '<table border="1">'."\n";
    print output_table("ログの直接表示を禁止する");
    print input_area('radio', 'htaccess', '1', '', '')." : する<br>\n";
    print input_area('radio', 'htaccess', '0', '', '', 'checked')." : しない<br>";
    print "直近の過去ログファイルの直接表示を禁止します。<br>.htaccessを用いるため、環境によっては誤作動する場合があります。<br>解除したい場合は、index.phpと同じディレクトリにある.htaccessファイルを削除してください";
    print output_table("チャットのドメイン");
    print input_area('test', 'ht_domain', 'http://')."\n";
    print "<br>チャットを設置するサイトのドメインを入力してください。<br>ログの直接表示禁止には必須の設定です。<br><b>　[例]</b><br>チャットのURL <strong>http://sample.site.ne.jp/username/trpgchat/index.php</strong><br>ドメイン <strong>http://sample.site.ne.jp/username/</strong>";
    print output_table("直近の過去ログを難読化する");
    print input_area('radio', 'obf', '1', '', '')." : する<br>\n";
    print input_area('radio', 'obf', '0', '', '', 'checked')." : しない<br>";
    print <<<HD
直近の過去ログファイルを、普通には読めないように変換して保管します。<br>
<strong>・暗号化ではありません。</strong><br>
・この機能を用いると、負荷が多少高くなります。また、トラブルが起こった時にログの復元がしずらくなります。<br>
・難読化している場合、今後のバージョンアップ時にHTML化していない過去ログは、引き継げない場合があります。ご了承ください。<br>
HD;
    if($mode == 'v') print "・また、この設定を選ぶと、<strong>直近の過去ログを引き継ぎません</strong><br>";
    print "</td></tr>\n";
    print '<tr><td style="text-align:center;" colspan="2">';
    print input_area('submit', 'submit', '次へ');
    print '<p align="center"> </p>';
    print "</td></tr>\n";
    print '</table>';

    print ' <br> ';

}

?>