/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*****************
 *  JaveScriptライブラリ：カード機能用
 *****************/

var cardWritescript = './write.php';
var cardWritescript2 = './card_write.php';
var cardUpdateScript = './card_update.php';
var dateD = (new Date()).getTime();

// 入室チェック
function checkLogin() {
    var error = false;
    var openWindow = window.opener;
    if (!openWindow) {
        error = true;
    } else {
        var name = openWindow.document.getElementById("name_on").value;
        if (!name) {
            error = true;
        }
    }
    if (error) {
        return false;
    }
    var pwd = openWindow.document.getElementById('pwd_on').value;
    var hash = openWindow.document.getElementById('my_hash').value;
    return new Array(name, hash, pwd);
}

// カード卓更新
// カード卓に参加者を表示
function dispCardField(ifModifiedField) {
    var flg = false;

    // 他PL表示
    $.ajax({
        type: "get",
        url: now_member,
        ifModified: ifModifiedField,
        dataType: "text",
        // 受信完了イベント
        success: function(data) {
            var nowMembers = new Array();

            var memberData = data.split("\n");
            $.each(memberData, function(i){
                var memberDataDetail = memberData[i].split("<>");
                if (obfuscateLog == '1') {
                    var oplName = deObfLog(memberDataDetail[0]);
                } else {
                    var oplName = memberDataDetail[0];
                }

                // 他PL表示
                if (oplName && oplName != loginName) {
                    var oplId = "#"+oplName;
                    nowMembers.push(oplName);
                    // 追加
                    if ($(oplId).text()=='') {
                        flg = true;
                        // カード卓
                        var oplTagValue = '<li class="name" id="playerName">'+oplName+'</li>'
                                            +'<li class="position">'
                                            +'<div class="Secret" id="'+oplName+'Secret">手：<span class="contents"></span></div>'
                                            +'</li>'
                                            +'<div class="Field" id="'+oplName+'Field">場：<span class="contents"></span></div>'
                                            +'</li>'
                                            +'<li class="command">'
                                            +'<a href="#" onclick="updateCardStatus(\'draw\', \''+oplName+'\', \'Secret\', \'plName\', \'Secret\', 1, null, null);return false;">手札から１枚引く</a>'

                                            +'</li>';
                        addTagAppend('#oplPlace', 'ul', 'player', oplName, oplTagValue, '', '', '', '');
                        // カード操作
                        var oplTagValue2 = '<option value="'+oplName+'" id="'+oplName+'Select">'+oplName+'</option>';
                        addTagAppend('#selectMember', '', '', '', oplTagValue2, '', '', '', '');
                    }
                }
            });

            // ログアウト者を削除
            var dispMembers = $(".player").get();
            var delMemberIds = new Array();
            var delMemberSelect = new Array();
            for(i=0;i<dispMembers.length;i++) {
                var id = $(".player").get(i).id;
                if ((id != 'deckCardSet' && id != 'plName' && id != 'noMember')
                    && jQuery.inArray(id, nowMembers)=="-1") {
                    delMemberIds.push("#"+id);
                    delMemberSelect.push("#"+id+'Select');
                }
            }

            if (delMemberIds[0]) {
                for(i=0;i<delMemberIds.length;i++) {
                    flg = true;
                    // カード卓
                    $(delMemberIds[i]).remove();
                    // カード操作
                    $(delMemberSelect[i]).remove();
                }
            }
            // メンバーが変化していれば更新
            if (flg && ifModifiedField) {
                dispDeckStatus(false, true);
            }
        }
    });
}

// 現在のデック設定を読み込んで表示
function dispDeck(cacheStatus) {
    // デック設定読み込み
    var log = deckFile+'?e='+dateD;

    // キャッシュ削除
    if (!cacheStatus) {
        $.ajax({
            type: "get",
            url: log,
            ifModified: false,
            cache: false,
            dataType: "json",
            success: function(data){
                dispDeck(true);
            }
        });
        return false;
    }

    // デック設定読み込み
    var log = deckFile+'?e='+dateD;
    $.ajax({
        type: "get",
        url: log,
        ifModified: true,
        cache: true,
        dataType: "json",
        // デック更新
        success: function(data){
            $("#deckConfig").text("");
            $("#deckSetName").text("");
            $("#cardSpace").text("");

            // データがなければ終了
            if (data=="undefined" || !data) {
                return false;
            }
            if (data=="なし" || data["config"]["name"]=="undefined") {
                $('#deckSetName').text("なし");
                $('.command').hide();
                return false;
            }

            // デック名
            $('#deckSetName').text(data["config"]["name"]);
            $('.command').show();
            // 他デック設定
            // デックファイル名
            replaceTagAppend("#deckConfig", "span", "deckConfig", "DeckFileName", data["config"]["filename"], '', "", "", "")
            // デック背面画像ファイル名
            deckBgImageFilename = data["config"]["bg_image"];
            // 背面画像
            if (deckBgImageFilename) {
                var deckBgImage = loadImageObj(deckBgImageFilename);
            }
            // 正逆設定
            deckHead = data["config"]["is_head"];

            // デックセット
            // 伏せカード
            addTagAppend('#cardSpace', 'div', 'card secretCard', "secretCard", '', '', '', '', '');
            if (deckBgImage && deckBgImage.src!="undefined") {
                $("#secretCard").css("background-image", "url("+deckBgImage.src+")");
            }
            // オープンカード
            var cardBgImage = new Array();
            $.each(data, function(i){
                // カード設定
                if (i=="config") {
                    if (data["config"]["bg_color"]) {
                        card_bg_color = "#"+data["config"]["bg_color"];
                    } else {
                        card_bg_color = '#'+cardBgColor;
                    }
                    if (data["config"]["text_color"]) {
                        card_text_color = "#"+data["config"]["text_color"];
                    } else {
                        card_text_color = '#'+cardTextColor;
                    }
                    $('.openCard').css("background-color", card_bg_color);
                    $('.openCard').css("color", card_text_color);
                    $('#cardDetail').css("background-color", card_bg_color);
                    $('#cardDetail').css("color", card_text_color);
                    $('.cardText').css("color", card_text_color);
                // デック表示
                } else {
                    if (!data[i]["name_short"]) {
                        return false;
                    }
                    // 正逆
                    if (data[i]["head"]) {
                        data[i]["name_short"] = "(逆)" + data[i]["name_short"]; 
                    }


                    // 詳細表示
                    var cardDetailId = 'cardDetail'+i;

                    var title = data[i]["name_long"];
                    if (data[i]["image_b"]) {
                        var img = loadImageObj(data[i]["image_b"]);
                    } else {
                        var img = '';
                    }
                    var body = '';
                    if (data["config"]["text_prefix"]) {
                        body += data["config"]["text_prefix"];
                    }
                    if (data[i]["text"]) {
                        body += data[i]["text"];
                    }
                    if (data["config"]["text_postfix"]) {
                        body += data["config"]["text_postfix"];
                    }

                    var cardDetailTag = '<div class="title">'+title+'</div>';
                    if (img || body) {
                        if (img) {
                            cardDetailTag += '<div class="cardDetailImage">';
                            cardDetailTag += '<img src="'+img.src+'">';
                            cardDetailTag += '</div>';
                        }
                        if (body) {
                            cardDetailTag += '<div class="cardText">'+body+'</div>';
                        }
                    }
                    addTagAppend('#cardSpace', 'div', 'cardDetailData', cardDetailId, cardDetailTag, '', '', '', '');

                    // カード出力
                    var tagValue = '';

                    // カード左表示
                    tagValue += '<div class="cardLeftValue">';
                    if (data[i]["text_color"]) {
                        tagValue += '<font color="#'+data[i]["text_color"]+'">';
                    }
                    tagValue += data[i]["name_short"];
                    if (data[i]["text_color"]) {
                        tagValue += '</font>';
                    }
                    tagValue += '</div>'+"\n";

                    // カード作成
                    addTagAppend('#cardSpace', 'div', 'card openCard', i, tagValue, 'showCard(this)', 'hideCard(this)', 'cardClick(this);', '');
                    var cardId = "#"+i;

                    // カード主画像
                    if (data[i]["image_s"]) {
                        cardBgImage[i] = loadImageObj(data[i]["image_s"]);
                        if (cardBgImage[i].src) {
                            $(cardId).css("background-image", 'url("'+cardBgImage[i].src+'")');
                        }
                    }
                    $(cardId).css("background-color", card_bg_color);
                    $(cardId).css("color", card_text_color);

                }
            });
        },
        error: function(){
        }
    });
}

// 現在のカード配置を読み込んで表示
function dispDeckStatus(ifModifiedStatus, end) {
    var log = deckStatus+'?e='+dateD;

    // デック状態読み込み
    $.ajax({
        type: "get",
        url: log,
        ifModified: ifModifiedStatus,
//        cache: true,
        dataType: "json",
        // カード配置更新
        success: function(data){
            // 卓をアミカケ
            showNowLoading();

            $(".contents").text('');
            // データがなければ終了
            if (data=="undefined" || !data) {
                return false;
            }

            // カード配置
            var nowMember = new Array();
            var noMemberCardNum = 0;
            var totalCardNum = 0;
            $.each(data, function(owner){
                var cardSet = data[owner];
                // 難読化
                if (obfuscateLog == '1') {
                    var ownerName = deObfLog(owner);
                } else {
                    var ownerName = owner;
                }
                var ownerId = "#"+ownerName;

                if (owner && data[owner]) {
                    var isField = false;
                    var isOwner = false;
                    var isNoMember = false;
                    // 山
                    if (ownerName == 'deckCardSet') {
                        var isField = true;
                        ownerName = 'deck';
                    // 閲覧者のカード表示
                    } else if (ownerName == loginName) {
                        var isOwner = true;
                        ownerName = 'my';
                    // 参加者のカードではない
                    } else if (!$(ownerId).text()) {
                        var isNoMember = true;
                    }

                    // 手札と場札
                    $.each(cardSet, function(status){
                        var card = cardSet[status]["card"];
                        if (status && card) {
                            // カード表示場所
                            var targetPlace = 'div#'+ownerName+status+'>.contents';
                            for (var i=0;i<card.length;i++) {
                                totalCardNum++;
                                if (card[i]) {
                                    // カード表示
                                    // カード表示はオープンか
                                    var isOpen = false;
                                    if (isOwner || (status == "Field" && card[i]["open"])) {
                                        var isOpen = true;
                                    }

                                    // 参加者以外のカード
                                    if (isNoMember) {
                                        noMemberCardNum++
                                    } else {

                                        // 伏せカード
                                        if (!isOpen) {
                                            var targetCard = $("#secretCard").clone(true);
                                            $(targetPlace).append(targetCard);

                                            targetCard.attr("id", 'secretCard'+totalCardNum);
                                            var targetCardId = '#secretCard'+totalCardNum;
                                        // オープンカード
                                        } else {
                                            // 難読化
                                            if (obfuscateLog == '1') {
                                                var cardId = deObfLog(card[i]["id"]);
                                            } else {
                                                var cardId = card[i]["id"];
                                            }

                                            var targetCardId = cardId;

                                            var targetCardId = "#"+targetCardId;
                                            if ($(targetCardId).text()) {
                                                var targetCard = $(targetCardId).clone(true);
                                                if (deckHead) {
                                                    if (card[i]["head"] && card[i]["head"]!="false") {
                                                        targetCard.children().prepend("(逆)");
                                                    }
                                                }
                                            }
                                            $(targetPlace).append(targetCard);
                                            if (targetCard != undefined) {
                                                var targetCardId = "#"+targetCard.attr('Id');
                                            }
                                        }

                                        // カード調整
                                        if (isOpen) {
                                            var pitch = 14;
                                        } else {
                                            var pitch = 4;
                                        }
                                        cardShift(targetCardId, pitch*i);
                                        $(targetCardId).css("z-index", Number(10)+i);
                                    }
                                }
                            }
                        }
                       });
               }
            });

            // カード表示の調整
            // IE用
            if (isIE) {
                $(".card").css("width", "32px");
                $(".card").css("height", "42px");
            }
            // 非参加者のカード表示
            $('#noMemberCardsNum').text(noMemberCardNum);

            if (end) {
                hideOverLay();
            }
        }
    });
}

// カードを毎に表示調整
function cardShift(cardId, pitch) {
    var leftPos = $(cardId).css("left");
    if (leftPos != undefined) {
        leftPos = $(cardId).css("left").substring(0, leftPos.length-2);
    leftPos = Number(leftPos)+Number(pitch);
    $(cardId).css("left", leftPos+"px");
    return leftPos;
    } else {
        return null;
    }
}

// カード表示(マウスオーバ)
function showCard(Obj) {
    prevZIndex = Obj.style.zIndex;
    Obj.style.zIndex = 9999;
}
function hideCard(Obj) {
    Obj.style.zIndex = prevZIndex;
}

// カードをクリック
function cardClick(Obj) {
    // カード情報
    var id = "#"+Obj.id;
    var card = $(id);
    var field = card.parent().parent().attr("class");
    var owner = card.parent().parent().parent().parent().children().attr("id");

    // カード詳細情報セット
    var cardDetailEl = '#cardDetail'+Obj.id;
    var cardTitleEl = cardDetailEl+' > .title';
    var cardImgEl = cardDetailEl+' > .cardDetailImage > img';
    var cardBodyEl = cardDetailEl+' > .cardText';

    $("#cardDetail > #header > .cardTitle").html($(cardTitleEl).text());

    if ($(cardImgEl).attr("src") && $(cardImgEl).attr("src") != undefined) {
        var Img = $(cardImgEl).clone();
        $('#cardDetail > #body > .cardDetailImage').html(Img);
        $('#cardDetail > #body > .cardDetailImage').css("width", "80px");
        $('#cardDetail > #body > .cardText').css("width", "100px");
    } else {
        $('#cardDetail > #body > .cardDetailImage').html("");
        $('#cardDetail > #body > .cardDetailImage').css("width", "0");
        $('#cardDetail > #body > .cardText').css("width", "190px");
    }
    $("#cardDetail > #body > .cardText").html($(cardBodyEl).html());
    $("#cardDetail > #footer > form > #selectCardId").val(Obj.id);
    $("#cardDetail > #footer > form > #selectFrom").val(owner);
    $("#cardDetail > #footer > form > #selectField").val(field);

    // カード操作ボタン表示
    if (owner == loginName && field == 'Secret') {
        $("#oneDraw").hide();
    } else {
        $("#oneDraw").show();
    }

    // カード詳細情報表示
    var x = parseInt($(Obj).offset().left);
    $("#cardDetail").css("left", x-35);
    var y = parseInt($(Obj).offset().top);
    $("#cardDetail").css("top", y+42);
    $("#cardDetail").show();
}

// カードを引く枚数指定
function getCardDrowNum(Id) {
    var cardNum = $(Id).attr("value");
    if (!checkCardNum(cardNum)) {
        return false;
    }
    return cardNum;
}

// カード枚数指定チェック
function checkCardNum(cardNum) {
    if (!cardNum) {
        alert('枚数を指定して下さい');
        return false;
    }
    cardNum = parseInt(cardNum, 10);
    if (isNaN(cardNum)) {
        alert('枚数は半角数字で指定して下さい');
        return false;
    }
    return true
}

// カードを引く・出す
function updateCardStatus(action, from, fieldFrom, to, fieldTo, cardNum, castCardId, castCardHead) {
    if (!loginName) {
        alert('ログインして下さい');
        return false;
    }

    if (!checkCardNum(cardNum)) {
        return false;
    }

    if (!from || !fieldFrom || !to || !fieldTo) {
        return false;
    }

    if (from == to && fieldFrom == fieldTo) {
        alert('同じ場所です');
        return false;
    }

    var fromCards = "#"+phpHtmlspecialchars(from)+" ."+fieldFrom+" .contents>div";

    if (castCardId) {
        var castCardId2 = "#"+castCardId;
        if (!$(castCardId2).text()) {
            alert('カードがありません');
            return false;
        }
    } else {
        var fromCardNum = $(fromCards).size();
        if (!fromCardNum || fromCardNum==0) {
            alert('カードがありません');
            return false;
        }
    }

    if (from=="deckCardSet") {
        var fromName = "現在のカード";
    } else if (from=="plName") {
        var fromName = loginName;
        from = loginName;
    } else {
        var fromName = from;
    }
    if (fieldFrom=="Secret") {
        if (from=="deckCardSet") {
            fromName += "の山札";
        } else {
            fromName += "さんの手札";
        }
    } else {
        if (from!="deckCardSet") {
            fromName += "さん";
        }
        fromName += "の場札";
    }

    var returnFlag = false;
    if (to=="deckCardSet") {
        var toName = "現在のカード";
    } else if (to=="plName") {
        var toName = loginName;
        to = loginName;
    } else {
        var toName = to;
    }
    if (fieldTo=="Secret") {
        if (to=="deckCardSet") {
            toName += "の山札";
            returnFlag = true;
        } else {
            toName += "さんの手札";
        }
    } else {
        if (to!="deckCardSet") {
            toName += "さん";
        }
        toName += "の場札";
    }

    var confirmMsg = fromName+"から"+toName+"へ";
    if (!castCardId) {
        confirmMsg += cardNum+"枚";
    } else {
        confirmMsg += $(castCardId2).text()+"を";
    }
    if (action=='draw') {
        confirmMsg += "引きます";
        var playerActionSystem = "d";
    } else if (action=='cast') {
        if (returnFlag) {
            confirmMsg += "戻します。\n戻すと"+toName+"はシャッフルされます";
        } else if (fieldTo=="Secret" && fieldFrom=="Secret") {
            confirmMsg += "渡します";
        } else  {
            confirmMsg += "出します";
        }
        var playerActionSystem = "c";
    } else {
        alert('そのカード移動はできません');
        return false;
    }

    var updateCardStatusConfirm = confirm(confirmMsg+"。\nよろしいですか？");
    if (!updateCardStatusConfirm) {
        return false;
    }

    if (fromCardNum < cardNum) {
        var shortCardMsg = fromCardNum+"枚しか";
        if (action=='draw') {
            shortCardMsg += "引けません";
        } else if (action=='cast') {
        shortCardMsg += "出せません";
        } else {
            return false;
        }
        var shortCardConfirm = confirm(shortCardMsg+"。\nよろしいですか？");
        if (!shortCardConfirm) {
            return false;
        }
    }

    // 正逆指定
    var cardIsTail = false;
    if (deckHead && castCardHead) {
        if (castCardId) {
            var castCardHeadset = confirm("”正位置”で出します。\nよろしいですか？\n　　OK：正位置で出す　キャンセル：逆位置で出す");
            if (castCardHeadset) {
                var cardIsTail = false;
            } else {
                var cardIsTail = true;
            }
        } else if (action=='cast') {
            var cardIsTail = "rand";
        }
    }

    // カード更新
    var params = setCardStatus(from, fieldFrom, to, fieldTo, cardNum, castCardId, playerActionSystem, cardIsTail);
    // カード配置書き込み
    writeCardStatus(params);

}

// カードを指定して移動
// 指定カードIDを取得
function getSelectCardId() {
    // カード指定
    var selectCardId = $("#selectCardId").attr("value");
    if (!selectCardId || selectCardId == undefined) {
        alert('カードが正しく選択できていません');
        return false;
    }
    return selectCardId;
}

// カードを1枚指定して引く
function selectCardDraw() {
    var selectCardId = getSelectCardId();
    if (!selectCardId) {
        return false;
    }
    var SelectCardJId = "#"+selectCardId;

    // 指定カードが自分の手札ではないか
    var isMySecretCards = ".player .Secret .contents>div"+SelectCardJId;
    if ($(isMySecretCards).size()) {
        alert('あなたの手札です');
        return false;
    }

    var action = 'draw';
    var from = $("#selectFrom").attr("value");
    var to = 'plName';
    var fieldFrom = $("#selectField").attr("value");
    var fieldTo = 'Secret';
    var castCardId = selectCardId;
    updateCardStatus(action, from, fieldFrom, to, fieldTo, 1, castCardId, false);
    $("#cardDetail").hide();
}

// カードを1枚指定して出す
function selectCardCast(field) {
    var selectCardId = getSelectCardId();
    if (!selectCardId) {
        return false;
    }
    var SelectCardJId = "#"+selectCardId;

    var action = 'cast';
    var from = $("#selectFrom").attr("value");
    var to = $('select#selectMember option:selected').val();
    var fieldFrom = $("#selectField").attr("value");
    var fieldTo = field;
    var castCardId = selectCardId;

    // 移動権限チェック
    if (fieldFrom=='Secret' && from!=loginName) {
        alert('移動できません');
        $("#cardDetail").hide();
        return false;
    }
    if (deckHead && fieldTo=='Field') {
        var cardIsTail = true;
    } else {
        var cardIsTail = false;
    }
    updateCardStatus(action, from, fieldFrom, to, fieldTo, 1, castCardId, cardIsTail);
    $("#cardDetail").hide();
}

// 指定フィールドのカードを全て山に戻す
function returnCard(field, fromId) {
    if (!loginName) {
        alert('ログインして下さい');
        return false;
    }

    // カード全回収
    if (field=="all") {
        returnAllCard();
        return false;
    // 退室者のカードを回収
    } else if (field=="nomember") {
        returnNoMemberCard();
        return false;
    }

    if (!field || !fromId) {
        return false;
    }

    var fieldObj = $(field);
    if (!fieldObj) {
        return false;
    }
    var fromCardNum = $(fieldObj).children().size();
    if (!fromCardNum || fromCardNum==0) {
        alert('カードがありません');
        return false;
    }
    var fieldFrom = $(fieldObj).parent().attr("class");

    fromId = "#"+fromId;
    var fromName = $(fromId).children().attr("id");
    if (fromName=='deckCardSet') {
        var returnCardName = '場札';
    } else if (fromName==loginName) {
        var returnCardName = loginName+'の手札';
    } else {
        return false;
    }
    var fromId = "#"+fieldObj.parent().attr("id");

    var to = "deckSecret";
    var toName = '山';
    var toId = "#"+to;

    var confirmMsg = returnCardName+"を"+toName+"へ";
        confirmMsg += "戻します\n";
        confirmMsg += "戻すと"+toName+"はシャッフルされます";

    var returnCardConfirm = confirm(confirmMsg+"。\nよろしいですか？");
    if (!returnCardConfirm) {
        return false;
    }

    // カード更新
    var params = setCardStatus(fromName, fieldFrom, "deckCardSet", "Secret", "", "", "r", "");

    // カード配置書き込み
    writeCardStatus(params);
}

// カード更新用データ整形
function setCardStatus(from, fieldFrom, to, fieldTo, cardNum, castCardId, playerActionSystem, cardIsTail)
{
    //データ成形
    var params =
        '?n='+convert(loginName)//操作者名
        +'&f='+convert(from)//カード移動元
        +'&ff='+fieldFrom//手札か場札か
        +'&t='+convert(to)//カード移動先
        +'&ft='+fieldTo//手札か場札か
        +'&cn='+cardNum;//数
        if (castCardId) {
            params +='&id='+castCardId//カードID指定
        }
        params +='&a='+playerActionSystem//行動
        if (to==loginName && fieldTo=='Secret') {
            params +='&tm='+1//「引く」
        } else {
            params +='&tm='+0
        }

        if (cardIsTail) {
            params +='&ih='+cardIsTail;//正逆有無
        }

    return params;
}

// 書き込み
function writeCardStatus(params)
{
    // 参加確認
    var joinFlg = false;

    $.ajax({
        type: "get",
        url: now_member,
        ifModified: false,
//        cache: true,
        dataType: "text",
        // 受信完了イベント
        success: function(data) {
            var memberList = data.split("\n");
            $.each(memberList, function(i){
                var memberData = memberList[i].split("<>");
                if (obfuscateLog == '1') {
                    memberData[0] = deObfLog(memberData[0]);
                }
                if (memberData[0]==phpHtmlspecialchars(loginName)) {
                    joinFlg = true;
                }
            });
            if (!joinFlg) {
                alert('参加者リストにお名前がないので、カードを操作できません。\n長時間発言がないと、参加者リストから削除されます。\nチャットで発言すると、参加者リストに復帰します。');
            } else {
                showNowLoading();
                // 書き込み
                $.ajax({
                    type: "GET",
                    url: cardUpdateScript+params,
                    cache: false,
                    dataType: "json",
                    // 受信完了イベント
                    success: function(data) {
                        setCardManageToChat(data);
                    },
                    error:function() {
                        alert('カード操作に失敗しました');
                    }
                });
            }
        },
        error:function() {
            alert('失敗しました');
            return false;
        }
    });

}

// デック変更
function changeDeck(selectedDeck, writeChatMsg) {
    if (!selectedDeck) {
        var selectedDeckType = $('select#deckSelect option:selected').val();
    } else {
        var selectedDeckType = selectedDeck;
    }
    if (!selectedDeckType || selectedDeckType==undefined || selectedDeckType=='カード変更') {
        alert('カードを選択してください');
        return false;
    }
    var changeDeckConfirm = confirm("現在配られているカードは全て回収されます。\nよろしいですか？");
    if (changeDeckConfirm) {
        // カード読み込み
        var script = './card_deck_change.php';
        var url = script
            +'/?newdeck='+selectedDeckType
            +'&n='+convert(loginName);
        $.ajax({
            type: "get",
            url: url,
            cache: false,
            dataType: "json",
            success: function(data){
                if (writeChatMsg) {
                    data[0]['msg'] = writeChatMsg;
                }
                   setCardManageToChat(data);
                dispCardField(false);
            },
            error: function(data){
                alert('カード変更に失敗しました');
            }
        });
    }
}

// 全てのカードを回収
function returnAllCard(g) {
    var changeDeckConfirm = confirm("全てのカードを山に戻してシャッフルします。\nよろしいですか？");
    if (changeDeckConfirm) {
        // カード読み込み
        var script = './card_return_all.php';
        var url = script
            +'/?n='+convert(loginName);
        $.ajax({
            type: "get",
            url: url,
            cache: false,
            dataType: "json",
            success: function(data){
                if (data) {
                    setCardManageToChat(data);
                }
            },
            error: function(data){
                alert('カード回収に失敗しました');
            }
        });
    }
}

// 退室者のカード回収
function returnNoMemberCard(g) {
    var changeDeckConfirm = confirm("退室者のカードを、全て山に戻してシャッフルします。\nよろしいですか？");
    if (changeDeckConfirm) {
        // カード読み込み
        var script = './card_return_nomember.php';
        var url = script
            +'/?n='+convert(loginName);
        $.ajax({
            type: "get",
            url: url,
            cache: false,
            dataType: "json",
            success: function(data){
                if (data) {
                    setCardManageToChat(data);
                }
            },
            error: function(data){
                alert('カード回収に失敗しました');
            }
        });
    }
}

// カード操作をチャットに書き込む
// 最大2行まで
function setCardManageToChat(data) {
    if (!data[0]['msg']) {
        return false;
    }
    var params = setCardManageToChatParam(data[0]);
    $.ajax({
        type: "GET",
        url: cardWritescript+params,
        cache: false,
        success: function(dat) {
            // 受信完了イベント
            if (data[1]!=undefined) {
                var params2 = setCardManageToChatParam(data[1]);
                if (data[1]['secretTo'] && data[1]['secretTo']!=undefined) {
                    var url = cardWritescript2+params2;
                } else {
                    var url = cardWritescript+params2;
                }
                $.ajax({
                    type: "GET",
                    url: url,
                    cache: false,
                    success: function(dat) {
                    }
                });
            } else {
                window.mainframe.getLog(false);
            }
        }
    });
}
// カード操作書き込み用データ成形
function setCardManageToChatParam(data) {
    var params =
        '?n='+convert(loginName)//名前
       +'&m='+convert(data['msg']); //本文
    if (data['isSecret']!=undefined) {
        if (pwd!=undefined) {
            params += '&w='+convert(loginName)//whisperto
                   +  '&h='+loginHash;//whisperto_hash
        }
        if (data['secretTo']!=undefined) {
            params += '&w2='+convert(data['secretTo'])//whisperto2
        }
    }
    if (pwd!=undefined) {
        params += '&p='+convert(pwd);//PWD
    }
    params += '&y=card'
       +'&e='+(new Date()).getTime();//cacheの更新
    return params;
}

// タグ名(括りあり）classとID、valueを指定して指定タグ内の最初の要素として追加
function addTagPrepend(targetId, tag, tagClass, tagId, tagValue, onMouseOver, onMouseOut, click, DD) {
    var content = setTag(tag, tagClass, tagId, tagValue, onMouseOver, onMouseOut, click, DD);
    $(targetId).prepend(content);
}

// タグ名(括りあり）classとID、valueを指定して、指定タグ内に表示(置換）
function replaceTagAppend(targetId, tag, tagClass, tagId, tagValue, onMouseOver, onMouseOut, click, DD) {
    var content = setTag(tag, tagClass, tagId, tagValue, onMouseOver, onMouseOut, click, DD);
    $(targetId).html(content);
}

// タグ名(括りあり）classとID、valueを指定して、指定タグ内の最後の要素として追加
function addTagAppend(targetId, tag, tagClass, tagId, tagValue, onMouseOver, onMouseOut, click, DD) {
    var content = setTag(tag, tagClass, tagId, tagValue, onMouseOver, onMouseOut, click, DD);
    $(targetId).append(content);
}
// タグ名(括りあり）classとID、valueを指定してタグ形成
function setTag(tag, tagClass, tagId, tagValue, onMouseOver, onMouseOut, click, DD) {
    if (!tag) {
        return tagValue;
    }
    var tagContent = '<'+tag;
    if (tagClass) {
        tagContent += ' class=\"'+tagClass+'\"';
    }
    if (tagId) {
        tagContent += ' id=\"'+tagId+'\"';
    }
    if (onMouseOver) {
        tagContent += ' onMouseover=\"'+onMouseOver+'\"';
    }
    if (onMouseOut) {
        tagContent += ' onMouseout=\"'+onMouseOut+'\"';
    }
    if (click) {
        tagContent += ' onclick=\"'+click+'\"';
    }
    tagContent += '>';
    if (tagValue) {
        tagContent += tagValue;
    }
    tagContent += '</'+tag+'>';
    return tagContent;
}

// ランダムでboolean型を返す
function randomBool() {
    var rand = Math.floor(Math.random() * 2);
    return Boolean(rand);

}

// 卓上にアミカケ＆操作停止
// カードデータ読み込み中、アミカケ表示
function showNowLoading() {
    var msg = '';
    if (nowLoadingIcon) {
        msg += '<img src="'+nowLoadingIcon+'">';
    }
    msg += '...Now Loading...';

    var left = ($(window).width() - 200) /2 + 'px';
    $.blockUI({
        message: msg,
        css: { 
            border: 'none',
            padding: '0',
            left: left,
            width: '200px',
            '-webkit-border-radius': '5px',
            '-moz-border-radius': '5px',
            opacity: '1'
        }
    });
}
// アミカケ解除
function hideOverLay() {
    $.unblockUI();
}

// デック追加
// デックコンソール表示
function toggleDeckConsole() {
    $("#deckUtil").toggle();
}

// ウインドウサイズ変更でフォームサイズ変更
function changeSize() {
    var winWidth = getWinWidth();
    var winHeight = getWinHeight() - 80;
    $("#deckUtil").css({left: winWidth-218});
}

// 起動時表示系処理
function pageLoad() {
    // 入室チェック
    loginData = checkLogin();
    if (!loginData[0]) {
        alert("カード機能の使用にはチャットログインが必要です。");
        close();
        return false;
    }

    loginName = loginData[0];
    loginHash = loginData[1];
    pwd = loginData[2];

    // 場を表示
    $('#deckType').css('display', 'block');
    $('#plhash').val(loginHash);
    replaceTagAppend('ul#plName>li#playerName', 'span', 'nameValue', 'name', loginName, '', '', '', '');
    $('ul#plName>li#playerName').attr('id', loginName);

    // 現在のデック設定を表示
    dispCardField(false);
    dispDeck(false);
    dispDeckStatus(false, false);

    // カード詳細
    $("#cardDetail").accordion({
        event: 'dblclick',
        alwaysOpen: false,
        autoHeight: true,
        header: 'div#header'
    });

    // ウィンドウサイズに合わせる
    changeSize();

    // 自動更新
    deckTimer = setInterval('dispCardField(true)', getdata_on);
    deckTimer = setInterval('dispDeck(true)', getdata_on);
    deckTimer = setInterval('dispDeckStatus(true, true)', getdata_on);

    // コンソール窓設定
    $(".console").draggable({
        cursor:'move',
        helper:'original'
    });
    $(".console").draggable('enable');
}