<?php
/*
 Ajax Chat for TRPG ver.2.6
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：携帯用
 *****************/

// 文字コード変換
ini_set('mbstring.http_output' , 'SJIS-win');

require_once './lib/log.php';

// ユーザの情報
if (REC_UA) {
    $host = gethostbyaddr($_SERVER['REMOTE_ADDR']);
}
$ua = getenv("HTTP_USER_AGENT");

/*
 * 携帯からのアクセスチェック
 * 携帯からのアクセス:true
 */
function is_mobile_access($ua)
{
    if (!USE_ONLY_MOBILE) {
        return true;
    }

    // 携帯UAのキーワード配列から検索パターンを作成
    if (!$GLOBALS['AJAX_CHAT_TRPG']['MOBILE_UA_TEXT']) {
        return false;
    } else {
        $pattern = '';
        foreach ($GLOBALS['AJAX_CHAT_TRPG']['MOBILE_UA_TEXT'] as $v) {
            if ($pattern) {
                $pattern .= '|';
            }
            $pattern .= $v;
        }
        $pattern = '/'.$pattern.'/';
    }
    $result = preg_match($pattern, $ua, $matches);

    if ($result === false) {
        error('表示できません');
    } else {
        return (bool)$result;
    }
}

/*
 * 携帯用ログ成形
 */
function mobile_read_log($lines_num=10, $read_systemlog=false)
{
    // ログの読み込み
    $log = array();
    $log = file(RECENT_LOG);

    $row = '';
    if (is_array($log)) {

        // データの成形
        $i = 0;
        foreach($log as $k => $v) {
            if ($v[0] != 0) {
                 // 基本整形
                 list($num, $name, $pc, $color, $com, $datetime, $host, $whisper_from_pass, $whisper_to_name, $whisper_to_pass, $w, $status, $isMobile) = format_log($v, '', SHOW_DATETIME_MOBILE, true);

                 // 難読化
                if (OBFUSCATION) {
                    list($pc, $com, $name, $whisper_to_name, $status) = decode_obf_log($pc, $com, $name, $whisper_to_name, $status);
                }

                 // システムログ表示
                 if (!$read_systemlog && $pc == SYSTEM) {
                     continue;
                 }
                // 行の成形
                if ($num && $w != 'y') {
                    // 現状、携帯でささやき表示なし
                    $row .= '<font color="#'.$color.'">['.$pc.']';
                    if (SHOW_MOBILE_COM && $isMobile == 1) {
                        $row .= '(M)';
                    } 
                    $row .= '</font>: ';

                    $row .= $com;
                    if ($status || (SHOW_DATETIME_MOBILE && $datetime)) {
                        $row .= ' <font color="#'.STATUS_COLOR.'">';
                    }
                    if ($status) {
                        $row .= '('.$status.')';
                    }
                    if (SHOW_DATETIME_MOBILE && $datetime) $row .= ' ['.$datetime.']';
                    if ($status || (SHOW_DATETIME_MOBILE && $datetime)) {
                        $row .= '</font>';
                    }
                    $row .= '<br>'."\n";
                }
            }
            $i++;

            // 指定行チェック
            if ($i > $lines_num) break;
        }
    }
    return $row;
}

/* 
 * 携帯表示チェック
 * 表示OK:true
 */
function is_show_mobile_body()
{
    $referer = $_SERVER['HTTP_REFERER'];
    $url = get_self_url();
    $pos = strpos($referer, $url);
    if ($pos === 0) {
        return true;
    } else {
        return false;
    }
}

/* 
 * 携帯用ヘッター・フッター
 */
function html_mobile_header($title)
{
    $font_size = intval(MOBILE_FONT_SIZE);
print <<<EOF
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS">
<title>$title</title>
</head>
EOF;
print '<body text="#'.MAIN_TEXTCOLOR.'" link="#'.MAIN_LINK.'" vlink="#'.MAIN_VLINK.'" bgcolor="#'.MAIN_BGCOLOR.'">';
print '<font size="'.$font_size.'">';
}
function html_mobile_footer($copyright) 
{
    print "<hr>";
    if ($copyright) {
        print '<div align="center"><font size="1">'.MOBILE_COPYRIGHT.'</font></div>'."\n";
    }
print <<<EOF
</font>
</body>
</html>
EOF;
}

/* 
 * 携帯用エラー画面表示
 */
function mobile_error($msg)
{
    error_log($msg);

    html_mobile_header('error');
    $error = "<p>エラー</p>\n";
    $error .= "<p>$msg</p>\n";
    $error = mb_convert_encoding($error, 'SJIS-win', auto);
    print $error;
    html_mobile_footer(true);

    exit;
}
?>