<?php
/*
 Ajax Chat for TRPG ver.2.6
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';

// 設定セット
set_config(read_config());

// アクセスブロック
access_block();

$self_url = get_self_url();
$ktai_url = str_replace('info-mobile.php', 'mindex.php', $self_url);

// メール送信用設定
$ktai_mail_header = CHAT_TITLE.'携帯用URL';
$ktai_mail_body = CHAT_TITLE.' 携帯用URLはこちらです。'."\n".$ktai_url."\n";

$ktai_mail_header = rawurlencode(mb_convert_encoding($ktai_mail_header, 'SJIS', 'UTF-8'));
$ktai_mail_body = rawurlencode(mb_convert_encoding($ktai_mail_body, 'SJIS-win', 'UTF-8'));

// 携帯使用設定
if (!USE_MOBILE) {
    error('携帯からはご利用できません。');
}

// 表示内容
$msg = nl2br(MOBILE_INFO_MSG);
$msg .= '<p>但し携帯からのご利用には、以下の制限があります。<ul><li><b>自動更新はされません。</b></li><li>頻繁な読み込みはサーバに負担をかけるため、ご遠慮下さい。</li><li>携帯からの書き込みは、<b>参加者欄に表示されません。</b></li><li>「ささやき」「設定のクッキー保存」「PC発言（入室者名以外での書きこみ）」「かんたんダイス入力ボタン」など、一部機能は使用できません。</li></ul></p>';
$mail_str = '<p><a href="mailto:?subject='.$ktai_mail_header.'&body='.$ktai_mail_body.'">携帯用URLをメールで送信</a></p>';
if (defined('QRCODE') && QRCODE) {
    $qrcode = '<img src="'.QRCODE.'" alt="携帯用URL '.$ktai_url.'" class="qrcode"> ←QRコードからアクセス';
}



// HTML出力
print html_header('携帯からのご利用について', 'index', false, false);
print <<<MOBILE
<style type="text/css">
<!--
* {
	margin: 5px;
}
-->
</style>
</head>
<body>

$msg
<hr>
$mail_str
$qrcode

MOBILE;

print  '<center><FORM><INPUT TYPE="button" VALUE="閉じる" onClick="javascript:window.close()"></FORM></center>'."\n";

print  html_footer();
exit;

?>