<?php
/*
 * Ajax Chat for TRPG ver.2.5
 * (c)2007-2009 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';

// パスワードの照合
auth();

// 設定セット
set_config(read_config());

// アクセスブロック
access_block();

$request = request();

// 画面表示：HTML出力
print html_header(CHAT_TITLE.' 管理画面', 'admin', true, true);

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';

?>
</head>
<style type="text/css">
<!--
input, textarea, select {
	margin: 3px 0px;
}

-->
</style>
<body>
<h2 align="center"><?php print CHAT_TITLE; ?> 管理画面</h2>
<br>
<?php
if ($_GET['msg']) print '<p class="msg">'.$_GET['msg'].'</p>';
?>

<table cellspacing="0" align="center">
<tr><td colspan="2">
<p align="center"style="color:blue;" ><b>設定</b></p>
<div align="center">
<span align="left">

</span>
<form action="./edit_config.php" method="<?php print METHOD; ?>">
<input type="hidden" name="mode" value="重要な">
<input type="submit" value="重要な設定"></form>
<form action="./edit_config.php" method="<?php print METHOD; ?>">
<input type="hidden" name="mode" value="TRPG機能関連">
<input type="submit" value="TRPG機能関連設定"></form>
<form action="./edit_config.php" method="<?php print METHOD; ?>">
<input type="hidden" name="mode" value="タグ">
<input type="submit" value="タグ使用設定"></form>
<form action="./edit_config.php" method="<?php print METHOD; ?>">
<input type="hidden" name="mode" value="全体の配色">
<input type="submit" value="全体の配色設定"></form>
<form action="./edit_config.php" method="<?php print METHOD; ?>">
<input type="hidden" name="mode" value="チャット画面の配色">
<input type="submit" value="チャット画面の配色設定"></form>
<form action="./edit_config.php" method="<?php print METHOD; ?>">
<input type="hidden" name="mode" value="全般">
<input type="submit" value="全般設定"></form>
<form action="./edit_config.php" method="<?php print METHOD; ?>">
<input type="hidden" name="mode" value="アイコン">
<input type="submit" value="アイコン設定"></form>
<form action="./edit_config.php" method="<?php print METHOD; ?>">
<input type="hidden" name="mode" value="携帯">
<input type="submit" value="携帯設定"></form>
</div>
<hr>
</td></tr>
<tr><td colspan="2">
<div style="color:blue;" align="center"><b>過去ログ作成</b></div>
<form action="./pastlog_create.php" method="<?php print METHOD; ?>" name="write_log">
<table align="center" style="border:none; margin:auto;">
<tr>
<td><input type="checkbox" name="datetime" value="1">
発言時間表示</td>
<td><input type="checkbox" name="whisper" value="1">ささやき全表示</td>
<td><input checked type="checkbox" name="delete" value="1">ログ削除</td>
</tr>
<tr><td colspan="3" align="center">ログファイル名：<input name="filename" type="text" value="<?php print date('Ymd'); ?>" size="10" maxlength="30" style="ime-mode:disabled;">.html　<input type="submit" value="過去ログ作成"></td></tr>
</table></form>
<span align="left">「ささやき全表示」：指定すると公開ログにも全ての「ささやき」が表示されます。<br>
「ログ削除」：過去ログ作成と同時に、現在のログを全て削除します。<br></span>
<hr>
</td></tr>
<tr><td colspan="2">
<div style="color:blue;" align="center"><b>ディレクトリ編集</b></div>
<form action="./pastlog_edit_dir.php" method="<?php print METHOD; ?>">
<table align="center" style="border:none; margin:auto;">
<tr><td align="center">ディレクトリ名：<input name="dirname" type="text" value="<?php print date('Ym'); ?>" size="10" maxlength="30" style="ime-mode:disabled;">　対象<input name="type" type="radio" value="<?php print PAST_DIR; ?>" checked>公開側<input name="type" type="radio" value="<?php print MASTER_PAST_DIR; ?>">管理側</td></tr>
<tr><td align="right"><input type="submit" name="mode" value="新規作成">　<input type="submit" name="mode" value="削除"></td></tr>
<tr>
<td align="right" nowrap>変更後ディレクトリ名：<input name="dirname_new" type="text" value="" size="10" maxlength="30" style="ime-mode:disabled;">　<input type="submit" name="mode" value="変更"></form></td></tr>
</table>
<span align="left">過去ログ整理用ディレクトリを作成します。<br>
ディレクトリ階層は、１階層のみ有効です。<br>
過去ログファイルがあるディレクトリは削除できません。<br>
ディレクトリ名に使える文字は、半角英数字とハイフン(-)、アンダーバー(_)のみです。<br>
</span>
<hr>
</td></tr>
<tr>
<td valign="top" width="50%">
<h4>公開過去ログ</h4>
<br>
<?php
print_pastlog_contents_list(PAST_DIR, 'root', 'ASC', true, './pastlog_edit_file.php');
?>
</td>
<td valign="top" width="50%">
<h4>管理用過去ログ(非公開)</h4>
<br>
<?php
print_pastlog_contents_list(MASTER_PAST_DIR, 'root_past', 'ASC', true, './pastlog_edit_file.php', '_past');
?>

<h5 style="margin-bottom:0em;">管理用過去ログには、全ての発言時間・ささやき・参加者のホスト情報が記録されます</h5>
<br>
</td>
</tr>
</table>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">過去ログ管理機能は、JavaScript不可の環境では使用できません。</p>
</noscript>

<?php
// フッター
print html_footer();
?>