/*
 * Free Map ver.β1.1
 * (c)2008 Cake All righ1ts reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

//変数の設定
var writescript = './write.php';
var dateD = (new Date()).getTime();

/* ウィンドウ操作系 */
// ウインドウサイズ変更でフォームサイズ変更
function changeSize() {
    getWindowSize();

    $(".status").css({width: winWidth-100});
}

/* ユニット関連 */
/* 画面上のユニット数取得 */
function getUnitNum() {
    return $("div#MapArea > div.unit").size();
}

/* IDを指定してユニットエレメントを返す */
function getUnitById(id) {
    var arr = $("div#MapArea > div.unit").get();
    var result = jQuery.grep(arr, function(unit, i){
        if (unit.id==id) return true;
    });
    return $(result);
}

/* 指定ユニットの情報 */
function getDDUnitInfo(Obj) {
    if (!Obj) return false;
    var data = new Array(); 
    data[0] = Obj.html(); // unitName
    data[1] = Obj.attr("id"); // id(ユニット名+PL名)
    data[2] = Obj.attr("name"); // plName
    data[3] = Obj.attr("title"); // status
    data[4] = parseInt(Obj.css("width")); // w
    data[5] = parseInt(Obj.css("height")); // h
    data[6] = setHexColorCode(Obj.css("background-color"));// bgColor
    data[7] = setHexColorCode(Obj.css("color"));// stColor
    return data;
}

// ユニットセット
function setUnit(unit) {
    if (!unit[0]) {
        return false;
    }
    //データの成形
    var unitName = unit[0];
    var plName = unit[1];
    if (!unit[2]) {
        var unitId = unitName;
    } else {
        var unitId = unitName+plName;
    }
    var x = unit[3];
    var y = unit[4];
    var w = unit[5];
    var h = unit[6];
    var color = unit[7];
    var stcolor = unit[8];
    var info = unit[9];
    var show = unit[10];
    var isShow = 'y';
//    if(unit[10] &&  ハッシュチェック) {
//    }
    var datetime = unit[11];

    // ユニット更新
    updateUnit(unitName, plName, unitId, x, y, w, h, color, stcolor, info, isShow, datetime);
}

/* ユニットにマウスオーバ */
function UnitMouseOver(Obj) {
    if (showUnitnameAll) {return false; }

    Obj.style.overflow = "visible";
}

/* ユニットからマウスアウト */
function UnitMouseOut(Obj) {
    if (showUnitnameAll) {return false; }

    Obj.style.overflow = "hidden";
}

/* ユニット更新 */
function updateUnit(unitName, plName, unitId, x, y, w, h, unitColor, unitStColor, unitInfo, showUnit, z) {
    // 必須項目確認
    if (!unitName || !plName || !unitId) {
        return false;
    }

    // デフォルト値の設定
    var params = setDefaultUnit(x, y, w, h, unitColor, unitStColor);
    var x = params[0];
    var y = params[1];
    var w = params[2];
    var h = params[3];
    var unitColor = params[4];
    var unitStColor = params[5];
    // ユニット画像

    if (isNaN(x) || isNaN(y) || isNaN(w) || isNaN(h)) {
        return false;
    }
    // 画面上に同一IDのユニットがない場合、ユニット追加
    var ddUnit = getUnitById(unitId);
    if (ddUnit.html()==null) {
        mapElm.append(convUnitInfoToTag(unitId, plName, unitInfo, unitColor, unitStColor, w, h, z, unitName, showUnit));
        var ddUnit = $("div.unit:last");
        // 移動可能ならD&D設定
        if (getAvailableDD(ddUnit)) {
            setDragUnit(ddUnit);
        }


    // 同一IDのユニットがある場合、設定変更
    } else {
        ddUnit.html(unitName);
        ddUnit.attr("name", plName);
        ddUnit.attr("title", unitInfo);
        ddUnit.css("background-color", unitColor);
        ddUnit.css("color", unitStColor);
        ddUnit.css("width", w);
        ddUnit.css("height", h);
        ddUnit.css("zIndex", z);
    }

    // 座標指定
    if (x) {
        ddUnit.css("left", x);
    }
    if (y) {
        ddUnit.css("top", y);
    }

}

/* ユニット情報をHTMLタグに変換 */
    // showUnitではstyle="display:none;"
function convUnitInfoToTag(unitId, PlName, unitInfo, unitColor, unitStColor, w, h, z, unitName, showUnit) {
    var tag = '<div class="unit"'
            + ' id="'+unitId+'"'
            +' name="'+PlName+'"'
            +' title="'+unitInfo+'"'
            +' onmouseover="UnitMouseOver(this);"'
            +' onmouseout="UnitMouseOut(this);"'
            +' onmousedown="UnitMouseDown(this);"'
            +' style="'
                +' background-color:#'+unitColor+"; "
                +' color:#'+unitStColor+"; "
                +' width:'+w+'px;'
                +' height:'+h+'px;'
                +' left:0px; top:0px;'
                +' z-index:'+z+';'
            +'">'
        +unitName
        +'</div>';

    return tag;
}

/* IDを指定してユニット削除 */
function delUnitById(Id) {
    $(document.getElementById(Id)).remove();
}


/* DD関連 */
/* ドラッグアンドドロップ可不可の情報
 * id=ユニット名+PL名, PL名＝実施者名ならDD可
 * id=ユニット名なら作成者じゃなくてもDD可（主にデモ用） 
 */
function getAvailableDD(Obj) {
    // 別窓は不可
    if (!parent.cons) { return false; }
    // 未ログインは不可
    if (!parent.cons.$("#oldname").attr("id")) { return false; }

    // アイテム情報
    var plName = parent.cons.$("#plname").attr("value");
    data = new Array();
    data = getDDUnitInfo(Obj);
    var unitName = data[0];
    var id = data[1];
    var unitPlName = data[2];
    switch (id) {
        case unitName+plName: 
            return 'all';
            break;
        case unitName:
            return 'move';
            break;
        default:
            return false;
    }
}

/* ドラッグアンドドロップ */
function UnitMouseDown(Obj) {
    // アイテム情報
    data = new Array(); 
    data = getDDUnitInfo($(Obj));

    // MAP下のユニット表示
    $("#unit_name").html(data[0]);
    $("#pl_name").html(data[2]);
    if (data[3]) {
        $("#unit_status").html(data[3]);
    } else {
        $("#unit_status").html("　");
    }

    // 移動/編集可能な場合
    var available = getAvailableDD($(Obj));
    if (available) {
        // 移動可能表示
        $(Obj).css("cursor", "move");
        $("#move_msg").css("checked", true);
        $("#move_msg").html("移動可能");
        $("#move_msg").css("background", "#ffff99");

        // 編集･削除可能なら、コンソールの編集欄
        // デモユニットは不可
        if (available == "all") {
            parent.cons.$("#unit_name").val(data[0]);
            parent.cons.$("#oldname").val(data[0]);
            parent.cons.document.getElementById("is_edit").checked = true;
            parent.cons.$("#status").val(data[3]);
            parent.cons.$("#unit_w").val(data[4]);
            parent.cons.$("#unit_h").val(data[5]);
            parent.cons.$("#unit_bg_color").val(data[6]);
            parent.cons.$("#unit_name").css("background-color", "#"+data[6]);
            parent.cons.$("#unit_bg_color").css("background-color", "#"+data[6]);
            parent.cons.$("#unit_bg_color_select").css("background", "#"+data[6]);
            parent.cons.$("#unit_st_color").css("background-color", "#"+data[6]);
            parent.cons.$("#unit_st_color_select").css("background", "#"+data[6]);
            parent.cons.$("#unit_st_color_select").children().css("background", "#"+data[6]);
            parent.cons.$("#unit_st_color").val(data[7]);
            parent.cons.$("#unit_name").css("color", "#"+data[7]);
            parent.cons.$("#unit_st_color").css("color", "#"+data[7]);
            parent.cons.$("#unit_st_color_select").css("color", "#"+data[7]);
            parent.cons.$("#unit_bg_color").css("color", "#"+data[7]);
            parent.cons.$("#unit_bg_color_select").css("color", "#"+data[7]);
            parent.cons.$("#unit_bg_color_select").children().css("color", "#"+data[7]);

            parent.cons.document.getElementById("is_edit").disabled = false;
            parent.cons.document.getElementById("delUnit").disabled = false;
        } else {
            parent.cons.$("#oldname").val("");
            parent.cons.$("#unit_name").val("");
            parent.cons.document.getElementById("is_add").checked = true;
            parent.cons.$("#status").val(Status);
            parent.cons.document.getElementById("is_edit").disabled = true;
            parent.cons.document.getElementById("delUnit").disabled = true;
        }
    } else {
        $("#move_msg").css("checked", false);
        $("#move_msg").html("移動不可");
        $("#move_msg").css("background", "transparent");

        if (parent.cons.$("#oldname").attr("id")) {
            parent.cons.$("#oldname").val("");
            parent.cons.$("#unit_name").val("");
            parent.cons.document.getElementById("is_add").checked = true;
            parent.cons.$("#status").val(Status);
        }
    }
}

/* ドラッグ設定 */
function setDragUnit(ddUnit){
    ddUnit.draggable({
        containment:'#MapArea', 
        helper:'original',
        refreshPositions:false,
        start:function(e, ui){
            // 更新停止
            clearInterval(Timer);
        },
        stop:function(e, ui){
            getDropXY(this);
            // 更新タイマー再開
            clearInterval(Timer);
            Timer = setInterval('getLog()', getdata_on);
        }
    });
}

/* ドロップ：座標記録&書き込み&更新再開 */
function getDropXY(Obj) {
    var x = parseInt($(Obj).offset().left);
    var y = parseInt($(Obj).offset().top);

    // 書き込み
    var unitName = convert($(Obj).text());
    if (!unitName) return false;

    //データ成形
    var params = '';
    var params =
        '?m=drop' //書き込みモード
        +'&un='+convert(unitName) //ユニット名
        +'&x='+x //x座標
        +'&y='+y //y座標
        +'&e='+(new Date()).getTime();//cacheの更新
    writeLog(params, "drop");
}


/* 更新関連 */
/* ログ取得 */
function getLog(){
    var log = logfile+'?e='+dateD;
    $.ajax({
        type: "GET",
        ifModified: true,
        url: log,
        success:function(data) {
            // 削除前処理
            var updateUnitIds = new Array();
            var nowUnits = $(".unit").get();

            // ログの成形
            var recent = data.split('\n');
            for(var i=0;i<recent.length; i++){
            // 各行を<>で分割して配列に
                var unit = recent[i].split('<>');
                // 最初の行はマップ情報
                if (i==0) {
                // 準備中
                } else {
                    // ユニットデータがなければ終了
                    if(!unit[0] || unit[0]=='dummy'){
                        break;
                    }
                    // ユニット更新
                    setUnit(unit);
                    if (unit[2]) {
                        updateUnitIds.push(unit[0]+unit[1]);
                    } else {
                        updateUnitIds.push(unit[0]);
                    }
                }
            }
            // ログから消えたユニットの削除
            var delUnitIds = new Array();
            for(i=0;i<nowUnits.length;i++) {
                var id = $(".unit").get(i).id;
                if(id != 'dummydummy' && jQuery.inArray(id, updateUnitIds)=="-1") {
                    delUnitIds.push(id);
                }
            }

            if (delUnitIds[0]) {
                for(i=0;i<delUnitIds.length;i++) {
                    delUnitById(delUnitIds[i]);
                }
            }

        }
    });
}

// ログに書き込み
function writeLog(params, mode)
{
    $.ajax({
        type: "GET",
        url: writescript+params,
        success: function() {
        // 受信完了イベント
            // 更新
            if (mode != 'drop' && mode != 'out' && mode != 'in') {
                getLog();
            }
        }
    });
}

/* リフレッシュ */
function clearLog(){
    var log = logfile+'?e='+dateD;
    $.ajax({
        type: "GET",
        ifModified: false,
        url: log,
        success: function(data){
            // ログの成形
            var recent = data.split('\n');
            for(var i=0;i<recent.length; i++){
            // 各行を<>で分割して配列に
                var unit = recent[i].split('<>');
                // 最初の行はマップ情報
                if (i==0) {
                // 準備中
                } else {
                    // ユニットデータがなければ終了
                    if(!unit[0]){
                        break;
                    }
                    setUnit(unit);
                }
            }
        }
    });
}


/* マップ */
/* マップ変更 */
function changeMap(mapWidth, mapHeight, mapColor, mapImgFile, mapImgNoRepeat){
    mapElm = $("#MapArea");
    // サイズ変更
    if (parseInt(mapWidth) && parseInt(mapHeight)) {
        mapElm.width(parseInt(mapWidth));
        mapElm.height(parseInt(mapHeight));
    } else {
        alert("マップサイズを正しく指定してください");
        return false;
    }

    // 背景変更
    mapElm.css("background-color", "#"+setHexColorCode(mapColor));
    if (mapImgFile) {
        mapElm.css("background-image", "url("+mapImgFile+")");
        if (!mapImgNoRepeat) {
            mapElm.css("background-repeat", "no-repeat");
        } else {
            mapElm.css("background-repeat", "repeat");
        }
    }

    // D&D領域設定
    var optDropzone = {
        tolerance: 'intersect', // pointer,fit
        accept: '.unit',
        drop: function(e, ui) {
            alert("Drop");
//            alert(ui.draggable.left());
        }
    }

}
