<?php
/*
 * Ajax Chat for TRPG ver.2.3
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * 入力内容をダイス変換
 */
function convert_dice($string) {
    // 基本ダイス変換
    if (preg_match("/(.*)[[]([0-9]{1,})([dD])([0-9]{1,})([-\+\*\/\s]{0,}[0-9-\+\*\/\s]{0,})[@]{0,}([cC]{0,1}[rR]{0,1}[0-9\-]{0,})([fF]{0,1}[zZ]{0,1}[0-9\-]{0,})[\]]([\/\*]{0,1}[0-9]{0,})(.*$)/i", $string, $dice)) {
        $dice_result = dice_convert($dice[2], $dice[4], $dice[5], $dice[6], $dice[7], $dice[8]);
        $string = $dice[1].$dice_result.$dice[9];
    }
    // 市販ルール対応
    // ＳＷレーティング振り
    elseif (USE_CONSUMER_RULES) {
        if(preg_match("/(.*)[[]([0-9]{0,})([rRlL])([0-9]{1,})([-\+\*\/\s]{0,}[0-9-\+\*\/\s]{0,})[\]](.*$)/i", $string, $rating)) {
            $dice_result = dice_convert($rating[2], $rating[4], $rating[5], "", "", "", $rating[3]);
            $string = $rating[1].$dice_result.$rating[6];
        }
    }

    return $string;
}


/**************
 * ダイス
 **************/

/*
 * ダイス計算
 */
function dice_convert($dicenum, $dicenumber, $revision, $c, $f, $finalcal, $dice_type = "d") {
    $dice_hidden = false;

    $revision = preg_replace("/\s/","+",$revision);

    // 返り値用：元のダイス
    $dice = "[".$dicenum.$dice_type.$dicenumber.$revision;
    if ($dice_type == "d") {
        if ($c || $f) {
            $dice .= "@".$c. $f;
        }
    }
    $dice .= "]";
    $row_dice = $dice;
    $dice .= $finalcal;

    // 市販ルール用ダイス置換
    if (DICE_MAX && USE_CONSUMER_RULES) {
        require_once './lib/consumer_rule.php';

        // 「ダイス変換はブラックボックス」ルールの場合
        // 改修の際は厳守してください
        if ($dice_type == "r") {
            $dice_hidden = true;
        }
 
        // SW
        if ($dice_type == "r") {
            $rating = intval($dicenumber);
            if (!is_int($rating) || $rating < 0 || $rating > 50) {
                return $dice.'<font style="color:#'.MAIN_TEXTCOLOR.';">(レーティングは0～50の範囲で指定してください)</font>';
                }
            if ($dicenum) $c = "cr".$dicenum."-";
            $f = "fz2";
            $dicenum = 2;
            $dicenumber = 6;
        }
    }

    // ダイスを振る
    $rolling = "";
    $total_sum = 0;
    $value = 0;
    $roll = array();

    for ($i=0;$i<10;$i++) {
        list($roll[$i]['dice_sum'], $roll[$i]['dice_list'], $roll[$i]['d_result'], $error) = dice_main($dicenum, $dicenumber, $revision);
        if ($error) {
            return $dice.'<font style="color:#'.MAIN_TEXTCOLOR.';">'.$error.'</font>';
        }

        // クリティカル・ファンブルの判定
        if ($c || $f) {
            list($roll[$i]['flg_c'], $roll[$i]['flg_f']) = cf_check($roll[$i]['dice_sum'], $c, $f);
        }

        // ファンブルは0点の場合
        if (preg_match("/^[fF][zZ]([0-9]{1,})([\-]{0,})$/i", $f)) {
            define(F_ZERO, true);
        } else {
            define(F_ZERO, false);
        }
        if (F_ZERO && $roll[$i]['flg_f']) {
            $roll[$i]['dice_sum'] = 0;
        }

        // 市販ルール対対応：ダイス合計値計算
        if (DICE_MAX && USE_CONSUMER_RULES) {
            $roll[$i]['dice_sum_disp'] = $roll[$i]['dice_sum'];

            if ($dice_hidden) {
                $roll[$i]['dice_sum_disp'] = null;
            }

            // SW
            if ($dice_type == "r") {
                $roll[$i]['dice_sum'] = convert_sw_rating($rating, $roll[$i]['dice_sum']);
            }
        }

        // ダイス出力準備(1)
        $rolling .= $roll[$i]['dice_list'] ." ";
        if ($dice_hidden == false) {
            $rolling .= "= ".$roll[$i]['dice_sum'];
        } elseif ($dice_type == "r") {
            $rolling .= "= " . array_sum($roll[$i]['d_result']);
        }
        $total_sum += $roll[$i]['dice_sum'];

        // クリティカルで振り足す
        if (preg_match("/^[cC][rR]([0-9]{1,})([\-]{0,})$/i", $c)) {
            if ($roll[$i]['flg_c']) {
                if ($i != 9) {
                    $rolling .= " ". C_ROLLING_MSG." ";
                // サーバの安全のため、規定数以上は手動振り足し [回数の基準はブックですw]
                } else {
                    $rolling .= "***もう一回".$row_dice."を振り足してください***";
                }
            } else {
                break;
            }
        // 振り足さない場合ループを抜ける
        } else {
            break;
        }
    }

    // 修正値を加える
    // ファンブルは0点で1回目のダイスがファンブルの場合は修正値も入らない
    if($revision && (!F_ZERO || !$roll[0]['flg_f'])) {
        list($value, $error) = calc_value($total_sum, $revision);
    } else {
        $value = $total_sum;
    }
    if ($error) {
        return $dice.'<font style="color:#'.MAIN_TEXTCOLOR.';">'.$error.'</font>';
    }

    // 最終値の乗除算
    if ($finalcal) {
        if (preg_match("/^(\*)([0-9]{1,})$/", $finalcal, $finalmalti)) {
            $value = $value * $finalmalti[2];
        } elseif (preg_match("/^\/([0-9]+)$/", $finalcal, $finaldev)) {
            if ($finaldev[1] != 0) {
                $value = $value / $finaldev[1];
            } else {
                return $dice."(0では割れません)";
            }
        } else {
            return $dice.'<font style="color:#'.MAIN_TEXTCOLOR.';">'."(最終乗除算の設定が不正です)</font>";
        }
    }

    // ダイス出力準備(2)
    $dice .= " = ";
    if ($finalcal) $dice = $dice."[";
    $dice .= $rolling;
    if (count($roll) > 1 || $dice_type == 'r') {
        $dice .= " →";
        if (!$dice_hidden) {
            $dice .= " ". $total_sum;
        }
    }
    if($revision) {
        if (F_ZERO && $roll[0]['flg_f']) {
            $revision = "<s>".$revision."</s>";
        }
        $dice .= " ".$revision;
    }
    if ($finalcal) $dice .= "]".$finalcal;
    $dice .= " = ".round($value, 1).'</span> ';

    $dice = '; font-weight: bold;">'.$dice;
    // クリティカル・ファンブルの場合強調色
    // 回ってファンブルで止まった場合はクリティカル扱い
    if ($roll[0]['flg_c']) {
        $dice = ' <span style="color:#'.C_COLOR. $dice;
    } elseif ($roll[0]['flg_f']) {
        $dice = ' <span style="color:#'.F_COLOR. $dice;
    } else {
        $dice = ' <span style="color:#'.DICE_COLOR. $dice;
    }

    return $dice;
}

/*
 * ダイス本体
 */
function dice_main($dicenum, $dicenumber, $revision) {
    if ((int)DICE_MAX > 1000) {
        $error = ' (ダイス数最大数の設定が誤っています。1000個以下にしてください)]';
    } elseif($dicenum >= 1 && $dicenum <= (int)DICE_MAX) {
        if ($dicenumber >= 2 && $dicenumber <= 100) {
            mt_srand((double) microtime() * 1000000);
            $dicesum = 0;
            for ($i=0; $i<$dicenum; $i++) {
                $d_result[$i] = mt_rand(1,$dicenumber);
                $dice_sum += $d_result[$i];
                if ($i != 0) {
                    $dice_list .= ", ".$d_result[$i];
                } else {
                    $dice_list = "(".$d_result[$i];
                }
            }
            $dice_list .= ")";
        } else {
            $error = ' (d2～d100の範囲で指定してください)]';
        }
    } else {
        $error = ' (ダイスの数は1から'.DICE_MAX.'の間で指定してください)';
    }
    return array($dice_sum, $dice_list, $d_result, $error);
}

/*
 * ダイス修正値の計算
 */
function calc_value($dice_sum, $revision) {
    $multi = preg_match("/\*/", $revision);
    $dev = preg_match("/\//", $revision);
    $add = preg_match("/\+/", $revision);
    $subtract = preg_match("/\-/", $revision);

    // +-*/で分割
    $revision = preg_replace("/\+/","<>+<>",$revision);
    $revision = preg_replace("/\-/","<>-<>",$revision);
    $revision = preg_replace("/\*/","<>*<>",$revision);
    $revision = preg_replace("/\//","<>/<>",$revision);
    $parts = explode("<>",$revision);
    array_splice($parts, 0, 1, $dice_sum);

    // 乗算&除算
    if ($multi || $dev) {
        foreach ($parts as $k => $v) {
            if ($v != '0' && $v == '*') {
                if (!preg_match("/[0-9]{1,}/", $parts[$k+1])) $error = "演算子が連続してます";
                $flg = $k;
                array_splice($parts, $k+1, 1, $parts[$k-1] * $parts[$k+1]);
                array_splice($parts, $k-1, 1, 0);
                array_splice($parts, $k, 1, $parts[$k-2]);
                array_splice($parts, $k-2, 1, '+');
            }
            if ($v != '0' && $v == '/') {
                if (!preg_match("/[0-9]{1,}/", $parts[$k+1])) $error = "演算子が連続してます";
                array_splice($parts, $k+1, 1, $parts[$k-1] / $parts[$k+1]);
                array_splice($parts, $k-1, 1, 0);
                array_splice($parts, $k, 1, $parts[$k-2]);
                array_splice($parts, $k-2, 1, '+');
            }
        }
    }

    // 加減算
        foreach ($parts as $k => $v){
            if ($v != '0') {
                if ($v == '+') {
                    if (!preg_match("/[0-9]{1,}/", $parts[$k+1]))  $error = "演算子が連続してます";
                    array_splice($parts, 0, 1, $parts[0] + $parts[$k+1]);
                } elseif ($v == '-') {
                    if (!preg_match("/[0-9]{1,}/", $parts[$k+1]))  $error = "演算子が連続してます";
                    array_splice($parts, 0, 1, $parts[0] - $parts[$k+1]);
                }
            }
        }

    return array($parts[0], $error);
}

/*
 * クリティカル･ファンブルの検出
 */
function cf_check($dice_sum, $c, $f) {
    if ($c || $f) {
        if ($c && preg_match("/^[cCrR]{1,2}([0-9]{1,})([\-]{0,})$/i", $c, $clit)) {
            if ($clit[2] && $dice_sum >= $clit[1]) {
                $flg_c = true;
            } elseif (!$clit[2] && $dice_sum == $clit[1]) {
                $flg_c = true;
            } else {
                $flg_c = false;
            }
        }
        if ($f && preg_match("/^[fF][zZ]{0,1}([0-9]{1,})([\-]{0,})$/i", $f, $famble)) {
            if ($famble[2] && $dice_sum <= $famble[1]) {
                $flg_f = true;
            } elseif (!$famble[2] && $dice_sum == $famble[1]) {
                $flg_f = true;
            } else {
                $flg_f = false;
            }
        }
    }
    return array($flg_c, $flg_f);
}

?>