<?php
/*
 * Ajax Chat for TRPG ver.2.2
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*****************
 *  JaveScriptライブラリ：チャット画面
 *****************/

?>

<script type="text/javascript">
<!--

//変数の設定
var dateD = (new Date()).getTime();
var statusColor = '<?php print STATUS_COLOR; ?>';
var logfile= '<?php print RECENT_LOG;?>';

// ログ取得
function getLog(){
    var log = logfile+'?e='+dateD;
    $.ajax({
        type: "<?php print METHOD; ?>",
        ifModified: true,
        url: log,
        success: function(data){
        // 最新行番号の取得
        if (!isNaN(document.getElementById('id'))) {
            last_id = 0;
        } else {
            last_id = document.getElementById('id').firstChild.nodeValue;
        }

        // ログの成形
        var recent = data.split('\n');

        var text = new Array();
        for(var i=0;i<recent.length; i++){

        // 各行を<>で分割して配列に
            var unit = recent[i].split('<>');

        // データがなければ終了
            // last_idで終点判断
            if(unit[0] && last_id < unit[0]){
                    text[i] = setData(unit);
            } else {
                break;
            }
        }

        var text_rev = text.reverse();

        for(var i=0;i<text_rev.length; i++){
        //出力
            $("#main_console").after(text_rev[i]);

            // ログを「流す」
            if (deleteLastPastLog != '0' && document.getElementById("chatwindow").childNodes.length > maxNum) {
                document.getElementById("chatwindow").removeChild(document.getElementById("chatwindow").lastChild);
            }
        }
    }
    });
    // 在室表示
    showMember();
}

// 在室表示
function showMember() {
    $.ajax({
        type: "<?php print METHOD; ?>",
        ifModified: true,
        url: now_member,
        success: function(data2){
        // ログの成形
            var member = data2.split('\n');
            var text2 = "";
            var unit2 = new Array();
            for(var i=0;i<member.length; i++){
                var unit2 = member[i].split('<>');
                 // データがなければ終了
                if(!unit2[0]){
                    break;
                }

                var mname = unit2[0];
                var mpwd = unit2[1];
                if (obfuscateLog == '1') {
                    mname = deObfLog(mname);
                    mpwd = deObfLog(mpwd);
                }

                var text2 = text2+'<span id="'+mname+'" class="member" onclick="inputWhisper(\''+mname+'\',\''+mpwd+'\');">'+mname+'</span>'+'<>';
                // my_hashに自分のハッシュ登録
                if (!$(window.parent.document.getElementById("my_hash")).attr("value") && $(window.parent.document.getElementById("pwd_on")).attr("value") && $(window.parent.document.getElementById("name_on")).attr("value")==mname) {
                    window.parent.document.getElementById("my_hash").value = mpwd;
                }
            }
    // 出力
            if (text2) {
                $("#indi").html(text2);
            }
        }
    });
}

// ログイン・ログオフ
function login() {
    Timer = setInterval('getLog()', getdata_on);
<?php 
if (OFFWINDOW_MSG || (UNPUBLIC_LAST_PASTLOG && NO_LAST_PASTLOG_MSG)) {
    print '    window.parent.document.getElementById("offline_win").style.display = "none";'."\n";
}
?>
    fontSizeChange("0");
    lineSpaceChange("0");
}
function logout() {
    clearInterval(Timer);
    Timer = setInterval('getLog()', getdata_off);
    if (userWhisper) {
        window.parent.document.getElementById("whisper_mark").src="<?php print WHISPER_OFF_ICON; ?>"
    }
<?php 
if (OFFWINDOW_MSG || (UNPUBLIC_LAST_PASTLOG && NO_LAST_PASTLOG_MSG)) {
    print '    window.parent.document.getElementById("offline_win").style.display = "";';
}
?>
    window.location.reload();
}

// リフレッシュ
function clearLog(){
    var log = logfile+'?e='+(new Date()).getTime();
    $(".row").remove();
    $.ajax({
        type: "<?php print METHOD; ?>",
        ifModified: false,
        url: log,
        success: function(data){
            var recent = data.split('\n');
            var text = new Array();
            for(var i=0;i<recent.length; i++){
                var unit = recent[i].split('<>');
                if (deleteLastPastLog && i >= maxNum) {
                    break;
                }
                if (unit[0] && unit[2] && unit[4]) {
                    text[i] = setData(unit);
                }
            }
            var text_rev = text.reverse();
            for(var i=0;i<text_rev.length; i++){
            // 出力
                if(text_rev[i]){
                    $("#main_console").after(text_rev[i]);
                }
            }
            fontSizeChange("0");
            lineSpaceChange("0");
        }
    });
}

// ささやき指定
function inputWhisper(name, whisperTo) {
    if (!userWhisper) {
        return false;
    }
    var flag = whisperTo ? true : false;
    if (flag==false){
        alert(name+"さんは入室パスワード未入力のため、「ささやき」はできません。");
    } else if (!window.parent.document.getElementById("pwd_on").value){
        alert("パスワードを入力しないと「ささやき」はできません。");
    } else if (name=='全員'){
        alert("「全員」という名前の方に「ささやき」はできません(笑)");
    } else {
        window.parent.document.getElementById("whisper_to").value = name;
        window.parent.document.getElementById("whisper_to_hash").value = whisperTo;
        window.parent.document.getElementById("whisper_mark").src="<?php print WHISPER_OFF_ICON; ?>"
    }
}

// ログ行成形
function setData(unit) {

    if (!unit[0] || !unit[2] || !unit[4]) {
        return false;
    }
    //行番号：最新行
    var last_id_tag = '<span id="id" style="display:none;">'+unit[0]+'</span>';
    //データの成形
    var name = unit[1];
    var pc = unit[2];
    var color = unit[3];
    var com = unit[4];
    var d = new Date();
    d.setTime(unit[5]*1000);
    var year = d.getYear();
    if (year < 2000) { year += 1900;}
    var month = d.getMonth()+1;
    if (month < 10) { month = "0" + month;}
    var day = d.getDate();
    if (day < 10) { day = "0" + day;}
    var hour = d.getHours();
    if (hour < 10) { hour = "0" + hour;}
    var min = d.getMinutes();
    if (min < 10) { min = "0" + min;}
    var sec = d.getSeconds();
    if (sec < 10) { sec = "0" + sec;}
    var datetime = year+'/'+month+'/'+day+' '+hour+':'+min+':'+sec;
    var whisper = 'n';
    if(unit[9] || unit[10]) {
        var whisper = 'y';
        if ($(window.parent.document.getElementById("my_hash")).attr("value") == unit[8]) whisper = 'to';
        if ($(window.parent.document.getElementById("my_hash")).attr("value") == unit[10]) var whisper = 'from'
    }
    var whisperFrom = unit[9];
    if(unit[11] == '1' && unit[12]) {
        var status = unit[12];
    }

    if (obfuscateLog=='1') {
        name = deObfLog(name);
        pc = deObfLog(pc);
        com = deObfLog(com);
        if (whisperFrom) whisperFrom = deObfLog(whisperFrom);
        if (status) status = deObfLog(status);
    }

    // 行の成形
    if (unit[0]!='0' && whisper!='y') {
        row = '<div class="row">';
        row += last_id_tag+'<span style="font-weight:bold; color:'+color+';" id="'+deObfLog(unit[0])+'" title="'+name+'">【'+pc+'】</span>'+
        '<span title="'+datetime+'">：';
        if (whisper=='to' || whisper=='from') {
            row += '<span style="color:'+color_system+';">(';
            if (whisper=='to') row += whisperFrom+'さんへ';
            if (whisper=='from') row += pc+'さんから';
            row += 'のささやき) </span>';

        }
        row += com+'</span>';
        if (status) {
            row += ' <span style="color:#'+statusColor+';">('+status+')</span>';
        }
        // 改行
        row += '<hr class="break" style="height:0px; border-style:dotted; margin-top:'+document.getElementById("linespace").value+'px; margin-bottom:'+document.getElementById("linespace").value+'px;';
        if (!document.getElementById("hr").checked) {
            row += " visibility: hidden;";
        }
        row += '" /></div>';
    } else {
        var row = last_id_tag;
    }
    return row;
}

// チャット画面文字サイズ変更
function fontSizeChange(size) {
    // 現在の文字サイズ
    var nowFontSize = parseInt(document.getElementById("fontsize").value);
    // 変更後の文字サイズ
    var changedFontSize = nowFontSize + parseInt(size);
    if (changedFontSize < 8 || changedFontSize > 24) {
        alert("これ以上変更できません");
        return false;
    }

    document.getElementById("fontsize").value = changedFontSize;
    $(".chatwindow").css("font-size", changedFontSize+"px");
}

// チャット画面行間隔変更
function lineSpaceChange(size) {
    // 現在の行間隔
    var nowSpace = parseInt(document.getElementById("linespace").value);
    // 変更後の行間隔
    var changedSpace = nowSpace+size/2;
    if (changedSpace < 0 || changedSpace > 48) {
        alert("これ以上変更できません");
        return false;
    }

    document.getElementById("linespace").value = changedSpace;
    $(".break").css("margin-top", changedSpace+"px");
    $(".break").css("margin-bottom", changedSpace+"px");
}

// 発言間にラインON/OFF
function lineSpaceHrToggle() {
    // ON
    if (!document.getElementById("hr").checked) {
        $(".break").css("visibility", "visible");
        document.getElementById("hr").checked = true;
    // OFF
    } else {
        $(".break").css("visibility", "hidden");
        document.getElementById("hr").checked = false;
    }
}
-->
</script>