<?php
/*
 * Ajax Chat for TRPG ver.2.1
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません');
    exit;
}

// パスワードの照合
auth();

// 設定セット
set_config(read_config());

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// 画面表示：HTML出力
print html_header(CHAT_TITLE.' 過去ログ管理画面', 'admin', false, true);

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';

?>
</head>
<body>
<h2 align="center"><?php print CHAT_TITLE; ?> 過去ログ管理画面</h2>

<?php
if ($request['msg']) print '<p class="msg">'.$request['msg'].'</p>';
?>

<table cellspacing="0" align="center" border="1" bordercolor="#000000">
<tr><td colspan="2">
<div style="color:blue;" align="center"><b>過去ログ作成</b></div>
<form action="./pastlog_create.php" method="<?php print METHOD; ?>" name="write_log">
<table align="center" border="0">
<tr>
<td><input type="checkbox" name="datetime" value="1">
発言時間表示</td>
<td><input type="checkbox" name="whisper" value="1">ささやき全表示</td>
<td><input checked type="checkbox" name="delete" value="1">ログ削除</td>
</tr>
<tr><td colspan="3" align="center">ログファイル名：<input name="filename" type="text" value="<?php print date('Ymd'); ?>" size="10" maxlength="30" style="ime-mode:disabled;">.html　<input type="submit" value="過去ログ作成"></td></tr>
</table></form>
<span align="left">「ささやき全表示」：指定すると公開ログにも全ての「ささやき」が表示されます。<br>
「ログ削除」：過去ログ作成と同時に、現在のログを全て削除します。<br></span>
<hr>
<div style="color:blue;" align="center"><b>ディレクトリ編集</b></div>
<form action="./admin.php" method="<?php print METHOD; ?>" name="mkdir">
<input name="mode" type="hidden" value="mkdir">
<table align="center" border="0">
<tr><td align="center">ディレクトリ名：<input name="dirname" type="text" value="<?php print date('Ym'); ?>" size="10" maxlength="30" style="ime-mode:disabled;">　<input type="submit" value="新規作成"></form></td></tr>
</table>
<form action="./admin.php" method="<?php print METHOD; ?>" name="mvdir">
<input name="mode" type="hidden" value="mvdir">
<table align="center" border="0">
<tr>
<td align="center" nowrap>元のディレクトリ名：<input name="dirname_old" type="text" value="" size="10" maxlength="30" style="ime-mode:disabled;"></td>
<td nowrap>変更後ディレクトリ名：<input name="dirname_new" type="text" value="" size="10" maxlength="30" style="ime-mode:disabled;">　<input type="submit" value="変更"></form></td></tr>
</table>
<form action="./admin.php" method="<?php print METHOD; ?>" name="rmdir">
<input name="mode" type="hidden" value="rmdir">
<table align="center" border="0">
<tr><td align="center">ディレクトリ名：<input name="dirname" type="text" value="" size="10" maxlength="30" style="ime-mode:disabled;">　<input type="submit" value="削除"></form></td></tr>
</table>
<span align="left">過去ログ整理用ディレクトリを作成します。<br>
ディレクトリ階層は、１階層のみ有効です。<br>
過去ログファイルがあるディレクトリは削除できません。</span>

</td></tr>

<tr>
<td valign="top" width="50%">
<h4>公開過去ログ</h4>

<?php
print_pastlog_contents_list(PAST_DIR, 'root', 'ASC', true, './pastlog_edit_file.php');
?>
</td>
<td valign="top" width="50%">
<h4>管理用過去ログ(非公開)</h4>

<?php
print_pastlog_contents_list(MASTER_PAST_DIR, 'root_past', 'ASC', true, './pastlog_edit_file.php');
?>

<h5>管理用過去ログには、全ての発言時間・ささやき・参加者のホスト情報が記録されます</h5>

</td>
</tr>
</table>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">過去ログ管理機能は、JavaScript不可の環境では使用できません。</p>
</noscript>

<?php
// フッター
print html_footer();


?>