<?php
/*
 * Ajax Chat for TRPG ver.2.0
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */
?>

<script type="text/javascript">
<!--

// ログ取得
function getLog(){
    $.ajax({
        type: "<?php print METHOD; ?>",
        ifModified: true,
        url: logfile,
        success: function(data){
    // 最新行番号の取得
    if (!isNaN(document.getElementById('id'))) {
        last_id = 0;
    } else {
        last_id = document.getElementById('id').firstChild.nodeValue;
    }

    // ログの成形
        var recent = data.split('\n');

        var text = new Array();
        for(var i=0;i<recent.length; i++){
        // 各行を<>で分割して配列に
            var unit = recent[i].split('<>');

        // データがなければ終了
            // last_idで終点判断
            if(unit[0] && last_id < unit[0]){
                    text[i] = setData(unit);
            } else {
                break;
            }
        }

        var text_rev = text.reverse();

        for(var i=0;i<text_rev.length; i++){
        //出力
            $("#main_console").after(text_rev[i]);
        }
    }
    });
    // 在室表示
    showMember();
}

// 在室表示
function showMember() {
    $.ajax({
        type: "<?php print METHOD; ?>",
        ifModified: true,
        url: now_member,
        success: function(data2){
        // ログの成形
            var member = data2.split('\n');
            var text2 = "";
            var unit2 = new Array();
            for(var i=0;i<member.length; i++){
                var unit2 = member[i].split('<>');
        // データがなければ終了
                if(!unit2[0]){
                    break;
                }
                var text2 = text2+'<span id="'+unit2[0]+'" class="member" onclick="inputWhisper(\''+unit2[0]+'\',\''+unit2[1]+'\')">'+unit2[0]+'</span>'+'<>';
                // my_hashに自分のハッシュ登録
                if (!$(window.parent.document.getElementById("my_hash")).attr("value") && $(window.parent.document.getElementById("pwd_on")).attr("value") && $(window.parent.document.getElementById("name_on")).attr("value")==unit2[0]) {
                    window.parent.document.getElementById("my_hash").value = unit2[1];
                }
            }
    // 出力
            if (text2) {
                $("#indi").html(text2);
            }
        }
    });
}

// ログイン・ログオフ
function login() {
    clearInterval(Timer);
    Timer = setInterval('getLog()', getdata_on);
    $("#help").hide();
    clearLog();
}
function logout() {
    clearInterval(Timer);
    Timer = setInterval('getLog()', getdata_off);
    window.parent.document.getElementById("whisper_mark").src="<?php print WHISPER_OFF_ICON; ?>"
    window.location.reload();
}

// リフレッシュ
function clearLog(){
    $.ajax({
        type: "<?php print METHOD; ?>",
        ifModified: false,
        url: logfile,
        success: function(data){
        var recent = data.split('\n');
        var text = new Array();
        $(".com_row").remove();
        for(var i=0;i<recent.length; i++){
            var unit = recent[i].split('<>');
            if (unit[0]) {
                text[i] = setData(unit);
            }
        }
        var text_rev = text.reverse();
        for(var i=0;i<text_rev.length; i++){
        //出力
            if(text_rev[i]){
                $("#main_console").after(text_rev[i]);
            }
        }
    }
    });
}

// ささやき指定
function inputWhisper(name, whisperTo) {
    var flag = whisperTo ? true : false;
    if (flag==false){
        alert(name+"さんは入室パスワード未入力のため、「ささやき」はできません。");
    } else if (!window.parent.document.getElementById("pwd_on").value){
        alert("パスワードを入力しないと「ささやき」はできません。");
    } else if (name=='全員'){
        alert("「全員」という名前の方に「ささやき」はできません(笑)");
    } else {
        window.parent.document.getElementById("whisper_to").value = name;
        window.parent.document.getElementById("whisper_to_hash").value = whisperTo;
        window.parent.document.getElementById("whisper_mark").src="<?php print WHISPER_OFF_ICON; ?>"
    }
}

// ログ行成形
function setData(unit) {
    if (!unit) {
        return false;
    }
    //行番号：最新行
    var last_id_tag = '<span id="id" style="display:none;">'+unit[0]+'</span>';
    //データの成形
    var name = unit[1];
    var pc = unit[2];
    var color = unit[3];
    var com = unit[4];
    var d = new Date();
    d.setTime(unit[5]*1000);
    var year = d.getYear();
    if (year < 2000) { year += 1900;}
    var month = d.getMonth()+1;
    if (month < 10) { month = "0" + month;}
    var day = d.getDate();
    if (day < 10) { day = "0" + day;}
    var hour = d.getHours();
    if (hour < 10) { hour = "0" + hour;}
    var min = d.getMinutes();
    if (min < 10) { min = "0" + min;}
    var sec = d.getSeconds();
    if (sec < 10) { sec = "0" + sec;}
    var datetime = year+'/'+month+'/'+day+' '+hour+':'+min+':'+sec;
    var whisper = 'n';
    if(unit[9] || unit[10]) {
        var whisper = 'y';
        if ($(window.parent.document.getElementById("my_hash")).attr("value") == unit[8]) whisper = 'to';
        if ($(window.parent.document.getElementById("my_hash")).attr("value") == unit[10]) var whisper = 'from'
    }
    if(unit[11] == '1' && unit[12]) {
        var status = unit[12];
    }

    // 行の成形
    if (unit[0]!='0' && whisper!='y') {
        row = '<div>';

        row += last_id_tag+'<span style="font-weight:bold; color:'+color+';" id="'+unit[0]+'" title="'+name+'">【'+pc+'】</span>：'+
        '<span class="body" title="'+datetime+'">';
        if (whisper=='to' || whisper=='from') {
            row = row+'<span style="color:'+color_system+';">(';
            if (whisper=='to') row = row+unit[9]+'さんへ';
            if (whisper=='from') row = row+unit[2]+'さんから';
            row = row+'のささやき) </span>';

        }
        row = row+com+'</span>';
        if (status) {
            row = row+' <span style="color:'+status_color+';">('+status+')</span>';
        }
        row = row+'</div>';
    } else {
        row = last_id_tag;
    }
    return row;
}

// チャット画面文字サイズ変更
function fontSizeChange(size) {
    // 現在の文字サイズ
    var nowFontSize = $(".chatwindow").css("font-size");
    // 変更後の文字サイズ
    var changedFontSize = parseInt(nowFontSize) + parseInt(size);
    if (changedFontSize <= 0 || changedFontSize > 36) {
        alert("これ以上変更できません");
        return false;
    }
    $(".chatwindow").css("font-size", changedFontSize+"px");
    $(".com_row").css("font-size", changedFontSize+"px");
}

// チャット画面行間隔変更
function lineSpaceChange(size) {
    // 現在の行間隔
    var nowSpace = $(".chatwindow").css("line-height");
    // 現在の文字サイズ
    var nowFontSize = $(".chatwindow").css("font-size");
    // 変更後の行間隔
    var changedSpace = parseInt(nowSpace) + parseInt(size);
    if (changedSpace <= parseInt(nowFontSize)*0.5 || changedSpace > parseInt(nowFontSize)*3) {
        alert("これ以上変更できません");
        return false;
    }

    $(".chatwindow").css("line-height", changedSpace+"px");
    $(".com_row").css("line-height", changedSpace+"px");
}

-->
</script>