<?php
/*
 * Ajax Chat for TRPG ver.1.1
 * (c)2007 Cake All righ1ts reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 *
 * [注意事項他]
 * 本チャットスクリプトの使用および配布は、BSDライセンスに基づきます。
 * BSDライセンスの詳細につきましては、添付のライセンス.txtを参照してください。
 *
 * BSDライセンス概要＆使用上の注意
 * 1. このスクリプトはフリーソフトです。以下の条件を満たす限りにおいて、使用・改造・再配布（オリジナルおよび改造版の両方とも）は自由です。
 * 再配布する場合、上記著作権表示、本条件書きおよび第2項・第3項の責任限定規定を必ず含めてください。
 * 2. 同梱のアイコンはPetite Prier様(http://snow.if.tv/)の素材です。
      本スクリプトの使用および再配布時にアイコンをそのまま用いる場合は、配布元の規定も遵守してください。
 * 3. 本スクリプトは無保証です。自己責任で使用してください。このスクリプトを使用したいかなる損害に対しても、作者は一切の責任を負いません。
 * 4. 設置および使用方法に関する質問は、配布サイトの掲示板にお願いします。ただし、必ず回答できるとは限りません。
 * メールによる質問は、ご遠慮ください。
 */

// 設定ファイルの読み込み
require_once 'trpgchat-ini.php';

//カラーコード作成
$color_list = array();
foreach ($color_code as $k1 => $v1) {
    foreach ($color_code as $v2) {
        foreach ($color_code as $v3) {
            $color_list[] = $v1.$v2.$v3;
        }
    }
}
array_unique($color_list);
sort($color_list);

// HTML出力
print html_header('index', $title, true, true);
 ?>

<script type="text/javascript">
<!--

//変数の設定
var getdata_on = <?php print $getdata_on; ?>*1000;
var getdata_off = <?php print $getdata_off; ?>*1000;
var noname = '<?php print $noname; ?>';
var writescript = '<?php print $writescript; ?>';
var now_member = '<?php print $now_member; ?>';
var pc_num = '<?php print $pc_num; ?>';
var pc_show = '<?php print $pc_show; ?>';
var pc_hide = '<?php print $pc_hide; ?>';

    //変換文字
var target = new Array('\.');
var change = new Array('．');

// 起動時の処理
$(function(){
    //表示系
        // ウィンドウサイズに合わせる
    changeSize();//

        // フォームON/OFF
    document.getElementById("name_on").disabled = true;
    document.getElementById("pwd_on").disabled = true;
    document.getElementById("whisper_to").disabled = true;
    $("#online1").hide();
    $("#online2").hide();

    //ログイン
    $("#login").click(function(){

        //入力チェック
        var name = $("#name_off").attr("value");
        if (!name || name == noname) {
            alert("お名前を入力してください。");
            return false;
        }
        //現在の入室者と同じ名前ではログインできない
        if (isMember(name)==true) {
            alert("現在の参加者と同じ名前ではログインできません。");
            return false;
        }

        //データ整形
        var params =
            '?n='+convert(name)//名前
            +'&s='+'0';//状態表示
        if($("#pwd_off").attr("value")) {
            var pwd = $("#pwd_off").attr("value");
            if(pwd) {
                var params =
                params+'&p='+convert(pwd);//PWD
            }
        } else {
            var pwd = "";
        }
        var params =
            params+'&y=in'
            +'&e='+(new Date()).getTime();//cacheの更新

        writeComment(params);

        //フォームチェンジ
        $("#online1").show();
        $("#online2").show();
        $("#offline").hide();
        document.getElementById("name_on").value = name;
        document.getElementById("pc_name_0").value = name;
        document.getElementById("pwd_on").value = pwd;
        document.getElementById("pc_input_0").focus();

        // 更新
        window.mainframe.login();
    });


    //ログアウト
    $("#logout").click(function(){

        //データ整形
        var name = convert($("#name_on").attr("value"));
        var params =
            '?n='+name//名前
            +'&s='+'0'//状態表示
        if($("#pwd_on").attr("value")) {
            var params =
            params
            +'&p='+convert($("#pwd_on").attr("value"));//PWD
        }
        var params =
            params+'&y=out'
            +'&e='+(new Date()).getTime();//cacheの更新

        writeComment(params);

        //フォームチェンジ
        $("#online1").hide();
        $("#online2").hide();
        $("#offline").show();
        $(".status_column").hide();
        $(".add_pc").hide();
        $(".show_status").each(function(){
            this.checked = false;
        });
//        for(i=1;i<=pc_num;i++) {
//            document.getElementById("show_status").checked = false;
//        }
        document.getElementById("whisper_to").value = "全員";
        document.getElementById("whisper_to_hash").value = "";
        document.getElementById("pwd_on").value = "";
        document.getElementById("my_hash").value = "";
        document.getElementById("name_off").focus();

        // タイマー更新
        window.mainframe.logout();

    });

});


// 発言
function comment(Obj) {

    // 発言取得
    var pc_input = Obj.pc_input.value;
    if (pc_input) {
        //入力チェック
        var name = convert($("#name_on").attr("value"));
        var pc_name = Obj.pc_name.value;
        if (!pc_name) {
            alert("PC名を入力してください。");
            return false;
        }
        var pc_color = Obj.pc_color.value;

        //データ整形
        var params =
            '?n='+name//名前
            +'&c='+convert(pc_name)//PC
            +'&l='+pc_color//色
            +'&m='+convert(pc_input);//本文

        // ささやき
        var whisper_to_name = $("#whisper_to").attr("value");
        var whisper_to_hash = $("#whisper_to_hash").attr("value");
        if(whisper_to_name && whisper_to_name != '全員' && whisper_to_hash) {
            params = params
                +'&w='+convert(whisper_to_name)//whisperto
                +'&h='+whisper_to_hash;//whisperto_hash
        }

        //状態表示
        if (Obj.show_status.checked) {
            params = params+'&s='+'1';
        } else {
            params = params+'&s='+'0';
        }

        //状態
        if (Obj.status.value) {
            params = params+'&t='+convert(Obj.status.value);
        }

        //他
//        params = params+'&a='+Obj.status.value;

        if ($("#pwd_on").attr("value")) {
            var pwd = convert($("#pwd_on").attr("value"));
        }
        if(pwd) {
            var params =
            params+'&p='+pwd;//PWD
        }
        var params =
            params+'&y=com'
            +'&e='+(new Date()).getTime();//cacheの更新

        writeComment(params);

        //フォームチェンジ
        Obj.pc_input.value = "";
    }
        Obj.pc_input.focus();

        return false;
}


// 書き込み
function writeComment(params)
{
    $.ajax({
        type: "GET",
        url: writescript+params,
        success: function() {
    // 受信完了イベント
            window.mainframe.getLog();
        }
    });
}

//禁止文字置換・エンコード
function convert(C) {
    for (var i=0; i < target.length; i++){
//        C = C.replace(target[i], change[i]);
        C = encodeURIComponent(C);
    }
    return C;
}

// 在室確認
function isMember(name){
    var member = $(window.mainframe.document.getElementById("indi")).text();
    var name_array = member.split('<>');
    for (i=0;i<name_array.length;i++) {
        if (name_array[i] == name) {
            return true;
        }
    }
}

// ダイスボタン
function insertDice(Obj) {
    var dice = $("#dice").attr("value");
    var revision = $("#revision").attr("value");
    if (typeof(revision) != 'string') {
        revision = '0';
    }

    if (revision.match(/[^-0-9+\*\/]/)) {
    alert(revision);
        alert('ダイス修正値は半角数字と+,-,*,/のみで入力してください。');
        return false;
    }

    var input = Obj.pc_input.value;

    if (revision == '0') revision = "";

    if (revision && !revision.match(/^[-+\*\/]/)) {
        revision = '+'+revision;
    }
    Obj.pc_input.value = input+'['+dice+revision+']';
    return false;
}

//セレクトボックスで選んだ画像色を取得
function changeColor (Obj) {
    Obj.style.color = Obj.value;
}

// 状態欄ON/OFF
function toggleStatus(target) {
    dispStatus = document.getElementById(target).style.display;
    if (dispStatus == 'none') {
        document.getElementById(target).style.display = '';
    } else {
        document.getElementById(target).style.display = 'none';
    }
}

// PC欄ON
function showPCcolumn(target) {
    if (document.getElementById(target).style.display == 'none') {
        document.getElementById(target).style.display = '';
    }
}

// PC欄OFF
function hidePCcolumn(target, status) {
    if (document.getElementById(target).style.display != 'none') {
        document.getElementById(target).style.display = 'none';
        if (document.getElementById(status).style.display != 'none') {
            document.getElementById(status).style.display = 'none'
        }
    }
}

// 入室中にリロード・ページ遷移で自動退室
function UnLoad() {
    var name = $("#name_on").attr("value");
    if (name && isMember(name)==true) {
        $("#logout").click();
    }
}

// ウインドウサイズ変更でフォームサイズ変更
function changeSize() {
    var winWidth = document.body.clientWidth;
    var winHeight = document.body.clientHeight - 105;
    $(".input_comment").css({width: winWidth-300});
    $(".status").css({width: winWidth-165});
    $("#mainframe").css({height: winHeight});
}

// ホーム
function returnHome() {
    window.location.href="<?php print $home;?>";
}

//-->
</script>
</head>
<body onresize="changeSize()" onunload="return UnLoad()">
<table border="0" cellspacing="3" cellpadding="0" id="online1" class="online">
<tr>
<td class="nodisplay"><form id="chat_on" name="chat_on" onsubmit="return false;" action="" class="chatform"></td>
<td><input type="text" name="name_on" value="" size="10" class="inputname" id="name_on"></td>
<td><input type="password" name="pwd_on" size="4" class="inputpwd" id="pwd_on">
<input type="hidden" name="my_hash" value="" id="my_hash"></td>
<?php
if ($preset_dice) {
    print '<td align="right">';
    print '<select name="dice" id="dice">'."\n";
    foreach ($preset_dice as $v) {
         print '<option value="'.$v.'">'.$v.'</option>'."\n";
    }
    print '</select></td>'."\n";
    print '<td align="right"> + </td>'."\n";
    print '<td align="right">';
    print '<input type="text" size="6" value="" name="revision" id="revision" />';

    print '</td>'."\n";
}
?>
<td><span id="whisper_to_msg" style="display:inline;"> <img name="whisper" title="クリックで「ささやき」を解除します。" src="<?php print $whisper; ?>" alt="ささやき解除" align="bottom" hspace="1" vspace="0" border="0" onclick='document.getElementById("whisper_to").value="全員", document.getElementById("whisper_to_hash").value="", document.getElementById("whisper_mark").src="<?php print $whisper_off; ?>"'></td>
<td><img id="whisper_mark" title="「ささやき」状態" src="<?php print $whisper_off; ?>" align="bottom" hspace="1" vspace="0" border="0"></span></td>
<td><input type="text" name="whisper_to" value="全員" size="10" class="inputname" id="whisper_to" style="display:inline;">
<input type="hidden" name="whisper_to_hash" value="" id="whisper_to_hash"></td>
<td><input type="image" id="refresh" class="btn sub" src="<?php print $reload_icon; ?>" alt="リフレッシュ" title="リフレッシュ" onclick="window.mainframe.clearLog()"></td>
<td align="right"><input type="button" value="退室" name="logout" class="btn logout" id="logout" /></td>
<td class="nodisplay"></form></td>
</tr>
</table>
<table border="0" cellspacing="3" cellpadding="0" id="online2" class="online">
<tr>
<td class="nodisplay"><form onsubmit="return false;" class="chatform"></td>
<td align="left" nowrap><input type="text" name="pc_name" value="" size="10" class="inputname" id="pc_name_0">
<select name="pc_color" class="color" onChange="changeColor(this)" style="font-weight: bold;">
<?php colorbox($color_list, "pc_color", ""); ?>
</select>
<input type="text" name="pc_input" class="input_comment" id="pc_input_0" size="75%" /></td>
<td><input type="submit" value="発言" class="btn sub" id="submit" style="display:inline" name="submit" onclick="comment(this.form)"></td>
<?php
    if ($dice_max) {
        print '<td>';
        print '<input type="image" id="dice" class="btn sub" src="'.$dice_icon.'" alt="ダイス" title="コメント欄にダイスを追加します。" onclick="insertDice(this.form);">';
        print '</td>'."\n";
    }
?>
<td><input type="image" class="btn sub" src="<?php print $status_icon; ?>" alt="状態" title="ステータス欄をON/OFFします。" onclick="toggleStatus('status_0');"></td>
<?php
if ($pc_num > 1) {
   print '<td><input type="image" id="PC_btn_0" class="btn sub" src="'.$pc_show.'" alt="PC追加" title="PC欄を追加します。" onclick="showPCcolumn(\'pc_1\');"></td><td>&nbsp;</td>';
}
 ?>
</tr>
</table>
<table border="0" cellspacing="3" cellpadding="0" id="status_0" class="status_column" style="display:none;">
<tr>
<td nowrap>ステータス:<input type="text" name="status" class="status" value="<?php print $status; ?>"></td>
<td><input type="checkbox" name="show_status" class="show_status"></td>
<td nowrap> 表示</td>
<td class="nodisplay"></form></td>
</tr>
</table>

<?php
if ($pc_num >= 2) {
    for ($i=1; $i<=$pc_num-1; $i++) {
        print '<table border="0" cellspacing="3" cellpadding="0" id="pc_'.$i.'" class="add_pc" style="display:none;">'."\n";
        print '<tr>'."\n";
        print '<td class="nodisplay"><form onsubmit="return false;" class="chatform"></td>'."\n";
        print '<td align="left" nowrap><input type="text" name="pc_name" value="" size="10" class="inputname">'."\n";
        print '<select name="pc_color" class="color" onChange="changeColor(this)" style="font-weight: bold;">';
colorbox($color_list, "pc_color", "");
        print '</select>'."\n";
        print '<input type="text" name="pc_input" class="input_comment" size="75%" />';
        print '</td>'."\n";
        print '<td><input type="submit" value="発言" class="btn sub" id="submit" style="display:inline" name="submit" onclick="comment(this.form)"></td>'."\n";
        if ($dice_max) {
            print '<td><input type="image" id="dice" class="btn sub" src="'.$dice_icon.'" alt="ダイス" title="コメント欄にダイスを追加します。" onclick="insertDice(this.form);"></td>'."\n";
        }
        print '<td><input type="image" class="btn sub" src="'.$status_icon.'" alt="状態" title="ステータス欄をON/OFFします。" onclick="toggleStatus(\'status_';
        print $i;
        print '\');"></td>'."\n";
        print '<td width="20">';
        if ($i != $pc_num-1) {
            print '<input type="image" id="PC_btn_'.$i.'" class="btn sub" src="'.$pc_show.'" alt="PC欄" title="PC欄を追加します。" onclick="showPCcolumn(\'pc_';
            print $i+1;
            print '\');">';
        } else {
            print " ";
        }
        print '</td>'."\n";
        print '<td><input type="image" id="PC_btn_'.$i.'" class="btn sub" src="'.$pc_hide.'" alt="PC欄" title="PC欄を削除します。" onclick="hidePCcolumn(\'pc_';
        print $i;
            print '\', \'status_';
            print $i;
        print '\');"></td>'."\n";
        print '</tr>'."\n";
        print '</table>'."\n";
        print '<table border="0" cellspacing="3" cellpadding="0" id="status_'.$i.'" class="status_column" style="display:none;">'."\n";
        print '<tr>'."\n";
        print '<td nowrap>ステータス:<input type="text" name="status" class="status" value="'.$status.'"></td>'."\n";
        print '<td><input name="show_status" type="checkbox" class="show_status"></td>'."\n";
        print '<td nowrap> 表示</td>'."\n";
        print '<td class="nodisplay"></form></td>'."\n";
        print '</tr>'."\n";
        print '</table>'."\n";
    }
}
 ?>

<table border="0" cellspacing="3" cellpadding="0" id="offline" style="display:inline;">
<tr>
<td class="nodisplay">
<form id="chat_off" name="chat" onsubmit="return false;" action="" class="chatform">
</td>
<td nowrap>お名前
<input type="text" name="name_off" value="<?php print $noname ?>" size="10" class="inputname" id="name_off">
</td>
<td nowrap>
パスワード<input type="password" name="pwd_off" size="6" class="inputpwd" id="pwd_off">
</td>
<td id="login_btn_area" width="35">
<input type="submit" value="入室" name="login" class="btn login" id="login" />
</td>
<td>
<input type="image" id="reload" class="btn sub" src="<?php print $reload_icon; ?>" alt="リフレッシュ" title="リフレッシュ" onclick="window.mainframe.location.reload()">
</td>
<td class="nodisplay">
</form>
</td>
<td class="nodisplay">
<form action="<?php print $home; ?>">
</td>
<td>
<input type="image" class="btn sub" src="<?php print $home_icon; ?>" value="submit" alt="ホーム" title="ホーム">
</td>
<td class="nodisplay">
</form>
</td>
<td class="nodisplay">
<form action="./pastlog_index.php" method="<?php print $method; ?>" target="pastlog">

</td>
<td>
<input type="submit" value="過去ログ表示">

</td>
<td class="nodisplay">
</form>
</td>
</tr>
</table>

<iframe src="./main.php" width="100%" frameborder="1" border="1" allowtransparency="true" scrolling="auto" name="mainframe" class="mainframe" style="height:500px;" id="mainframe"></iframe>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です</p>
</noscript>

<?php

// フッター
print html_footer($copyright);


//関数
/* 名前色選択リスト生成 */
function colorbox($colorlist, $id, $select=''){
    foreach ($colorlist as $k => $v) {
        print'<option value="'.$v.'" style="color: #'.$v.'; font-weight:bold;" id="'.$id.'_'.$v.'"';
        if ($select == $v) { print ' selected';}
        print ' >★</option>'."\n";
    }
}

 ?>