<?php
/*
 * Ajax Chat for TRPG ver.1.0.1
 * (c)2007 Cake All righ1ts reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 *
 * [注意事項他]
 * 本チャットスクリプトの使用および配布は、BSDライセンスに基づきます。
 * BSDライセンスの詳細につきましては、添付のライセンス.txtを参照してください。
 *
 * BSDライセンス概要＆使用上の注意
 * 1. このスクリプトはフリーソフトです。以下の条件を満たす限りにおいて、使用・改造・再配布（オリジナルおよび改造版の両方とも）は自由です。
 * 再配布する場合、上記著作権表示、本条件書きおよび第2項・第3項の責任限定規定を必ず含めてください。
 * 2. 同梱のアイコンはPetite Prier様(http://snow.if.tv/)の素材です。
      本スクリプトの使用および再配布時にアイコンをそのまま用いる場合は、配布元の規定も遵守してください。
 * 3. 本スクリプトは無保証です。自己責任で使用してください。このスクリプトを使用したいかなる損害に対しても、作者は一切の責任を負いません。
 * 4. 設置および使用方法に関する質問は、配布サイトの掲示板にお願いします。ただし、必ず回答できるとは限りません。
 * メールによる質問は、ご遠慮ください。
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './pastlog-ini.php';

// パスワードの照合
if ($masterpass && $_REQUEST['admin_pwd'] != $masterpass) error('パスワードが違います。');

/* 送信内容別 */
// 過去ログ削除確認
if ($_REQUEST['mode'] == 'delete_log_confirm') {
    if ($_REQUEST['type'] == 'public') {
        $dir = $past_dir;
    } elseif ($_REQUEST['type'] == 'admin') {
        $dir = $master_past_dir;
    } else {
        error('データが正しく送信されていません。');
    }
    $type = $_REQUEST['type'];

    if (!$_REQUEST['filename'][0]) {
        error('ファイルを指定してください。');
        exit;
    }

    print html_header('main', $title.' 過去ログ削除確認', false, true);

    print '<h2>削除確認</h2>'."\n";
    print '<p><font color="#FF0000">以下の過去ログを削除します。よろしいですか？</font></p>'."\n";
    print '<form action="'.$pastlog_maker.'" method="'.$method.'">'."\n";
    print '<input type="hidden" name="mode" value="delete_log">'."\n";
    print '<input type="hidden" name="admin_pwd" value="'.$masterpass.'">'."\n";
    print '<input type="hidden" name="type" value="'.$type.'">'."\n";
    print '<ul>'."\n";
    foreach ($_REQUEST['filename'] as $k => $v) {
        print '<li><input type="hidden" name="filename[]" value="'.$v.'"> <a href="'.$dir.$v.'" target="admin_past">'.$v.'</a></li>'."\n";
    }
    print '</ul>'."\n";
    print '<p><input type="submit" value="削除する"></p>'."\n";
    print '</form>'."\n";
    print html_footer('');
    exit;

// 過去ログ削除
} elseif ($_REQUEST['mode'] == 'delete_log') {
    if ($_REQUEST['type'] == 'public') {
        $dir = $past_dir;
    } elseif ($_REQUEST['type'] == 'admin') {
        $dir = $master_past_dir;
    } else {
        error('データが正しく送信されていません。');
    }

    if (!$_REQUEST['filename'][0]) {
        error('ファイルを指定してください。');
        exit;
    }

    foreach($_REQUEST['filename'] as $v) {
        if (file_exists($dir.$v)) unlink($dir.$v);
    }
    header("Location: $pastlog_maker?admin_pwd=$masterpass&mode=del_end");
    exit;

// 過去ログ作成
} elseif ($_REQUEST['mode'] == 'write_log') {
    write_log($past_dir, $master_past_dir, $past_log, $masterpass, $color_system, $copyright, $_REQUEST['datetime'], $_REQUEST['whisper'], $_REQUEST['filename']);
    if ($_REQUEST['delete']) {
        $fp = fopen($recent_log, "w");
        fclose($fp);
        $fp = fopen($past_log, "w");
        fclose($fp);
    }
    header("Location: $pastlog_maker?admin_pwd=$masterpass&mode=write_end");
    exit;

// 過去ログ作成完了
} elseif ($_REQUEST['mode'] == 'write_end') {
    print html_header('main', $title.' 過去ログ作成完了', false, true);

    print '<p>過去ログを作成しました。</p>'."\n";
    print '<form action="'.$pastlog_maker.'" method="'.$method.'">'."\n";
    print '<input type="hidden" name="mode" value="">'."\n";
    print '<input type="hidden" name="admin_pwd" value="'.$masterpass.'">'."\n";
    print '<p><input type="submit" value="戻る"></p>'."\n";
    print '</form>'."\n";
    print html_footer('');
    exit;

// 削除完了
} elseif ($_REQUEST['mode'] == 'del_end') {
    print html_header('main', $title.' 過去ログ削除完了', false, true);

    print '<p>過去ログを削除しました。</p>'."\n";
    print '<form action="'.$pastlog_maker.'" method="'.$method.'">'."\n";
    print '<input type="hidden" name="mode" value="">'."\n";
    print '<input type="hidden" name="admin_pwd" value="'.$masterpass.'">'."\n";
    print '<p><input type="submit" value="戻る"></p>'."\n";
    print '</form>'."\n";
    print html_footer('');
    exit;
}

// 画面表示：HTML出力
print html_header('main', $title.' 過去ログ管理画面', false, true);

?>
</head>
<body>
<h2 align="center"><?php print $title; ?> 過去ログ管理画面</h2>

<?php
if ($_REQUEST['msg']) print '<p style="color:red">'.$_REQUEST['msg'].'</p>';
?>

<table cellspacing="0" align="center" border="1" bordercolor="#000000">
<tr><td colspan="2">
<form action="<?php print $pastlog_maker; ?>" method="<?php print $method; ?>" name="write_log">
<input name="mode" type="hidden" value="write_log">
<input name="admin_pwd" type="hidden" value="<?php print $_REQUEST['admin_pwd']; ?>">
<table align="center" border="0">
<tr>
<td><input type="checkbox" name="datetime" value="1">
発言時間表示</td>
<td><input type="checkbox" name="whisper" value="1">ささやき全表示</td>
<td><input checked type="checkbox" name="delete" value="1">ログ削除</td>
</tr>
<tr><td colspan="3" align="center">ログファイル名：<input name="filename" type="text" value="<?php print date('Ymd'); ?>" size="10" maxlength="30" style="ime-mode:disabled;">.html　<input type="submit" value="過去ログ作成"></td></tr>
</table></form>
<span align="left">「ささやき全表示」：指定すると公開ログにも全ての「ささやき」が表示されます。<br>
「ログ削除」：過去ログ作成と同時に、現在のログを全て削除します。<br></span>
</td></tr>

<tr>
<td valign="top" width="50%">
<h4>公開過去ログ</h4>

<?php
if ($log_list = log_list($past_dir)) {
    print '<form action="./'.$pastlog_maker.'" method="'.$method.'">'."\n";
    print '<input type="hidden" name="mode" value="delete_log_confirm">'."\n";
    print '<input type="hidden" name="admin_pwd" value="'.$masterpass.'">'."\n";
    print '<input type="hidden" name="type" value="public">'."\n";
    print $log_list;
    print '<br><input type="submit" value="削除確認">'."\n";
    print '</form>'."\n";
} else {
    print '公開過去ログはありません。';
}
?>
</td>
<td valign="top" width="50%">
<h4>管理用過去ログ(非公開)</h4>

<?php
if ($log_list = log_list($master_past_dir)) {
    print '<form action="./'.$pastlog_maker.'" method="'.$method.'">'."\n";
    print '<input type="hidden" name="mode" value="delete_log_confirm">'."\n";
    print '<input type="hidden" name="admin_pwd" value="'.$masterpass.'">'."\n";
    print '<input type="hidden" name="type" value="admin">'."\n";
    print $log_list;
    print '<br><input type="submit" value="削除確認">'."\n";
    print '</form>'."\n";
} else {
    print '管理用過去ログはありません。';
}
?>

<h5>管理用過去ログには、全ての発言時間・ささやき・参加者のホスト情報が記録されます</h5>

</td>
</tr>
</table>

<?php
// フッター
print html_footer($copyright);


/* 関数 */
// 過去ログ作成
function  write_log($past_dir, $master_past_dir, $past_log, $masterpass, $color_system, $copyright, $datetime, $whisper, $filename) {
    $log_master = read_log($past_log, $masterpass, $masterpass, true, $color_system);
    if (!$log_master) return false;
    if (!$whisper) {
        $log = read_log($past_log, '', '', $datetime, $color_system);
    } else {
        $log = read_log($past_log, '', $masterpass, $datetime, $color_system);
    }
    if (!$log) return false;

    if (file_exists($past_dir.$filename.".html")) {
        $filename = $filename. "_". time();
    }

    $header = html_header('pastlog', '過去ログ '.$filename, false, false);
    $header2 = html_header('pastlog', '過去ログ [管理用]'.$filename, false, false);
    $footer = html_footer($copyright);

    $fp = fopen($past_dir.$filename.".html", "w");
    stream_set_write_buffer($fp, 0);
    flock($fp,LOCK_EX);
    fwrite($fp, $header);
    if ($log) {
        fwrite($fp, '<div class="com_row">'."\n");
        foreach ($log as $v) {
            fwrite($fp, $v."<br>\n");
        }
        fwrite($fp, '</div>'."\n");
    }
    fwrite($fp, '<hr>');
    fwrite($fp, $footer);
    fflush($fp);
    fclose($fp);

    $fp2 = fopen($master_past_dir.$filename.".html", "w");
    stream_set_write_buffer($fp2, 0);
    flock($fp2,LOCK_EX);
    fwrite($fp2, $header2);
    if ($log_master) {
        fwrite($fp2, '<div class="com_row">'."\n");
        foreach ($log_master as $v) {
            fwrite($fp2, $v."<br>\n");
        }
        fwrite($fp2, '</div>'."\n");
    }
    fwrite($fp2, '<hr>');
    fwrite($fp2, $footer);
    fflush($fp2);
    fclose($fp2);

}

// 過去ログリスト
function log_list($log_dir) {
    $dir = opendir($log_dir);
    while($logfiles = readdir($dir)) {
        if (!ereg("^\.", $logfiles) && $logfiles != 'index.html') {
            $array_logfiles[] = '<input type="checkbox" name="filename[]" value="'.$logfiles.'"> <a href="'.$log_dir.$logfiles.'" target="admin_past">'.$logfiles.'</a><br>'."\n";
        }
    }
    closedir($dir);

    if ($array_logfiles) {
        rsort($array_logfiles);
        foreach ($array_logfiles as $v) {
            $list .= $v;
        }
    }

    return $list;

}

?>