/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Config;
import com.ozacc.mail.trotter.ListReader;
import com.ozacc.mail.trotter.Person;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;

class PlainListReader
implements ListReader {
    private Config config;
    private BufferedReader br;
    private String email;
    private boolean flag;
    private boolean isOpen;
    private static PlainListReader instance;

    private PlainListReader(Config config) {
        this.config = config;
    }

    static synchronized ListReader getInstance(Config config) {
        if (instance == null) {
            instance = new PlainListReader(config);
        }
        return instance;
    }

    public void open() throws IOException {
        if (this.isOpen) {
            return;
        }
        try {
            this.br = new BufferedReader(new FileReader(this.config.getListFileName()));
            this.isOpen = true;
        }
        catch (IOException iOException) {
            throw new IOException("\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
    }

    public void close() throws IOException {
        if (this.isOpen) {
            this.br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Person next() throws NoSuchElementException {
        if (this.email == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Person person = new Person(this.email);
            return person;
        }
        finally {
            this.flag = false;
            this.email = null;
        }
    }

    public boolean hasNext() {
        try {
            if (!this.flag) {
                this.email = this.br.readLine();
                if (this.email != null) {
                    this.flag = true;
                    return true;
                }
                return false;
            }
            return this.email != null;
        }
        catch (IOException iOException) {
            this.flag = false;
            return false;
        }
    }
}

