/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jp.snowgoose.treno.util.ClassCollector;
import jp.snowgoose.treno.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarClassCollector
implements ClassCollector {
    private static final Logger log = LoggerFactory.getLogger(JarClassCollector.class);

    public Collection<Class> collect(String packageName, URL source) {
        JarFile jarFile;
        if (source == null || !source.getProtocol().equals("jar") || packageName == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            JarURLConnection connection = (JarURLConnection)source.openConnection();
            jarFile = connection.getJarFile();
        }
        catch (IOException ignore) {
            return Collections.emptyList();
        }
        HashSet<Class> collectedClasses = new HashSet<Class>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String shortClassName;
            JarEntry entry = enumeration.nextElement();
            String entryName = entry.getName().replace('\\', '/');
            if (!entryName.endsWith(".class")) continue;
            String className = entryName.substring(0, entryName.length() - ".class".length()).replace('/', '.');
            int pos = className.lastIndexOf(46);
            String detectedPackageName = pos == -1 ? null : className.substring(0, pos);
            String string = shortClassName = pos == -1 ? className : className.substring(pos + 1);
            if (detectedPackageName == null || !detectedPackageName.contains(packageName)) continue;
            Class<?> clazz = ClassUtils.forNameSilentry(detectedPackageName + "." + shortClassName);
            if (log.isDebugEnabled()) {
                log.debug("adding found class resource : " + clazz);
            }
            collectedClasses.add(clazz);
        }
        return collectedClasses;
    }
}

