/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import jp.snowgoose.treno.exception.ActionNotFoundException;
import jp.snowgoose.treno.metadata.ActionDescriptor;
import jp.snowgoose.treno.metadata.ActionDescriptorFactory;
import jp.snowgoose.treno.metadata.MappedPath;
import jp.snowgoose.treno.util.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionDescriptors {
    private static final Logger log = LoggerFactory.getLogger(ActionDescriptors.class);
    private final Map<MappedPath, ActionDescriptor> actionDescriptorsMap = Maps.newLinkedHashMap();

    public ActionDescriptors() {
    }

    public ActionDescriptors(List<String> packageNames, ActionDescriptorFactory factory, Collection<Class<?>> actionClasses) {
        this.init(packageNames, factory, actionClasses);
    }

    protected void init(List<String> packageNames, ActionDescriptorFactory factory, Collection<Class<?>> actionClasses) {
        this.putToActionDescriptorsMap(actionClasses, factory);
    }

    private void putToActionDescriptorsMap(Collection<Class<?>> collectedClasses, ActionDescriptorFactory factory) {
        for (Class<?> clazz : collectedClasses) {
            for (ActionDescriptor actionDesc : factory.createActionDescriptors(clazz)) {
                this.put(actionDesc);
            }
        }
    }

    public ActionDescriptor getActionDescriptor(MappedPath mappedPath) throws ActionNotFoundException {
        if (!this.actionDescriptorsMap.containsKey(mappedPath)) {
            throw new ActionNotFoundException(mappedPath);
        }
        return this.actionDescriptorsMap.get(mappedPath);
    }

    protected Map<MappedPath, ActionDescriptor> getActionDescriptorsMap() {
        return this.actionDescriptorsMap;
    }

    public void put(ActionDescriptor actionDescriptor) {
        if (this.actionDescriptorsMap.containsKey(actionDescriptor.getMappedPath())) {
            log.warn("action registration ignored.");
        } else {
            this.actionDescriptorsMap.put(actionDescriptor.getMappedPath(), actionDescriptor);
        }
    }

    public int size() {
        return this.actionDescriptorsMap.keySet().size();
    }
}

