/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.context;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import jp.snowgoose.treno.component.Addon;
import jp.snowgoose.treno.metadata.BindDescriptor;
import jp.snowgoose.treno.util.Maps;
import jp.snowgoose.treno.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ParameterConverter
extends Addon {
    public <T> T convert(Object var1, BindDescriptor var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateConverter
    extends StringToConverter<Date> {
        @Override
        public Date convert(BindDescriptor bindDesc, String from) {
            try {
                return new SimpleDateFormat(bindDesc.getFormat()).parse(from);
            }
            catch (ParseException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DecimalConverter
    extends StringToConverter<BigDecimal> {
        @Override
        public BigDecimal convert(BindDescriptor bindDesc, String from) {
            String format = bindDesc.getFormat();
            if (StringUtils.isNotEmpty(format)) {
                DecimalFormat formatter = new DecimalFormat(format);
                try {
                    return BigDecimal.valueOf((Long)formatter.parse(from));
                }
                catch (ParseException e) {
                    return new BigDecimal(from);
                }
            }
            return new BigDecimal(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongConverter
    extends StringToConverter<Long> {
        @Override
        public Long convert(BindDescriptor bindDesc, String from) {
            return Long.valueOf(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntConverter
    extends StringToConverter<Integer> {
        @Override
        public Integer convert(BindDescriptor bindDesc, String from) {
            return Integer.valueOf(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharacterConverter
    extends StringToConverter<Character> {
        @Override
        public Character convert(BindDescriptor bindDesc, String from) {
            if (StringUtils.isEmpty(from)) {
                return null;
            }
            return Character.valueOf(from.toCharArray()[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatConverter
    extends StringToConverter<Float> {
        @Override
        public Float convert(BindDescriptor bindDesc, String from) {
            return Float.valueOf(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortConverter
    extends StringToConverter<Short> {
        @Override
        public Short convert(BindDescriptor bindDesc, String from) {
            return Short.valueOf(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanConverter
    extends StringToConverter<Boolean> {
        @Override
        public Boolean convert(BindDescriptor bindDesc, String from) {
            return Boolean.valueOf(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StringToConverter<T>
    extends NoneConverter<String, T> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoneConverter<F, T>
    implements Converter<F, T> {
        @Override
        public T convert(BindDescriptor bindDesc, F from) {
            return (T)from;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Converter<F, T> {
        public T convert(BindDescriptor var1, F var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConverterKey {
        private Class<?> from;
        private Class<?> to;

        static ConverterKey get(Class<?> from, Class<?> to) {
            return new ConverterKey(from, to);
        }

        ConverterKey(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object other) {
            if (other instanceof ConverterKey) {
                ConverterKey otherKey = (ConverterKey)other;
                return otherKey.from.equals(this.from) && otherKey.to.equals(this.to);
            }
            return false;
        }

        public int hashCode() {
            return this.from.hashCode() & this.to.hashCode();
        }

        public String toString() {
            return this.from.getCanonicalName() + "_to_" + this.to.getCanonicalName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AutoParameterConverter
    implements ParameterConverter {
        private static final Map<ConverterKey, Converter> converterMap = Maps.newLinkedHashMap();

        @Override
        public <T> T convert(Object param, BindDescriptor bindDesc) {
            if (param == null) {
                return null;
            }
            Converter<?, ?> converter = this.getConverter(param.getClass(), bindDesc);
            return (T)converter.convert(bindDesc, param);
        }

        private Converter<?, ?> getConverter(Class<?> fromClass, BindDescriptor bindDesc) {
            ConverterKey key = ConverterKey.get(fromClass, bindDesc.getParameterType());
            if (converterMap.containsKey(key)) {
                return converterMap.get(key);
            }
            return new NoneConverter();
        }

        static {
            converterMap.put(ConverterKey.get(String.class, Boolean.class), new BooleanConverter());
            converterMap.put(ConverterKey.get(String.class, Character.class), new CharacterConverter());
            converterMap.put(ConverterKey.get(String.class, Float.class), new FloatConverter());
            converterMap.put(ConverterKey.get(String.class, Short.class), new ShortConverter());
            converterMap.put(ConverterKey.get(String.class, Integer.class), new IntConverter());
            converterMap.put(ConverterKey.get(String.class, Long.class), new LongConverter());
            converterMap.put(ConverterKey.get(String.class, BigDecimal.class), new DecimalConverter());
            converterMap.put(ConverterKey.get(String.class, Date.class), new DateConverter());
        }
    }
}

