/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.FilterConfig;
import jp.snowgoose.treno.component.SimpleInstanceProvider;
import jp.snowgoose.treno.config.Config;
import jp.snowgoose.treno.metadata.Suffix;
import jp.snowgoose.treno.util.Assertion;
import jp.snowgoose.treno.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebConfig
implements Config {
    private static final String DEFAULT_COMPONENT_PACKAGENAME = "jp.snowgoose.treno";
    private static final String DEFAULT_ACTION_FACTORY_ID = "annotation";
    private FilterConfig filterConfig;
    private List<String> actionPackageNames;
    private List<String> componentsPackageNames;
    private String actionInstanceProviderClassName;
    private String actionFactoryId;
    private String componentInstanceProviderClassName;
    private Suffix suffix;

    public WebConfig(FilterConfig filterConfig) {
        Assertion.notNull(filterConfig, "FilterConfig");
        this.filterConfig = filterConfig;
        this.actionPackageNames = this.getActionPackageNames(filterConfig.getInitParameter("reno.config.action.packages"));
        this.actionFactoryId = this.getInitParameter0(filterConfig, "reno.config.action.factory.id", DEFAULT_ACTION_FACTORY_ID);
        this.componentsPackageNames = this.getComponentPackageNames(filterConfig.getInitParameter("reno.config.components.packages"));
        this.suffix = this.initSuffix(filterConfig.getInitParameter("reno.config.action.suffix"));
        this.actionInstanceProviderClassName = this.getInitParameter0(filterConfig, "reno.config.action.provider", SimpleInstanceProvider.class.getCanonicalName());
        this.componentInstanceProviderClassName = this.getInitParameter0(filterConfig, "reno.config.components.provider", SimpleInstanceProvider.class.getCanonicalName());
    }

    private String getInitParameter0(FilterConfig config, String parameter, String defaultValue) {
        String value = config.getInitParameter(parameter);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    protected List<String> getActionPackageNames(String names) {
        Assertion.notNull(names, "action package names");
        return this.getPackageNames0(names);
    }

    protected List<String> getComponentPackageNames(String names) {
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.addAll(this.getPackageNames0(names));
        if (packageNames.isEmpty()) {
            packageNames.add(DEFAULT_COMPONENT_PACKAGENAME);
        }
        return packageNames;
    }

    protected List<String> getPackageNames0(String names) {
        if (names != null) {
            return Arrays.asList(names.split(","));
        }
        return Collections.emptyList();
    }

    protected Suffix initSuffix(String suffixName) {
        if (StringUtils.isEmpty(suffixName)) {
            return Suffix.DEFAULT;
        }
        return new Suffix(suffixName);
    }

    @Override
    public List<String> getActionPackageNames() {
        return this.actionPackageNames;
    }

    @Override
    public List<String> getComponentPackageNames() {
        return this.componentsPackageNames;
    }

    @Override
    public Suffix getSuffix() {
        return this.suffix;
    }

    @Override
    public String getActionInstanceProviderClassName() {
        return this.actionInstanceProviderClassName;
    }

    @Override
    public String getComponentInstanceProviderClassName() {
        return this.componentInstanceProviderClassName;
    }

    @Override
    public String getActionDescriptorFactoryId() {
        return this.actionFactoryId;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }
}

