/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import jp.snowgoose.treno.util.ResourceUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ResourceUtilsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testFindURL_ViaClassPathResource() throws Exception {
        URL url = ResourceUtils.findResource((String)(this.getClass().getCanonicalName().replace(".", File.separator) + ".class"));
        Assert.assertTrue((boolean)new File(url.toURI()).isFile());
    }

    @Test
    public void testFindURL_ViaFile() throws Exception {
        int c;
        File tempFile = this.folder.newFile("hellow.log");
        FileOutputStream out = new FileOutputStream(tempFile);
        ((OutputStream)out).write("hello!".getBytes());
        out.flush();
        ((OutputStream)out).close();
        URL url = ResourceUtils.findResource((String)tempFile.getCanonicalPath());
        InputStream in = url.openStream();
        StringBuilder actual = new StringBuilder();
        while ((c = in.read()) != -1) {
            actual.append((char)c);
        }
        Assert.assertThat((Object)actual.toString(), (Matcher)Is.is((Object)"hello!"));
    }

    @Test
    public void testFindURL_ViaFileIsNotExists() throws Exception {
        File tempFile = this.folder.newFile("hellow.log");
        FileOutputStream out = new FileOutputStream(tempFile);
        ((OutputStream)out).write("hello!".getBytes());
        out.flush();
        ((OutputStream)out).close();
        URL url = ResourceUtils.findResource((String)(tempFile.getCanonicalPath() + ".noexists"));
        Assert.assertNull((Object)url);
    }

    @Test
    public void testFindURL_NoRootFileResource() throws Exception {
        int c;
        File noRootTestFileResource = this.folder.newFile("noRoot.log");
        FileOutputStream out = new FileOutputStream(noRootTestFileResource);
        ((OutputStream)out).write("hello!".getBytes());
        out.flush();
        ((OutputStream)out).close();
        URL url = ResourceUtils.findResource((String)noRootTestFileResource.getPath());
        InputStream in = url.openStream();
        StringBuilder actual = new StringBuilder();
        while ((c = in.read()) != -1) {
            actual.append((char)c);
        }
        Assert.assertThat((Object)actual.toString(), (Matcher)Is.is((Object)"hello!"));
    }

    @Test
    public void testFindURL_ViaHttp() throws Exception {
        int c;
        try {
            Assume.assumeThat((Object)((HttpURLConnection)new URL("http://example.com/").openConnection()).getResponseCode(), (Matcher)Is.is((Object)200));
        }
        catch (UnknownHostException e) {
            Assume.assumeNoException((Throwable)e);
        }
        URL url = ResourceUtils.findResource((String)"http://example.com/");
        Assert.assertNotNull((Object)url);
        InputStream in = url.openStream();
        StringBuilder actual = new StringBuilder();
        while ((c = in.read()) != -1) {
            actual.append((char)c);
        }
        Assert.assertNotNull((Object)actual.toString());
    }

    @Test
    public void testFindURL_InValidScheme() throws Exception {
        URL url = ResourceUtils.findResource((String)"invalid://example.com/invalid://root");
        Assert.assertNull((Object)url);
    }

    @Test
    public void testFindURL_ArgIsNull() throws Exception {
        URL actual = ResourceUtils.findResource(null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void findResources() throws Exception {
        List found = ResourceUtils.findResources((String)"jp/snowgoose/treno");
        Assert.assertThat((Object)found.size(), (Matcher)Is.is((Object)2));
    }
}

