/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.lang.reflect.Method;
import jp.snowgoose.treno.annotation.BindValue;
import jp.snowgoose.treno.annotation.InvokeAction;
import jp.snowgoose.treno.annotation.InvokeActions;
import jp.snowgoose.treno.test.ManyActionContains;
import jp.snowgoose.treno.util.ReflectionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionUtilsTest {
    @Test
    public void testGetMethodParameterAnnotation() throws Exception {
        Method method = ManyActionContains.class.getMethod("doAnything", String.class);
        BindValue actual = (BindValue)ReflectionUtils.getMethodParameterAnnotation((Method)method, BindValue.class, (int)0);
        Assert.assertThat((Object)actual.value(), (Matcher)Is.is((Object)"message"));
    }

    @Test
    public void testGetMethodParameterAnnotation_NotFound() throws Exception {
        Method method = ManyActionContains.class.getMethod("doAnything", String.class);
        InvokeAction actual = (InvokeAction)ReflectionUtils.getMethodParameterAnnotation((Method)method, InvokeAction.class, (int)0);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testInvokeSet() {
        ManyActionContains instance = new ManyActionContains();
        ReflectionUtils.invokeMethodSilently((Object)instance, (String)"setUser", (Class[])new Class[]{String.class}, (Object[])new Object[]{"aUser"});
        Assert.assertThat((Object)instance.getUser(), (Matcher)Is.is((Object)"aUser"));
    }

    @Test
    public void testGetInstanceSilentry() {
        MockObject actual = (MockObject)ReflectionUtils.getInstanceSilently(MockObject.class);
        Assert.assertNotNull((Object)actual);
    }

    @Test
    public void is_implements_interface() {
        Assert.assertTrue((boolean)ReflectionUtils.isImplements(MockObject.class, IMockObject.class));
    }

    @Test
    public void is_implements_nested_interface() {
        Assert.assertTrue((boolean)ReflectionUtils.isImplements(MockIIObject.class, IMockObject.class));
    }

    @Test
    public void class_annotate_with() {
        Assert.assertTrue((boolean)ReflectionUtils.annotateWith(InvokeActions.class, MockObject.class));
    }

    @Test
    public void class_not_annotate_with() {
        Assert.assertFalse((boolean)ReflectionUtils.annotateWith(InvokeActions.class, IMockObject.class));
    }

    @Test
    public void bind_value_to_private_field() {
        MockObject obj = new MockObject();
        Assert.assertTrue((boolean)ReflectionUtils.setValueToField((String)"hoge", (int)2, (Object)obj, (Object)"fuga"));
        Assert.assertThat((Object)obj.hoge, (Matcher)Is.is((Object)"fuga"));
    }

    @Test
    public void bind_value_to_not_available_field() {
        MockObject obj = new MockObject();
        Assert.assertFalse((boolean)ReflectionUtils.setValueToField((String)"noexists", (int)2, (Object)obj, (Object)"fuga"));
        Assert.assertNull((Object)obj.hoge);
    }

    @Test
    public void get_value_via_private_field() {
        MockObject obj = new MockObject();
        obj.hoge = "foo";
        Object actual = ReflectionUtils.getValueViaField((String)"hoge", (int)2, (Object)obj);
        Assert.assertThat((Object)actual.toString(), (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void get_value_via_not_available_field() {
        MockObject obj = new MockObject();
        obj.hoge = "foo";
        Object actual = ReflectionUtils.getValueViaField((String)"noexists", (int)2, (Object)obj);
        Assert.assertNull((Object)actual);
    }

    public static class MockIIObject
    implements IIMockObject {
    }

    @InvokeActions
    public static class MockObject
    implements IMockObject {
        private String hoge;
    }

    public static interface IIMockObject
    extends IMockObject {
    }

    public static interface IMockObject {
    }
}

