/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.net.URL;
import java.util.Collection;
import jp.snowgoose.treno.util.ClassCollector;
import jp.snowgoose.treno.util.JarClassCollector;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JarClassCollectorTest {
    private ClassCollector collector;
    private static final String targetPackageName = "javax.servlet.http";
    private URL resource;

    @Before
    public void setUp() throws Exception {
        this.collector = new JarClassCollector();
        this.resource = Thread.currentThread().getContextClassLoader().getResource(targetPackageName.replace('.', '/'));
    }

    @Test
    public void testCollect() throws Exception {
        Collection collectedClasses = this.collector.collect(targetPackageName, this.resource);
        Assert.assertThat((Object)collectedClasses.size(), (Matcher)Is.is((Object)17));
    }

    @Test
    public void testCollect_NullPackageName() throws Exception {
        Collection result = this.collector.collect(null, this.resource);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testCollect_NullResourcePath() throws Exception {
        Collection result = this.collector.collect(targetPackageName, null);
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

