/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import jp.snowgoose.treno.util.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IOUtilsTest {
    @Rule
    public ExpectedException expectation = ExpectedException.none();

    @Test
    public void closing_closable_silently() throws Exception {
        this.expectation.expect(IOException.class);
        this.expectation.expectMessage("Stream closed");
        StringReader reader = new StringReader(String.valueOf("foo"));
        boolean closed = IOUtils.closeSilently((Closeable)reader);
        Assert.assertTrue((boolean)closed);
        reader.read();
    }

    @Test
    public void closing_null_stream() throws Exception {
        Closeable reader = null;
        Assert.assertFalse((boolean)IOUtils.closeSilently(reader));
    }
}

