/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import jp.snowgoose.treno.junit.CollectionAssert;
import jp.snowgoose.treno.test.ManyActionContains;
import jp.snowgoose.treno.test.NoActionContains;
import jp.snowgoose.treno.test.NotImplementYet;
import jp.snowgoose.treno.test.OneActionContains;
import jp.snowgoose.treno.util.ClassCollector;
import jp.snowgoose.treno.util.FileClassCollector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileClassCollectorTest {
    private ClassCollector collector;
    private static final String targetPackageName = "jp.snowgoose.treno.test";
    private String resourcePath;
    private URL resource;

    @Before
    public void setUp() throws Exception {
        this.collector = new FileClassCollector();
        this.resource = Thread.currentThread().getContextClassLoader().getResource(targetPackageName.replace('.', '/'));
        this.resourcePath = URLDecoder.decode(Thread.currentThread().getContextClassLoader().getResource(targetPackageName.replace('.', '/')).getFile(), "UTF-8");
    }

    @Test
    public void testCollect() throws Exception {
        Collection collectedClasses = this.collector.collect(targetPackageName, this.resource);
        CollectionAssert.assertContainsInstanceOfTypes(collectedClasses, ManyActionContains.class, NoActionContains.class, NotImplementYet.class, OneActionContains.class);
    }

    @Test
    public void testCollect_PackageNameIsNull() throws Exception {
        Collection result = this.collector.collect(null, this.resource);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testCollect_ResourcePathIsNull() throws Exception {
        Collection result = this.collector.collect(this.resourcePath, null);
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

