/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.util;

import java.lang.reflect.Method;
import jp.snowgoose.treno.test.ManyActionContains;
import jp.snowgoose.treno.util.ClassUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class ClassUtilsTest {
    @Test
    public void testForNameSilentry() {
        Class actual = ClassUtils.forNameSilentry((String)ClassUtilsTest.class.getCanonicalName());
        Assert.assertThat((Object)actual.getCanonicalName(), (Matcher)Is.is((Object)this.getClass().getCanonicalName()));
    }

    @Test
    public void testForNameSilentry_NotAviableClass() {
        Class actual = ClassUtils.forNameSilentry((String)"jp.snowgoose.not.exists.Class");
        Assert.assertNull((Object)actual);
    }

    @Test(expected=NullPointerException.class)
    public void testForNameSilentry_NullClass() {
        ClassUtils.forNameSilentry(null);
    }

    @Test
    public void testNewInstanceSilentry() {
        Assert.assertNotNull((Object)ClassUtils.newInstanceSilentry(ManyActionContains.class, (Object[])new Object[0]));
    }

    @Test
    public void testNewInstanceSilentry_NullArgs() {
        Assert.assertNotNull((Object)ClassUtils.newInstanceSilentry(ManyActionContains.class, null));
    }

    @Test
    public void testReadMethodSilentry() {
        Method readMethod = ClassUtils.getReadMethodSilentry(ManyActionContains.class, (String)"user");
        Assert.assertThat((Object)readMethod.getName(), (Matcher)Is.is((Object)"getUser"));
    }

    @Test
    public void testReadMethodSilentry_NoSuchNamedMethod() {
        Method readMethod = ClassUtils.getReadMethodSilentry(ManyActionContains.class, (String)"foo");
        Assert.assertNull((Object)readMethod);
    }

    @Test
    public void testWriteMethodSilentry() {
        Method readMethod = ClassUtils.getWriteMethodSilentry(ManyActionContains.class, String.class, (String)"user");
        Assert.assertThat((Object)readMethod.getName(), (Matcher)Is.is((Object)"setUser"));
    }

    @Test
    public void testWriteMethodSilentry_NoSuchArgument() {
        Method readMethod = ClassUtils.getWriteMethodSilentry(ManyActionContains.class, null, (String)"user");
        Assert.assertNull((Object)readMethod);
    }
}

