/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.result.type;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.snowgoose.treno.component.ActionInstance;
import jp.snowgoose.treno.component.InvokerTest;
import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.exception.ResultEvaluationFailureException;
import jp.snowgoose.treno.junit.MockRequestContext;
import jp.snowgoose.treno.junit.MockResultDescriptor;
import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.result.type.Redirect;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RedirectTest {
    private final Redirect redirect = new Redirect();
    private final Mockery mockery = new JUnit4Mockery();
    private final HttpServletRequest request = (HttpServletRequest)this.mockery.mock(HttpServletRequest.class);
    private final HttpServletResponse response = (HttpServletResponse)this.mockery.mock(HttpServletResponse.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private MockResultDescriptor resultDesc;
    private InvokerTest.MockAction mockAction;
    private RequestContext context = (RequestContext)this.mockery.mock(RequestContext.class);
    private ActionInstance actionInstance = (ActionInstance)this.mockery.mock(ActionInstance.class);
    private RequestValueMapper valueMapper = (RequestValueMapper)this.mockery.mock(RequestValueMapper.class);

    @Before
    public void setUp() {
        this.mockAction = new InvokerTest.MockAction();
        this.resultDesc = new MockResultDescriptor();
        this.resultDesc.setResultType(Redirect.class);
        this.resultDesc.setTo("/foo/baa/baz.do");
        this.resultDesc.setWhen("success");
        this.context = new MockRequestContext(this.request, this.response);
    }

    @Test
    public void testRender() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.oneOf(RedirectTest.this.response)).sendRedirect("/foo/baa/baz.do");
            }
        });
        this.mockAction.baz("snowgoose");
        this.redirect.render(this.context, this.valueMapper, this.actionInstance, (ResultDescriptor)this.resultDesc);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testRender_ThrowsException() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.oneOf(RedirectTest.this.response)).sendRedirect("/foo/baa/baz.do");
                this.will(2.throwException((Throwable)new IOException()));
            }
        });
        this.mockAction.baz("snowgoose");
        this.thrown.expect(ResultEvaluationFailureException.class);
        this.thrown.expectMessage(Is.is((Object)"result evaluation failure at success : /foo/baa/baz.do"));
        this.redirect.render(this.context, this.valueMapper, this.actionInstance, (ResultDescriptor)this.resultDesc);
    }
}

