/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.result;

import jp.snowgoose.treno.annotation.BindValue;
import jp.snowgoose.treno.annotation.Direction;
import jp.snowgoose.treno.annotation.InvokeAction;
import jp.snowgoose.treno.annotation.InvokeActions;
import jp.snowgoose.treno.component.ActionInstance;
import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.junit.MockActionDescriptor;
import jp.snowgoose.treno.junit.MockBindDescriptor;
import jp.snowgoose.treno.junit.MockDirectionType;
import jp.snowgoose.treno.junit.MockResultDescriptor;
import jp.snowgoose.treno.junit.MockResultTypes;
import jp.snowgoose.treno.metadata.BindDescriptor;
import jp.snowgoose.treno.metadata.BindDescriptors;
import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.metadata.ResultDescriptors;
import jp.snowgoose.treno.metadata.Scope;
import jp.snowgoose.treno.result.InvocationResult;
import jp.snowgoose.treno.result.InvocationResultEvaluator;
import jp.snowgoose.treno.result.type.DirectionType;
import jp.snowgoose.treno.result.type.DirectionTypes;
import jp.snowgoose.treno.result.type.Redirect;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;

public class InvocationResultEvaluatorTest {
    private InvocationResultEvaluator evaluator;
    private InvocationResult result;
    private final Mockery mockery = new JUnit4Mockery();
    private final DirectionTypes directionTypes = new MockResultTypes();
    private MockActionDescriptor actionDesc = new MockActionDescriptor();
    private RequestContext context = (RequestContext)this.mockery.mock(RequestContext.class);
    private ActionInstance actionInstance = (ActionInstance)this.mockery.mock(ActionInstance.class);
    private RequestValueMapper valueMapper = (RequestValueMapper)this.mockery.mock(RequestValueMapper.class);

    @Before
    public void setUp() {
        this.directionTypes.register((DirectionType)new MockDirectionType());
        ResultDescriptors resultDescs = new ResultDescriptors();
        MockResultDescriptor resultDesc = new MockResultDescriptor();
        resultDesc.setResultType(MockDirectionType.class);
        resultDesc.setTo("/foo/baa/success.do");
        resultDesc.setWhen("success");
        resultDescs.put((ResultDescriptor)resultDesc);
        this.actionDesc.setResultDescriptors(resultDescs);
        BindDescriptors bindDescs = new BindDescriptors();
        MockBindDescriptor replicateUser = new MockBindDescriptor();
        replicateUser.setBindElementType((BindDescriptor.BindElementType)new BindDescriptor.BindElementType.FieldBindElement(2, "replicateUser"));
        replicateUser.setFormat(null);
        replicateUser.setName("replicateUser");
        replicateUser.setParameterType(String.class);
        replicateUser.setScope(Scope.REQUEST);
        MockBindDescriptor user = new MockBindDescriptor();
        user.setBindElementType((BindDescriptor.BindElementType)new BindDescriptor.BindElementType.MethodBindElement("getUser"));
        user.setFormat(null);
        user.setName("user");
        user.setParameterType(String.class);
        user.setScope(Scope.SESSION);
        bindDescs.put((BindDescriptor)replicateUser);
        bindDescs.put((BindDescriptor)user);
        this.actionDesc.setBindDescriptors(bindDescs);
    }

    @Test
    public void test() {
        ActionStub action = new ActionStub();
        this.result = new InvocationResult(action.doSomething(), this.actionInstance);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ActionInstance)this.oneOf(InvocationResultEvaluatorTest.this.actionInstance)).getActionDescriptor();
                this.will(1.returnValue((Object)((Object)InvocationResultEvaluatorTest.this.actionDesc)));
                ((RequestValueMapper)this.oneOf(InvocationResultEvaluatorTest.this.valueMapper)).unmap(InvocationResultEvaluatorTest.this.actionInstance);
            }
        });
        this.evaluator = new InvocationResultEvaluator(this.result, this.directionTypes, this.context, this.valueMapper);
        this.evaluator.evaluate();
        this.mockery.assertIsSatisfied();
    }

    @InvokeActions(value="/foo/baa/*")
    public static class ActionStub {
        private String user;
        @BindValue
        private String replicateUser;

        @InvokeAction(path="something.do", directions={@Direction(when="success", to="/foo/baa/success.do"), @Direction(when="failure", to="/foo/baa/failure.do", type=Redirect.class)})
        public String doSomething() {
            this.setUser("user1");
            this.replicateUser = "user2";
            return "success";
        }

        @BindValue(scope=Scope.SESSION)
        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }
    }
}

