/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import javax.servlet.http.HttpServletRequest;
import jp.snowgoose.treno.metadata.RequestMappedPath;
import jp.snowgoose.treno.metadata.Suffix;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequestMappedPathTest {
    private RequestMappedPath mappedPath;
    private final Mockery mockery = new JUnit4Mockery();
    private final HttpServletRequest request = (HttpServletRequest)this.mockery.mock(HttpServletRequest.class);

    @Before
    public void setUp() {
    }

    @Test
    public void testGetPath() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getRequestURI();
                this.will(1.returnValue((Object)"/foo/baa/baz.do"));
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getContextPath();
                this.will(1.returnValue((Object)"/foo"));
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getRequestURI();
                this.will(1.returnValue((Object)"/foo/baa/baz.do"));
            }
        });
        this.mappedPath = new RequestMappedPath(this.request);
        String actual = this.mappedPath.getPath();
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)"/baa/baz"));
    }

    @Test
    public void testGetPath_ContainsJsessionId() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getRequestURI();
                this.will(2.returnValue((Object)"/foo/baa.do;jsessionid=1A26E401D812045AF2D9150891DA01B3"));
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getContextPath();
                this.will(2.returnValue((Object)"/foo"));
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getRequestURI();
                this.will(2.returnValue((Object)"/foo/baa.do;jsessionid=1A26E401D812045AF2D9150891DA01B3"));
            }
        });
        this.mappedPath = new RequestMappedPath(this.request);
        String actual = this.mappedPath.getPath();
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)"/baa"));
    }

    @Test
    public void testPathThrowgh() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getRequestURI();
                this.will(3.returnValue((Object)"/foo/baa.do;jsessionid=1A26E401D812045AF2D9150891DA01B3"));
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getContextPath();
                this.will(3.returnValue((Object)"/foo"));
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getRequestURI();
                this.will(3.returnValue((Object)"/foo/baa.do;jsessionid=1A26E401D812045AF2D9150891DA01B3"));
            }
        });
        this.mappedPath = new RequestMappedPath(this.request);
        Assert.assertTrue((boolean)this.mappedPath.pathThrowgh(Suffix.NONE));
    }

    @Test
    public void testPathThrowgh_IsActionPath() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getRequestURI();
                this.will(4.returnValue((Object)"/foo/baa.do;jsessionid=1A26E401D812045AF2D9150891DA01B3"));
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getContextPath();
                this.will(4.returnValue((Object)"/foo"));
                ((HttpServletRequest)this.one(RequestMappedPathTest.this.request)).getRequestURI();
                this.will(4.returnValue((Object)"/foo/baa.do;jsessionid=1A26E401D812045AF2D9150891DA01B3"));
            }
        });
        this.mappedPath = new RequestMappedPath(this.request);
        Assert.assertFalse((boolean)this.mappedPath.pathThrowgh(new Suffix(".do")));
    }
}

