/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import jp.snowgoose.treno.exception.AssertionFailedException;
import jp.snowgoose.treno.junit.CollectionAssert;
import jp.snowgoose.treno.metadata.ActionDescriptor;
import jp.snowgoose.treno.metadata.AnnotationActionDescriptorFactory;
import jp.snowgoose.treno.metadata.BindDescriptor;
import jp.snowgoose.treno.metadata.BindDescriptors;
import jp.snowgoose.treno.metadata.ResultDescriptor;
import jp.snowgoose.treno.metadata.ResultDescriptors;
import jp.snowgoose.treno.metadata.Scope;
import jp.snowgoose.treno.result.type.Forward;
import jp.snowgoose.treno.result.type.Redirect;
import jp.snowgoose.treno.test.ContainsFieldParameter;
import jp.snowgoose.treno.test.ManyActionContains;
import jp.snowgoose.treno.test.NoActionContains;
import jp.snowgoose.treno.test.OneActionContains;
import jp.snowgoose.treno.test.TypeBindContains;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AnnotationActionDescriptorFactoryTest {
    private AnnotationActionDescriptorFactory factory;
    @Rule
    public ExpectedException throwable = ExpectedException.none();

    @Before
    public void setUp() {
        this.factory = new AnnotationActionDescriptorFactory();
    }

    @Test
    public void create_action_descriptors() {
        Collection actionDescs = this.factory.createActionDescriptors(OneActionContains.class);
        Assert.assertThat((Object)actionDescs.size(), (Matcher)Is.is((Object)1));
        ActionDescriptor actionDesc = (ActionDescriptor)actionDescs.iterator().next();
        ActionDescriptor.ActionMethod actionMethod = actionDesc.getActionMethod();
        Assert.assertThat((Object)actionMethod.getActionClass().getCanonicalName(), (Matcher)Is.is((Object)OneActionContains.class.getCanonicalName()));
        CollectionAssert.assertContainsInstanceOfTypes(Arrays.asList(actionMethod.getArgumentTypes()), Date.class);
        Assert.assertThat((Object)actionMethod.getMethodName(), (Matcher)Is.is((Object)"doSomething"));
        Assert.assertThat((Object)actionDesc.getMappedPath().getPath(), (Matcher)Is.is((Object)"/foo/baa/something.do"));
        BindDescriptors bindDescriptors = actionDesc.getBindDescriptors();
        BindDescriptor birthDay = bindDescriptors.getBindDescriptor("birthDay");
        BindDescriptor user = bindDescriptors.getBindDescriptor("user");
        BindDescriptor userPassword = bindDescriptors.getBindDescriptor("userPassword");
        Assert.assertThat((Object)birthDay.getName(), (Matcher)Is.is((Object)"birthDay"));
        Assert.assertThat((Object)birthDay.getBindElementType().getType(), (Matcher)Is.is((Object)BindDescriptor.BindElementType.BindType.PARAMETER));
        Assert.assertEquals((Object)birthDay.getParameterType(), Date.class);
        Assert.assertThat((Object)birthDay.getScope(), (Matcher)Is.is((Object)Scope.REQUEST));
        Assert.assertThat((Object)birthDay.getFormat(), (Matcher)Is.is((Object)"yyyy/MM/dd"));
        Assert.assertThat((Object)user.getName(), (Matcher)Is.is((Object)"user"));
        Assert.assertThat((Object)user.getBindElementType().getType(), (Matcher)Is.is((Object)BindDescriptor.BindElementType.BindType.METHOD));
        Assert.assertEquals((Object)user.getParameterType(), String.class);
        Assert.assertThat((Object)user.getScope(), (Matcher)Is.is((Object)Scope.SESSION));
        Assert.assertThat((Object)((BindDescriptor.BindElementType.MethodBindElement)user.getBindElementType()).getMethodName(), (Matcher)Is.is((Object)"getUser"));
        Assert.assertThat((Object)userPassword.getName(), (Matcher)Is.is((Object)"userPassword"));
        Assert.assertThat((Object)userPassword.getBindElementType().getType(), (Matcher)Is.is((Object)BindDescriptor.BindElementType.BindType.METHOD));
        Assert.assertEquals((Object)userPassword.getParameterType(), String.class);
        Assert.assertThat((Object)userPassword.getScope(), (Matcher)Is.is((Object)Scope.REQUEST));
        ResultDescriptors results = actionDesc.getResultDescriptors();
        ResultDescriptor success = results.getResultDescriptor("success");
        Assert.assertThat((Object)success.getWhen(), (Matcher)Is.is((Object)"success"));
        Assert.assertThat((Object)success.getTo(), (Matcher)Is.is((Object)"/foo/baa/success.do"));
        Assert.assertEquals((Object)success.getResultType(), Forward.class);
        ResultDescriptor failure = results.getResultDescriptor("failure");
        Assert.assertThat((Object)failure.getWhen(), (Matcher)Is.is((Object)"failure"));
        Assert.assertThat((Object)failure.getTo(), (Matcher)Is.is((Object)"/foo/baa/failure.do"));
        Assert.assertEquals((Object)failure.getResultType(), Redirect.class);
    }

    @Test
    public void contains_many_action_on_one_class() {
        Collection actionDescs = this.factory.createActionDescriptors(ManyActionContains.class);
        Assert.assertThat((Object)actionDescs.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void raise_assertion_failed_exception_when_argument_is_null() {
        this.throwable.expect(AssertionFailedException.class);
        this.throwable.expectMessage(Is.is((Object)"ActionClass is required."));
        this.factory.createActionDescriptors(null);
    }

    @Test
    public void returns_empty_result_when_creating_no_action_contains_class() {
        Collection actual = this.factory.createActionDescriptors(NoActionContains.class);
        Assert.assertThat((Object)actual.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void action_type_bind_descriptor_contains() {
        Collection actual = this.factory.createActionDescriptors(TypeBindContains.class);
        Assert.assertThat((Object)actual.size(), (Matcher)Is.is((Object)1));
        ActionDescriptor actionDesc = (ActionDescriptor)actual.iterator().next();
        BindDescriptors bindDescs = actionDesc.getBindDescriptors();
        BindDescriptor type = bindDescs.getBindDescriptor("typeBindContains");
        Assert.assertThat((Object)type.getBindElementType().getType(), (Matcher)Is.is((Object)BindDescriptor.BindElementType.BindType.TYPE));
    }

    @Test
    public void action_private_field_bind_descriptor_contains() {
        Collection actual = this.factory.createActionDescriptors(ContainsFieldParameter.class);
        Assert.assertThat((Object)actual.size(), (Matcher)Is.is((Object)1));
        ActionDescriptor actionDesc = (ActionDescriptor)actual.iterator().next();
        BindDescriptors bindDescs = actionDesc.getBindDescriptors();
        BindDescriptor say = bindDescs.getBindDescriptor("say");
        BindDescriptor isMale = bindDescs.getBindDescriptor("male");
        Assert.assertEquals((Object)say.getParameterType(), String.class);
        Assert.assertThat((Object)say.getBindElementType().getType(), (Matcher)Is.is((Object)BindDescriptor.BindElementType.BindType.FIELD));
        Assert.assertThat((Object)((BindDescriptor.BindElementType.FieldBindElement)say.getBindElementType()).getModefier(), (Matcher)Is.is((Object)2));
        Assert.assertEquals((Object)isMale.getParameterType(), Boolean.TYPE);
        Assert.assertThat((Object)isMale.getBindElementType().getType(), (Matcher)Is.is((Object)BindDescriptor.BindElementType.BindType.FIELD));
        Assert.assertThat((Object)((BindDescriptor.BindElementType.FieldBindElement)isMale.getBindElementType()).getModefier(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((BindDescriptor.BindElementType.FieldBindElement)isMale.getBindElementType()).getFieldName(), (Matcher)Is.is((Object)"isMale"));
    }
}

