/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.filter;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.snowgoose.treno.exception.ActionInvocationException;
import jp.snowgoose.treno.exception.ActionNotFoundException;
import jp.snowgoose.treno.exception.ActionNotRegisterdException;
import jp.snowgoose.treno.exception.ResultNotRegisterdException;
import jp.snowgoose.treno.filter.RenoFilter;
import jp.snowgoose.treno.junit.Matchers;
import jp.snowgoose.treno.test.Calculator;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RenoFilterTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final Mockery mockery = new JUnit4Mockery();
    private final FilterConfig filterConfig = (FilterConfig)this.mockery.mock(FilterConfig.class);
    private final FilterChain filterChain = (FilterChain)this.mockery.mock(FilterChain.class);
    private final HttpServletRequest request = (HttpServletRequest)this.mockery.mock(HttpServletRequest.class);
    private final HttpServletResponse response = (HttpServletResponse)this.mockery.mock(HttpServletResponse.class);
    private final RequestDispatcher requestDispatcher = (RequestDispatcher)this.mockery.mock(RequestDispatcher.class);

    @Test
    public void request_available_action() throws Exception {
        RenoFilter filter = new RenoFilter();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.packages");
                this.will(1.returnValue((Object)Calculator.class.getPackage().getName()));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.factory.id");
                this.will(1.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.packages");
                this.will(1.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.suffix");
                this.will(1.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.provider");
                this.will(1.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.provider");
                this.will(1.returnValue(null));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getRequestURI();
                this.will(1.returnValue((Object)"/app/calc/add.rn"));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getContextPath();
                this.will(1.returnValue((Object)"/app"));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getRequestURI();
                this.will(1.returnValue((Object)"/app/calc/add.rn"));
                ((HttpServletRequest)this.allowing(RenoFilterTest.this.request)).getParameter("result");
                this.will(1.returnValue(null));
                ((HttpServletRequest)this.allowing(RenoFilterTest.this.request)).getAttribute("result");
                this.will(1.returnValue(null));
                ((HttpServletRequest)this.allowing(RenoFilterTest.this.request)).getParameter("right");
                this.will(1.returnValue((Object)"1"));
                ((HttpServletRequest)this.allowing(RenoFilterTest.this.request)).getParameter("left");
                this.will(1.returnValue((Object)"2"));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).setAttribute("result", (Object)"3");
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getRequestDispatcher("success.jsp");
                this.will(1.returnValue((Object)RenoFilterTest.this.requestDispatcher));
                ((RequestDispatcher)this.one(RenoFilterTest.this.requestDispatcher)).forward((ServletRequest)RenoFilterTest.this.request, (ServletResponse)RenoFilterTest.this.response);
            }
        });
        filter.init(this.filterConfig);
        filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void request_no_available_action() throws Exception {
        RenoFilter filter = new RenoFilter();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.packages");
                this.will(2.returnValue((Object)Calculator.class.getPackage().getName()));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.factory.id");
                this.will(2.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.packages");
                this.will(2.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.suffix");
                this.will(2.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.provider");
                this.will(2.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.provider");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getRequestURI();
                this.will(2.returnValue((Object)"/app/not/available.rn"));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getContextPath();
                this.will(2.returnValue((Object)"/app"));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getRequestURI();
                this.will(2.returnValue((Object)"/app/not/available.rn"));
                ((FilterChain)this.one(RenoFilterTest.this.filterChain)).doFilter((ServletRequest)RenoFilterTest.this.request, (ServletResponse)RenoFilterTest.this.response);
            }
        });
        this.thrown.expect(ActionNotFoundException.class);
        filter.init(this.filterConfig);
        filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void requested_action_raise_exception() throws Exception {
        RenoFilter filter = new RenoFilter();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.packages");
                this.will(3.returnValue((Object)Calculator.class.getPackage().getName()));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.factory.id");
                this.will(3.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.packages");
                this.will(3.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.suffix");
                this.will(3.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.provider");
                this.will(3.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.provider");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getRequestURI();
                this.will(3.returnValue((Object)"/app/calc/exception.rn"));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getContextPath();
                this.will(3.returnValue((Object)"/app"));
                ((HttpServletRequest)this.one(RenoFilterTest.this.request)).getRequestURI();
                this.will(3.returnValue((Object)"/app/calc/exception.rn"));
                ((HttpServletRequest)this.allowing(RenoFilterTest.this.request)).getParameter("result");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.allowing(RenoFilterTest.this.request)).getAttribute("result");
                this.will(3.returnValue(null));
            }
        });
        this.thrown.expect(ActionInvocationException.class);
        this.thrown.expect(Matchers.rootCause(Is.is(IllegalStateException.class)));
        filter.init(this.filterConfig);
        filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
    }

    @Test
    public void init_application_failured_because_action_not_found() throws Exception {
        RenoFilter filter = new RenoFilter();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.packages");
                this.will(4.returnValue((Object)"jp.snowgoose.not.available"));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.factory.id");
                this.will(4.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.packages");
                this.will(4.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.suffix");
                this.will(4.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.provider");
                this.will(4.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.provider");
                this.will(4.returnValue(null));
            }
        });
        this.thrown.expect(ActionNotRegisterdException.class);
        filter.init(this.filterConfig);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void init_application_failured_because_addons_not_found() throws Exception {
        RenoFilter filter = new RenoFilter();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.packages");
                this.will(5.returnValue((Object)Calculator.class.getPackage().getName()));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.factory.id");
                this.will(5.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.packages");
                this.will(5.returnValue((Object)"jp.snowgoose.treno.metadata,jp.snowgoose.not.available"));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.suffix");
                this.will(5.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.action.provider");
                this.will(5.returnValue(null));
                ((FilterConfig)this.oneOf(RenoFilterTest.this.filterConfig)).getInitParameter("reno.config.components.provider");
                this.will(5.returnValue(null));
            }
        });
        this.thrown.expect(ResultNotRegisterdException.class);
        filter.init(this.filterConfig);
        this.mockery.assertIsSatisfied();
    }
}

