/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import jp.snowgoose.treno.context.ParameterConverters;
import jp.snowgoose.treno.context.RequestContext;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.context.RequestValueMappers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequestValueMappersTest {
    private Mockery context = new JUnit4Mockery();
    private HttpServletRequest request = (HttpServletRequest)this.context.mock(HttpServletRequest.class);
    private RequestContext requestContext = (RequestContext)this.context.mock(RequestContext.class);
    private RequestValueMapper valueMapperA = (RequestValueMapper)this.context.mock(RequestValueMapper.class, "requestValueMapperA");
    private RequestValueMapper valueMapperB = (RequestValueMapper)this.context.mock(RequestValueMapper.class, "requestValueMapperB");
    private RequestValueMapper valueMapperC = (RequestValueMapper)this.context.mock(RequestValueMapper.class, "requestValueMapperC");
    private ParameterConverters parameterConverters;
    private RequestValueMappers requestValueMappers;

    @Before
    public void setUp() {
        this.parameterConverters = new ParameterConverters((Collection)Collections.EMPTY_LIST);
        this.requestValueMappers = new RequestValueMappers(Arrays.asList(this.valueMapperA, this.valueMapperB, this.valueMapperC));
    }

    @Test
    public void request_matches_mapper_c() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestContext)this.allowing(RequestValueMappersTest.this.requestContext)).getRequest();
                this.will(1.returnValue((Object)RequestValueMappersTest.this.request));
                ((RequestValueMapper)this.oneOf(RequestValueMappersTest.this.valueMapperA)).requestSupported(RequestValueMappersTest.this.request);
                this.will(1.returnValue((Object)false));
                ((RequestValueMapper)this.oneOf(RequestValueMappersTest.this.valueMapperB)).requestSupported(RequestValueMappersTest.this.request);
                this.will(1.returnValue((Object)false));
                ((RequestValueMapper)this.oneOf(RequestValueMappersTest.this.valueMapperC)).requestSupported(RequestValueMappersTest.this.request);
                this.will(1.returnValue((Object)true));
                ((RequestValueMapper)this.oneOf(RequestValueMappersTest.this.valueMapperC)).setParameterConverters(RequestValueMappersTest.this.parameterConverters);
            }
        });
        RequestValueMapper actual = this.requestValueMappers.select(this.requestContext, this.parameterConverters);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)this.valueMapperC));
    }
}

