/*
 * Decompiled with CFR 0.152.
 */
package jp.snowgoose.treno.component;

import java.util.Arrays;
import jp.snowgoose.treno.annotation.BindValue;
import jp.snowgoose.treno.annotation.Direction;
import jp.snowgoose.treno.annotation.InvokeAction;
import jp.snowgoose.treno.annotation.InvokeActions;
import jp.snowgoose.treno.component.ActionInstance;
import jp.snowgoose.treno.component.Invoker;
import jp.snowgoose.treno.context.RequestValueMapper;
import jp.snowgoose.treno.exception.ActionInvocationException;
import jp.snowgoose.treno.junit.Matchers;
import jp.snowgoose.treno.junit.MockActionDescriptor;
import jp.snowgoose.treno.junit.MockBindDescriptor;
import jp.snowgoose.treno.metadata.BindDescriptor;
import jp.snowgoose.treno.metadata.BindDescriptors;
import jp.snowgoose.treno.metadata.MappedPath;
import jp.snowgoose.treno.metadata.Scope;
import jp.snowgoose.treno.result.InvocationResult;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class InvokerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private Invoker invoker;
    private final Mockery mockery = new JUnit4Mockery();
    private final RequestValueMapper valueMapper = (RequestValueMapper)this.mockery.mock(RequestValueMapper.class);
    private final ActionInstance actionInstance = (ActionInstance)this.mockery.mock(ActionInstance.class);
    private MockActionDescriptor actionDesc;

    @Before
    public void setUp() {
        this.actionDesc = new MockActionDescriptor();
        MockActionDescriptor.MockActionMethod actionMethod = new MockActionDescriptor.MockActionMethod();
        actionMethod.setActionClass(MockAction.class);
        actionMethod.setArgumentTypes(new Class[]{String.class});
        actionMethod.setMethodName("baz");
        this.actionDesc.setActionMethod(actionMethod);
        BindDescriptors bindDescriptors = new BindDescriptors();
        MockBindDescriptor name = new MockBindDescriptor();
        name.setBindElementType((BindDescriptor.BindElementType)new BindDescriptor.BindElementType.ParameterBindElement(0));
        name.setName("name");
        name.setParameterType(String.class);
        name.setScope(Scope.PARAMETER);
        bindDescriptors.put((BindDescriptor)name);
        MockBindDescriptor changedName = new MockBindDescriptor();
        changedName.setBindElementType((BindDescriptor.BindElementType)new BindDescriptor.BindElementType.MethodBindElement("setChangedName"));
        changedName.setName("changedName");
        changedName.setParameterType(String.class);
        changedName.setScope(Scope.REQUEST);
        bindDescriptors.put((BindDescriptor)changedName);
        MockBindDescriptor originalName = new MockBindDescriptor();
        originalName.setBindElementType((BindDescriptor.BindElementType)new BindDescriptor.BindElementType.FieldBindElement(2, "originalName"));
        originalName.setName("originalName");
        originalName.setParameterType(String.class);
        originalName.setScope(Scope.SESSION);
        bindDescriptors.put((BindDescriptor)originalName);
        this.actionDesc.setBindDescriptors(bindDescriptors);
        this.actionDesc.setMappedPath(new MappedPath("/foo/baa/baz.do"));
    }

    @Test
    public void invoke_normaly() throws Exception {
        this.invoker = new Invoker(this.actionInstance, this.valueMapper);
        final MockAction action = new MockAction();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ActionInstance)this.oneOf(InvokerTest.this.actionInstance)).prepereInvoke(InvokerTest.this.valueMapper);
                ((ActionInstance)this.oneOf(InvokerTest.this.actionInstance)).getActionDescriptor();
                this.will(1.returnValue((Object)((Object)InvokerTest.this.actionDesc)));
                ((ActionInstance)this.oneOf(InvokerTest.this.actionInstance)).getInstance();
                this.will(1.returnValue((Object)action));
                ((ActionInstance)this.allowing(InvokerTest.this.actionInstance)).getPreparedArgs();
                this.will(1.returnValue(Arrays.asList("snowgoose")));
            }
        });
        InvocationResult result = this.invoker.invoke();
        Assert.assertThat((Object)result.getResultStatus(), (Matcher)Is.is((Object)"success"));
        Assert.assertThat((Object)action.getChangedName(), (Matcher)Is.is((Object)"changedsnowgoose"));
        Assert.assertThat((Object)action.getOriginalName(), (Matcher)Is.is((Object)"originalsnowgoose"));
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void throws_exception_when_invoke() throws Exception {
        this.invoker = new Invoker(this.actionInstance, this.valueMapper);
        final MockExceptionAction action = new MockExceptionAction();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestValueMapper)this.oneOf(InvokerTest.this.valueMapper)).map(InvokerTest.this.actionInstance);
                ((ActionInstance)this.oneOf(InvokerTest.this.actionInstance)).prepereInvoke(InvokerTest.this.valueMapper);
                ((ActionInstance)this.oneOf(InvokerTest.this.actionInstance)).getActionDescriptor();
                this.will(2.returnValue((Object)((Object)InvokerTest.this.actionDesc)));
                ((ActionInstance)this.oneOf(InvokerTest.this.actionInstance)).getInstance();
                this.will(2.returnValue((Object)action));
                ((ActionInstance)this.oneOf(InvokerTest.this.actionInstance)).getPreparedArgs();
                this.will(2.returnValue((Object)new String[]{"snowgoose"}));
            }
        });
        this.thrown.expect(ActionInvocationException.class);
        this.thrown.expect(Matchers.rootCause(Is.is(IllegalStateException.class)));
        this.invoker.invoke();
    }

    @InvokeActions(value="/foo/baa/*")
    public static class MockExceptionAction {
        private String changedName;

        @InvokeAction(path="/baz.do", directions={@Direction(to="/foo/baa/success.do")})
        public String baz(@BindValue(value="name") String name) {
            throw new IllegalStateException("illegal state !");
        }

        @BindValue(scope=Scope.REQUEST)
        public String getChangedName() {
            return this.changedName;
        }

        public void setChangedName(String changedName) {
            this.changedName = changedName;
        }
    }

    @InvokeActions(value="/foo/baa/*")
    public static class MockAction {
        private String changedName;
        @BindValue(scope=Scope.SESSION)
        private String originalName = "original";

        @InvokeAction(path="/baz.do", directions={@Direction(to="/foo/baa/success.do")})
        public String baz(@BindValue(value="name") String name) {
            this.originalName = this.originalName + name;
            this.setChangedName("changed" + name);
            return "success";
        }

        @BindValue(scope=Scope.REQUEST)
        public String getChangedName() {
            return this.changedName;
        }

        public void setChangedName(String changedName) {
            this.changedName = changedName;
        }

        String getOriginalName() {
            return this.originalName;
        }
    }
}

