# PjcTaskPagination
require "pagination"
module ActionController
  module Pagination
   def task_paginate(collection_id,user,options,display_id,display_searching,*display_type)
      Pagination.validate_options!(collection_id, options, false)
      task_paginator_and_collection_for(collection_id,user,options,display_id,display_searching,*display_type)
   end
   def task_paginator_and_collection_for(collection_id, user, options,display_id,display_searching,*display_type) #:nodoc:
      klass = options[:class_name].constantize
      page  = (params[options[:parameter]] || 1).to_i    
      records = []
      level = 1
      level_advance = ""
      klass.find(:all, :conditions => options[:conditions],
                       :order => options[:order_by] || options[:order],
                       :joins => options[:join] || options[:joins],
                       :include => options[:include],
                       :select => options[:select],
                       :group => options[:group]).each do |pre_row|
                           if display_type[0] !="PERSON_LIST"
                             if pre_row.segment_id.to_i > 0 && pre_row.parent != nil
                               pre_ancestors = pre_row.ancestors
                               if pre_ancestors.length > 0
                                 records += pre_ancestors
                               end
                             end
                           end
                           records << pre_row
                       end
      records=records.uniq
      record_all = []
      if display_type[0] !="PERSON_LIST"
         records.each do |record|
            level = record.task_level unless level_advance == nil
            if record.task_level <= level
               record_all << record
               level_advance = ""
               if record.task_open_and_shut(user.person_id,display_id).to_i == 1
                  level = record.task_level
                  level_advance = nil
               end
            end
         end
      else
          record_all =records
      end
      count =record_all.length
      paginator = Paginator.new(self, count, options[:per_page], page)
      last_page = count.to_i%options[:per_page].to_i
      pages = (count / options[:per_page].to_i).to_i
      pages += 1 if last_page != 0 || pages == 0
      
      if pages == 1
        start_date = 0
      elsif page > pages
        start_date = (pages - 1) * options[:per_page].to_i
      else
        start_date = (page - 1) * options[:per_page].to_i
      end
      collection =record_all[start_date,options[:per_page]]
      return paginator, collection 
    end
      
    private :paginator_and_collection_for
  end
end
