# PjcChecklistPagination
require "pagination"
module ActionController
  module Pagination
    
    def checklist_task_paginate(collection_id, options={})
      Pagination.validate_options!(collection_id, options, false)
      checklist_task_paginator_and_collection_for(collection_id, options)
    end
    
    def checklist_task_paginator_and_collection_for(collection_id, options)
      klass = options[:class_name].constantize
      page  = params[options[:parameter]].to_i
      count = klass.count(:conditions => options[:conditions],
                  :joins => options[:join] || options[:joins],
                  :include => options[:include],
                  :select => (options[:group] ? "DISTINCT #{options[:group]}" : options[:count]))
      count += 1
      paginator = Paginator.new(self, count, options[:per_page], page)

      all_date = klass.find(:all, :conditions => options[:conditions],
                 :order => options[:order_by] || options[:order],
                 :joins => options[:join] || options[:joins], :include => options[:include],
                 :select => options[:select],
                 :group => options[:group], :offset => paginator.current.offset)

      all_date ||= klass.new
      all_date.unshift("")
      
      last_page = count.to_i%options[:per_page].to_i
      pages = (count / options[:per_page].to_i).to_i
      pages += 1 if last_page != 0 || pages == 0
      
      if pages == 1
        start_date = 0
      elsif page > pages
        start_date = (pages - 1) * options[:per_page].to_i
      else
        start_date = (page - 1) * options[:per_page].to_i
      end
      
      collection = all_date[start_date,options[:per_page]]

      return paginator, collection
    end

    def checklist_count_collection_for_pagination(model, options,list)
      c = model.count(:conditions => options[:conditions],
                  :joins => options[:join] || options[:joins],
                  :include => options[:include],
                  :select => (options[:group] ? "DISTINCT #{options[:group]}" : options[:count]))
      c += 1 if list == "TASK_LIST"
      return c
    end
    
    def checklist_judgment_paginate(collection_id, user, options,*display_type)
      Pagination.validate_options!(collection_id, options, false)
      checklist_judgment_paginator_and_collection_for(collection_id, user, options,*display_type)
    end
    
    def checklist_judgment_paginator_and_collection_for(collection_id, user, options,*display_type)

      
    end
    private :paginator_and_collection_for
    
    def checklist_paginator_and_collection_for(collection_id, user, options,*display_type)

    end
  end
end
