class ModelGraphGenerator < Rails::Generator::NamedBase
  def initialize(runtime_args, runtime_options = {})
    base_name = 'model_graph'
    runtime_args.unshift(base_name)
    super
  end

  def manifest
    class_base = "#{class_name}Controller"
    file_base = "#{file_name}_controller"
    record do |m|
      m.class_collisions(class_path, class_base, "#{class_base}Test")

      m.directory File.join('app/controllers', class_path)
      m.directory File.join('test/functional', class_path)

      m.template 'controller.rb',
        File.join('app/controllers', class_path, "#{file_base}.rb")
      m.template 'functional_test.rb',
        File.join('test/functional', class_path, "#{file_base}_test.rb")
    end
  end
end
