# == Schema Information
# Schema version: 46
#
# Table name: po_translations
#
#  id            :integer       not null, primary key
#  type          :string(255)   not null
#  po_message_id :integer       not null
#  msgstr        :string(255)
#  msgstr_0      :string(255)
#  msgstr_1      :string(255)
#  msgstr_2      :string(255)
#  msgstr_3      :string(255)
#  created_at    :string(14)
#  updated_at    :string(14)
#  created_by    :integer
#  updated_by    :integer
#

class WfPoTranslationJa < WfPoTranslation
  include ActiveRecord::Acts::Translation::Ja

  def entry
    x = "DB|#{po_message.msgid}"
    result = "msgid #{x.inspect}\n"
    if po_message.class Wf== PoMessageSingular
      result << "msgstr #{msgstr.inspect}\n"
    else
      result << "msgid_plural #{po_message.msgid_plural.inspect}\n"
      result << "msgstr[0] #{msgstr_0.inspect}\n"
    end
    return result
  end
end
