# -*- coding: utf-8 -*-
require "test/init"
require "init"
require "language"
require "wf_language"

# load languages at first
Test::Unit::TestCase.fixtures(:languages, :wf_languages)

require "coffee"
require "po_message"
require "po_message_singular"
require "po_translation"
[:ja, :zh, :ko, :en, :fr, :es, :ar, :pt, :de, :ru].each do |code|
  require "po_translation_#{code}"
end

require "wf_coffee"
require "wf_po_message"
require "wf_po_message_singular"
require "wf_po_translation"
[:ja, :zh, :ko, :en, :fr, :es, :ar, :pt, :de, :ru].each do |code|
  require "wf_po_translation_#{code}"
end

class ActsAsTranslatedTest < Test::Unit::TestCase
  fixtures :coffees, :po_messages, :po_translations,
           :wf_coffees, :wf_po_messages, :wf_po_translations

  def test_name
    assert_equal Coffee.find(1).name, "Fire"
  end

  def test_name_locale
    c = Coffee.find(1)
    assert_equal "ファイア", c.name_("ja")
    assert_equal "ファイア", c.name_ja
    assert_equal "日本", c.country_(:ja)
    assert_equal "日本", c.country_ja
    assert !c.name_ar
    assert !c.name_("ar")
  end

  def test_after_update
    c = Coffee.find(2)
    c.name_ja = "ブルーマウンテン"
    c.country_ja = "アフリカ"
    assert c.save
    d = Coffee.find(2)
    assert_equal "ブルーマウンテン", d.name_ja
    assert_equal "アフリカ", d.country_ja
  end

  def test_ja
    assert_equal 1, PoTranslationJa.nplurals
    assert_equal "0", PoTranslationJa.plural
  end

  def test_prefix_name
    assert_equal WfCoffee.find(1).name, "Fire"
  end

  def test_prefix_name_locale
    c = WfCoffee.find(1)
    assert_equal "ファイア", c.name_ja
    assert_equal "ファイア", c.name_("ja")
    assert_equal "日本", c.country_ja
    assert_equal "日本", c.country_(:ja)
    assert !c.name_ar
    assert !c.name_("ar")
  end

  def test_prefix_after_update
    c = WfCoffee.find(2)
    c.name_ja = "ブルーマウンテン"
    c.country_ja = "アフリカ"
    assert c.save!
    d = WfCoffee.find(2)
    assert_equal "ブルーマウンテン", d.name_ja
    assert_equal "アフリカ", d.country_ja
  end

  def test_prefix_ja
    assert_equal 1, WfPoTranslationJa.nplurals
    assert_equal "0", WfPoTranslationJa.plural
  end

  def test_prefix_no_locale
    c = WfCoffee.find(1)
    assert_raise(NoMethodError){ c.name_xx }
  end

  def test_prefix_no_match
    c = WfCoffee.find(1)
    assert_raise(NoMethodError){ c.xxxx_xx_xxx }
  end

  def test_xxx
    lang1 = Language.find(1)
    lang1.name_ja       # method_missing
    lang1.code = 'JA'
    assert lang1.save
    lang2 = Language.find(1)
    assert_equal lang1.name_ja, lang2.name_ja
  end
end
