require 'test_helper'
require 'tax_calculation'

class TaxCalculationTest < ActiveSupport::TestCase
  fixtures :tax_rates, :account_items

  def test_compute_gross_of_tax__compute
    assert_equal [105, 5], TaxCalculation.compute_gross_of_tax(100, account_items(:gross_of_tax).id, '20081122')
  end

  def test_compute_gross_of_tax__not_compute
    assert_equal [100, 0], TaxCalculation.compute_gross_of_tax(100, account_items(:net_of_tax).id, '20081122')
  end

  def test_compute_gross_of_tax__not_out_of_date
    assert_equal [100, 0], TaxCalculation.compute_gross_of_tax(100, account_items(:gross_of_tax).id, '19801122')
  end

  def test_compute_net_of_tax__compute
    assert_equal 96, TaxCalculation.compute_net_of_tax(100, account_items(:gross_of_tax).id, '20081122')
  end

  def test_compute_net_of_tax__not_compute
    assert_equal 100, TaxCalculation.compute_net_of_tax(100, account_items(:net_of_tax).id, '20081122')
  end

  def test_compute_net_of_tax__not_out_of_date
    assert_equal 100, TaxCalculation.compute_net_of_tax(100, account_items(:net_of_tax).id, '19801122')
  end
end
