# -*- coding: utf-8 -*-
# app/models/storage_object.rb のクラス StorageObject をテストする。

require 'test_helper'

class StorageObjectTest < ActiveSupport::TestCase
  include TemporaryFile

  fixtures :domains, :config_attachments, :storages, :storage_objects

  # StorageObject#path でファイルのパスを取得することをテストする。
  def test_path
    p1 = Pathname.new(RAILS_ROOT) + "tmp/1"
    assert_equal p1.to_s, StorageObject.find(1).path
  end

  # StorageObject#store でファイルを保存することをテストする。
  def test_store
    with_temporary_file(1, false) do
      so = StorageObject.find(1)
      x = StringIO.new "foo_bar"
      def x.original_filename
        "baz"
      end
      assert so.store(x)
    end
  end

  # StorageObject#store でファイル名を検証することをテストする。
  def test_store__filename_error
    so = StorageObject.new(:name => "a" * 1024)
    assert_raise(ConfigAttachment::FilenameMaximumBytesizeError) {so.store(mock)}
    assert so.new_record?
  end

  # StorageObject#content でファイルを内容を返すことをテストする。
  def test_content
    data = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
    with_temporary_file(2, data) do
      assert_equal data, StorageObject.find(2).content
    end
  end

  # StorageObject#copy で StorageObject のコピーを返すことをテストする。
  def test_copy
    with_temporary_file(1, "too short") do
      assert !StorageObject.find(1).copy
    end
    with_temporary_file(2, "yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy") do
      assert StorageObject.find(2).copy.is_a?(StorageObject)
    end
  end
end
