# -*- coding: utf-8 -*-
# lib/simple_table.rb のクラス SimpleTable をテストする。

require 'test_helper'

class SimpleTableTest < ActiveSupport::TestCase

  def setup
    @simple_table = SimpleTable.new
  end

  def teardown
  end

  # SimpleTable のインスタンスが既定の状態では1つの行を返すことをテストする。
  def test_row_size
    assert_equal 1, @simple_table.row_size
  end

  # SimpleTable のインスタンスが既定の状態では1つの列を返すことをテストする。
  def test_column_size
    assert_equal 1, @simple_table.column_size
  end

  # SimpleTable のインスタンスが既定の状態では高さ0.0を持つことをテストする。
  def test_row_height
    assert_equal [0.0], @simple_table.row_height
  end

  # SimpleTable のインスタンスが既定の状態では幅0.0を持つことをテストする。
  def test_column_width
    assert_equal [0.0], @simple_table.column_width
  end

  # SimpleTable#[] が動作することをテストする。
  def test_access_by_key
    x = @simple_table[0]
    assert_kind_of Array, x
    assert_equal 1, x.size
    assert_kind_of SimpleCell, x[0]
    assert_equal "", x[0].text
    y = @simple_table[0, 0]
    assert_kind_of SimpleCell, y
    assert_equal "", y.text
  end

  # SimpleTable#each_index で各行各列にアクセスできることをテストする。
  def test_each_index
    count = 0
    @simple_table.each_index do |x|
      assert_equal 1, @simple_table[x].size
      assert_kind_of SimpleCell, @simple_table[x][0]
      assert_equal "", @simple_table[x][0].text
      count += 1
    end
    assert_equal 1, count
  end

  # SimpleTable#set_contents で各セルの値を与えることをテストする。
  def test_set_contents
    @simple_table.set_contents do |r, c|
      SimpleCell.new("done")
    end
    x = @simple_table[0, 0]
    assert_kind_of SimpleCell, x
    assert_equal "done", x.text
  end

  # SimpleTable#split でページの枠内に収まるようにテーブルを分割することをテストする。
  def test_split
    matrix = @simple_table.split(100, 50)
    assert_kind_of Array, matrix
    assert_equal 1, matrix.size
    assert_kind_of Array, matrix[0]
    assert_equal 1, matrix[0].size
    assert_kind_of SimpleTable, matrix[0][0]
  end

  # SimpleTable#split_horizontally でページを水平方向に分割することをテストする。
  def test_split_horizontally
    tables = @simple_table.split_horizontally(100)
    assert_kind_of Array, tables
    assert_equal 1, tables.size
    assert_kind_of SimpleTable, tables[0]
  end

  # SimpleTable#split_vertically でページを垂直方向に分割することをテストする。
  def test_split_vertically
    tables = @simple_table.split_vertically(100)
    assert_kind_of Array, tables
    assert_equal 1, tables.size
    assert_kind_of SimpleTable, tables[0]
  end
end
