# -*- coding: utf-8 -*-
# lib/simple_table_pdf.rb のクラス SimpleTablePdf をテストする。

require 'test_helper'

class SimpleTablePDFTest < ActiveSupport::TestCase

  TEXT = [
    "hello, world!",
  ]

  PRIMITIVE_OPTIONS = [
    {:color_flag => false, :offset_x => 12, :offset_y => 2.05},
  ]

  PRIMITIVE = [
    "BT 12.00 2.05 Td (hello, world!) Tj ET",
  ]

  # SimpleTablePDF#construct_primitive が PDF に埋め込む文字列を返すことをテストする。
  def test_construct_primitive
    pdf = SimpleTablePDF.new
    TEXT.zip(PRIMITIVE_OPTIONS, PRIMITIVE).each do |text, options, expected|
      assert_equal expected, pdf.__send__("construct_primitive", text, options)
    end
  end

  # SimpleTablePDF#output が PDF の内容を出力することをテストする。
  def test_output
    header = SimplePDF::TextBox.new("%t", 8,
                                    :align => :left,
                                    :top_margin => 5.0,
                                    :left_margin => 10.0,
                                    :right_margin => 10.0)
    footer = SimplePDF::TextBox.new("%p/%P", 8,
                                    :align => :center,
                                    :top_margin => -20.0,
                                    :left_margin => 10.0,
                                    :right_margin => 10.0)
    contents = [["Givenaaaaaaaaaa", "Family","Sex"],
      ["Takashi", "中本", "Male"],
      ["Seiya", "Maeda", "Ma%Ple"],
      ["Seiya", "Maeda", "Male"],
      ["http://www.good-day.co.jp/\nGood-day Inc.", "Maeda", "Male"],
      ["Seiya1", "Maeda", "Male"],
      ["Seiya2", "Maeda", "Male"],
      ["Seiya3", "Maeda", "Male"],
      ["Seiya4", "Maeda", "Male"],
      ["Seiya5", "Maeda", "Male"],
      ["Seiya6", "Maeda", "Male"],
      ["Seiya7", "Maeda", "Male"],
      ["Seiya8", "Maeda", "Male"],
      ["Seiya9", "Maeda", "Male"],
      ["Seiya10", "Maeda", "Male"],
      ["Seiya11", "Maeda", "Male"],
      ["Seiya12\nSeiya\nSeiyan" + ("a\n" * 100) + "Seiya", "Maeda", "Male"],
      ["Meguru", "Maeda", "Female"]]
    table_header_style = SimpleCellStyle.new(:border_color => [0, 0, 0],
                                             :text_color => [0, 0, 0],
                                             :fill_color => [200, 200, 200],
                                             :top_margin => 2.0,
                                             :bottom_margin => 2.0,
                                             :left_margin => 2.0,
                                             :right_margin => 2.0,
                                             :align => :center,
                                             :font_size => 20.0,
                                             :line_height => 8.0)
    table_cell_style =  SimpleCellStyle.new(:border_color => [0, 0, 0],
                                            :text_color => [0, 0, 0],
                                            :fill_color => nil,
                                            :top_margin => 2.0,
                                            :bottom_margin => 2.0,
                                            :left_margin => 2.0,
                                            :right_margin => 2.0,
                                            :align => :left,
                                            :font_size => 20.0,
                                            :line_height => 10.0)
    table = SimpleTable.new(contents.size, 3)
    table.set_contents do |row, col|
      if row == 0
        style = table_header_style
        link = "http://www.good-day.co.jp"
      else
        style = table_cell_style
        link = nil
      end
      SimpleCell.new(contents[row][col], style, link)
    end
    
    pdf = SimpleTablePDF.new(:orientation => "Portrait",
                             :format => "A4",
                             :language => "Japanese",
                             :title => "タイトル",
                             :author => "中本崇志",
                             :creator => "PjC",
                             :keywords => ["PjC", "テスト"],
                             :subject => "サブタイトル",
                             :zoom => "fullpage",
                             :header => header,
                             :footer => footer,
                             :table => table,
                             :top_margin => 25.0, # mm
                             :left_margin => 20.0, # mm
                             :right_margin => 20.0, # mm
                             :bottom_margin => 30.0, # mm
                             :page_order => 0)

    File.open("test/fixtures/files/simple_table_pdf_test.pdf", "rb") do |f|
      expected = f.read
      value = pdf.output
      expected.gsub!(/CreationDate(.+)$/, "")
      value.gsub!(/CreationDate(.+)$/, "")
      assert_equal expected, value
    end
  end
end
